/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.SingleThreadEventLoop;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalServerChannel;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import java.net.SocketAddress;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.function.Executable;

public abstract class AbstractSingleThreadEventLoopTest {
    private static final Runnable NOOP = new Runnable(){

        @Override
        public void run() {
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void testChannelsRegistered() throws Exception {
        EventLoopGroup group = this.newEventLoopGroup();
        SingleThreadEventLoop loop = (SingleThreadEventLoop)group.next();
        try {
            boolean channelCountSupported;
            Channel ch1 = this.newChannel();
            Channel ch2 = this.newChannel();
            int rc = AbstractSingleThreadEventLoopTest.registeredChannels(loop);
            boolean bl = channelCountSupported = rc != -1;
            if (channelCountSupported) {
                Assertions.assertEquals((int)0, (int)AbstractSingleThreadEventLoopTest.registeredChannels(loop));
            }
            Assertions.assertTrue((boolean)loop.register(ch1).syncUninterruptibly().isSuccess());
            Assertions.assertTrue((boolean)loop.register(ch2).syncUninterruptibly().isSuccess());
            if (channelCountSupported) {
                AbstractSingleThreadEventLoopTest.checkNumRegisteredChannels(loop, 2);
            }
            Assertions.assertTrue((boolean)ch1.deregister().syncUninterruptibly().isSuccess());
            if (channelCountSupported) {
                AbstractSingleThreadEventLoopTest.checkNumRegisteredChannels(loop, 1);
            }
        }
        finally {
            group.shutdownGracefully();
        }
    }

    private static void checkNumRegisteredChannels(SingleThreadEventLoop loop, int numChannels) throws Exception {
        while (AbstractSingleThreadEventLoopTest.registeredChannels(loop) != numChannels) {
            Thread.sleep(50L);
        }
    }

    private static int registeredChannels(final SingleThreadEventLoop loop) throws Exception {
        return (Integer)loop.submit((Callable)new Callable<Integer>(){

            @Override
            public Integer call() {
                return loop.registeredChannels();
            }
        }).get(1L, TimeUnit.SECONDS);
    }

    @Test
    public void shutdownBeforeStart() throws Exception {
        EventLoopGroup group = this.newEventLoopGroup();
        Assertions.assertFalse((boolean)group.awaitTermination(2L, TimeUnit.MILLISECONDS));
        group.shutdown();
        Assertions.assertTrue((boolean)group.awaitTermination(200L, TimeUnit.MILLISECONDS));
    }

    @Test
    public void shutdownGracefullyZeroQuietBeforeStart() throws Exception {
        EventLoopGroup group = this.newEventLoopGroup();
        Assertions.assertTrue((boolean)group.shutdownGracefully(0L, 2L, TimeUnit.SECONDS).await(200L));
    }

    @Test
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void testShutdownGracefullyNoQuietPeriod() throws Exception {
        EventLoopGroup loop = this.newEventLoopGroup();
        ServerBootstrap b = new ServerBootstrap();
        ((ServerBootstrap)b.group(loop).channel(this.serverChannelClass())).childHandler((ChannelHandler)new ChannelInboundHandlerAdapter());
        ChannelFuture cf = this.serverChannelClass() == LocalServerChannel.class ? b.bind((SocketAddress)new LocalAddress("local")) : b.bind(0);
        cf.sync().channel();
        Future f = loop.shutdownGracefully(0L, 1L, TimeUnit.MINUTES);
        Assertions.assertTrue((boolean)loop.awaitTermination(600L, TimeUnit.MILLISECONDS));
        Assertions.assertTrue((boolean)f.syncUninterruptibly().isSuccess());
        Assertions.assertTrue((boolean)loop.isShutdown());
        Assertions.assertTrue((boolean)loop.isTerminated());
    }

    @Test
    public void shutdownGracefullyBeforeStart() throws Exception {
        EventLoopGroup group = this.newEventLoopGroup();
        Assertions.assertTrue((boolean)group.shutdownGracefully(200L, 1000L, TimeUnit.MILLISECONDS).await(500L));
    }

    @Test
    public void gracefulShutdownAfterStart() throws Exception {
        EventLoop loop = this.newEventLoopGroup().next();
        final CountDownLatch latch = new CountDownLatch(1);
        loop.execute(new Runnable(){

            @Override
            public void run() {
                latch.countDown();
            }
        });
        latch.await();
        loop.shutdownGracefully(200L, 3000L, TimeUnit.MILLISECONDS);
        Assertions.assertTrue((boolean)loop.awaitTermination(500L, TimeUnit.MILLISECONDS));
        AbstractSingleThreadEventLoopTest.assertRejection((EventExecutor)loop);
    }

    @Test
    @Timeout(value=3000L, unit=TimeUnit.MILLISECONDS)
    public void testChannelsIteratorEmpty() throws Exception {
        Assumptions.assumeTrue((boolean)this.supportsChannelIteration());
        EventLoopGroup group = this.newEventLoopGroup();
        final SingleThreadEventLoop loop = (SingleThreadEventLoop)group.next();
        try {
            AbstractSingleThreadEventLoopTest.runBlockingOn((EventLoop)loop, new Runnable(){

                @Override
                public void run() {
                    final Iterator iterator = loop.registeredChannelsIterator();
                    Assertions.assertFalse((boolean)iterator.hasNext());
                    Assertions.assertThrows(NoSuchElementException.class, (Executable)new Executable(){

                        public void execute() {
                            iterator.next();
                        }
                    });
                }
            });
        }
        finally {
            group.shutdownGracefully();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=3000L, unit=TimeUnit.MILLISECONDS)
    public void testChannelsIterator() throws Exception {
        Assumptions.assumeTrue((boolean)this.supportsChannelIteration());
        EventLoopGroup group = this.newEventLoopGroup();
        final SingleThreadEventLoop loop = (SingleThreadEventLoop)group.next();
        try {
            final Channel ch1 = this.newChannel();
            final Channel ch2 = this.newChannel();
            loop.register(ch1).syncUninterruptibly();
            loop.register(ch2).syncUninterruptibly();
            Assertions.assertEquals((int)2, (int)AbstractSingleThreadEventLoopTest.registeredChannels(loop));
            AbstractSingleThreadEventLoopTest.runBlockingOn((EventLoop)loop, new Runnable(){

                @Override
                public void run() {
                    final Iterator iterator = loop.registeredChannelsIterator();
                    Assertions.assertTrue((boolean)iterator.hasNext());
                    Channel actualCh1 = (Channel)iterator.next();
                    Assertions.assertNotNull((Object)actualCh1);
                    Assertions.assertTrue((boolean)iterator.hasNext());
                    Channel actualCh2 = (Channel)iterator.next();
                    Assertions.assertNotNull((Object)actualCh2);
                    HashSet<Channel> expected = new HashSet<Channel>(4);
                    expected.add(ch1);
                    expected.add(ch2);
                    expected.remove(actualCh1);
                    expected.remove(actualCh2);
                    Assertions.assertTrue((boolean)expected.isEmpty());
                    Assertions.assertFalse((boolean)iterator.hasNext());
                    Assertions.assertThrows(NoSuchElementException.class, (Executable)new Executable(){

                        public void execute() {
                            iterator.next();
                        }
                    });
                }
            });
        }
        finally {
            group.shutdownGracefully();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=3000L, unit=TimeUnit.MILLISECONDS)
    public void testChannelsIteratorRemoveThrows() throws Exception {
        Assumptions.assumeTrue((boolean)this.supportsChannelIteration());
        EventLoopGroup group = this.newEventLoopGroup();
        final SingleThreadEventLoop loop = (SingleThreadEventLoop)group.next();
        try {
            Channel ch = this.newChannel();
            loop.register(ch).syncUninterruptibly();
            Assertions.assertEquals((int)1, (int)AbstractSingleThreadEventLoopTest.registeredChannels(loop));
            AbstractSingleThreadEventLoopTest.runBlockingOn((EventLoop)loop, new Runnable(){

                @Override
                public void run() {
                    Assertions.assertThrows(UnsupportedOperationException.class, (Executable)new Executable(){

                        public void execute() {
                            loop.registeredChannelsIterator().remove();
                        }
                    });
                }
            });
        }
        finally {
            group.shutdownGracefully();
        }
    }

    private static void runBlockingOn(EventLoop eventLoop, final Runnable action) {
        final Promise promise = eventLoop.newPromise();
        eventLoop.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    action.run();
                    promise.setSuccess(null);
                }
                catch (Throwable t) {
                    promise.tryFailure(t);
                }
            }
        });
        try {
            promise.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        Throwable cause = promise.cause();
        if (cause != null) {
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    private static void assertRejection(EventExecutor loop) {
        try {
            loop.execute(NOOP);
            Assertions.fail((String)"A task must be rejected after shutdown() is called.");
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    protected boolean supportsChannelIteration() {
        return false;
    }

    protected abstract EventLoopGroup newEventLoopGroup();

    protected abstract Channel newChannel();

    protected abstract Class<? extends ServerChannel> serverChannelClass();
}

