/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport.socket;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOption;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.channel.socket.oio.OioDatagramChannel;
import io.netty.testsuite.transport.AbstractComboTestsuiteTest;
import io.netty.testsuite.transport.TestsuitePermutation;
import io.netty.testsuite.transport.socket.AbstractDatagramTest;
import io.netty.testsuite.transport.socket.SocketTestPermutation;
import io.netty.util.internal.SocketUtils;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class DatagramMulticastTest
extends AbstractDatagramTest {
    @Test
    public void testMulticast(TestInfo testInfo) throws Throwable {
        this.run(testInfo, new AbstractComboTestsuiteTest.Runner<Bootstrap, Bootstrap>(){

            @Override
            public void run(Bootstrap bootstrap, Bootstrap bootstrap2) throws Throwable {
                DatagramMulticastTest.this.testMulticast(bootstrap, bootstrap2);
            }
        });
    }

    public void testMulticast(Bootstrap sb, Bootstrap cb) throws Throwable {
        NetworkInterface iface = this.multicastNetworkInterface();
        Assumptions.assumeTrue((iface != null ? 1 : 0) != 0, (String)("No NetworkInterface found that supports multicast and " + this.socketInternetProtocalFamily()));
        MulticastTestHandler mhandler = new MulticastTestHandler();
        sb.handler((ChannelHandler)new SimpleChannelInboundHandler<Object>(){

            public void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
            }
        });
        cb.handler((ChannelHandler)mhandler);
        sb.option(ChannelOption.IP_MULTICAST_IF, (Object)iface);
        sb.option(ChannelOption.SO_REUSEADDR, (Object)true);
        cb.option(ChannelOption.IP_MULTICAST_IF, (Object)iface);
        cb.option(ChannelOption.SO_REUSEADDR, (Object)true);
        DatagramChannel sc = (DatagramChannel)sb.bind((SocketAddress)this.newSocketAddress(iface)).sync().channel();
        Assertions.assertEquals((Object)iface, (Object)sc.config().getNetworkInterface());
        DatagramMulticastTest.assertInterfaceAddress(iface, sc.config().getInterface());
        InetSocketAddress addr = sc.localAddress();
        cb.localAddress(addr.getPort());
        if (sc instanceof OioDatagramChannel) {
            sc.close().awaitUninterruptibly();
            return;
        }
        DatagramChannel cc = (DatagramChannel)cb.bind().sync().channel();
        Assertions.assertEquals((Object)iface, (Object)cc.config().getNetworkInterface());
        DatagramMulticastTest.assertInterfaceAddress(iface, cc.config().getInterface());
        InetSocketAddress groupAddress = SocketUtils.socketAddress((String)this.groupAddress(), (int)addr.getPort());
        cc.joinGroup(groupAddress, iface).sync();
        sc.writeAndFlush((Object)new io.netty.channel.socket.DatagramPacket(Unpooled.copyInt((int)1), groupAddress)).sync();
        Assertions.assertTrue((boolean)mhandler.await());
        cc.leaveGroup(groupAddress, iface).sync();
        Thread.sleep(1000L);
        sc.writeAndFlush((Object)new io.netty.channel.socket.DatagramPacket(Unpooled.copyInt((int)1), groupAddress)).sync();
        mhandler.await();
        cc.config().setLoopbackModeDisabled(false);
        sc.config().setLoopbackModeDisabled(false);
        Assertions.assertFalse((boolean)cc.config().isLoopbackModeDisabled());
        Assertions.assertFalse((boolean)sc.config().isLoopbackModeDisabled());
        cc.config().setLoopbackModeDisabled(true);
        sc.config().setLoopbackModeDisabled(true);
        Assertions.assertTrue((boolean)cc.config().isLoopbackModeDisabled());
        Assertions.assertTrue((boolean)sc.config().isLoopbackModeDisabled());
        sc.close().awaitUninterruptibly();
        cc.close().awaitUninterruptibly();
    }

    private static void assertInterfaceAddress(NetworkInterface networkInterface, InetAddress expected) {
        Enumeration<InetAddress> addresses = networkInterface.getInetAddresses();
        while (addresses.hasMoreElements()) {
            if (!expected.equals(addresses.nextElement())) continue;
            return;
        }
        Assertions.fail();
    }

    @Override
    protected List<TestsuitePermutation.BootstrapComboFactory<Bootstrap, Bootstrap>> newFactories() {
        return SocketTestPermutation.INSTANCE.datagram(this.socketInternetProtocalFamily());
    }

    private InetSocketAddress newAnySocketAddress() throws UnknownHostException {
        switch (this.socketInternetProtocalFamily()) {
            case IPv4: {
                return new InetSocketAddress(InetAddress.getByName("0.0.0.0"), 0);
            }
            case IPv6: {
                return new InetSocketAddress(InetAddress.getByName("::"), 0);
            }
        }
        throw new AssertionError();
    }

    private InetSocketAddress newSocketAddress(NetworkInterface iface) {
        Enumeration<InetAddress> addresses = iface.getInetAddresses();
        while (addresses.hasMoreElements()) {
            InetAddress address = addresses.nextElement();
            if (!this.socketInternetProtocalFamily().addressType().isAssignableFrom(address.getClass())) continue;
            return new InetSocketAddress(address, 0);
        }
        throw new AssertionError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NetworkInterface multicastNetworkInterface() throws IOException {
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            NetworkInterface iface = interfaces.nextElement();
            if (!iface.isUp() || !iface.supportsMulticast()) continue;
            Enumeration<InetAddress> addresses = iface.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress address = addresses.nextElement();
                if (!this.socketInternetProtocalFamily().addressType().isAssignableFrom(address.getClass())) continue;
                MulticastSocket socket = new MulticastSocket(this.newAnySocketAddress());
                socket.setReuseAddress(true);
                socket.setNetworkInterface(iface);
                try {
                    socket.send(new DatagramPacket(new byte[]{1, 2, 3, 4}, 4, new InetSocketAddress(this.groupAddress(), 12345)));
                    NetworkInterface networkInterface = iface;
                    return networkInterface;
                }
                catch (IOException iOException) {}
                continue;
                finally {
                    socket.close();
                }
            }
        }
        return null;
    }

    private String groupAddress() {
        return this.groupInternetProtocalFamily() == InternetProtocolFamily.IPv4 ? "230.0.0.1" : "FF01:0:0:0:0:0:0:101";
    }

    private static final class MulticastTestHandler
    extends SimpleChannelInboundHandler<io.netty.channel.socket.DatagramPacket> {
        private final CountDownLatch latch = new CountDownLatch(1);
        private boolean done;
        private volatile boolean fail;

        private MulticastTestHandler() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, io.netty.channel.socket.DatagramPacket msg) throws Exception {
            if (this.done) {
                this.fail = true;
            }
            Assertions.assertEquals((int)1, (int)((ByteBuf)msg.content()).readInt());
            this.latch.countDown();
            this.done = true;
        }

        public boolean await() throws Exception {
            boolean success = this.latch.await(10L, TimeUnit.SECONDS);
            if (this.fail) {
                Assertions.fail();
            }
            return success;
        }
    }
}

