/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport.socket;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.DatagramChannel;
import io.netty.testsuite.transport.AbstractComboTestsuiteTest;
import io.netty.testsuite.transport.socket.AbstractDatagramTest;
import io.netty.util.CharsetUtil;
import io.netty.util.NetUtil;
import io.netty.util.internal.EmptyArrays;
import java.net.BindException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.UnresolvedAddressException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.Assumptions;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.opentest4j.TestAbortedException;

public abstract class DatagramUnicastTest
extends AbstractDatagramTest {
    private static final byte[] BYTES = new byte[]{0, 1, 2, 3};

    @Test
    public void testSimpleSendDirectByteBuf(TestInfo testInfo) throws Throwable {
        this.run(testInfo, new AbstractComboTestsuiteTest.Runner<Bootstrap, Bootstrap>(){

            @Override
            public void run(Bootstrap bootstrap, Bootstrap bootstrap2) throws Throwable {
                DatagramUnicastTest.this.testSimpleSendDirectByteBuf(bootstrap, bootstrap2);
            }
        });
    }

    public void testSimpleSendDirectByteBuf(Bootstrap sb, Bootstrap cb) throws Throwable {
        this.testSimpleSend(sb, cb, Unpooled.directBuffer().writeBytes(BYTES), true, BYTES, 1);
        this.testSimpleSend(sb, cb, Unpooled.directBuffer().writeBytes(BYTES), true, BYTES, 4);
    }

    @Test
    public void testSimpleSendHeapByteBuf(TestInfo testInfo) throws Throwable {
        this.run(testInfo, new AbstractComboTestsuiteTest.Runner<Bootstrap, Bootstrap>(){

            @Override
            public void run(Bootstrap bootstrap, Bootstrap bootstrap2) throws Throwable {
                DatagramUnicastTest.this.testSimpleSendHeapByteBuf(bootstrap, bootstrap2);
            }
        });
    }

    public void testSimpleSendHeapByteBuf(Bootstrap sb, Bootstrap cb) throws Throwable {
        this.testSimpleSend(sb, cb, Unpooled.buffer().writeBytes(BYTES), true, BYTES, 1);
        this.testSimpleSend(sb, cb, Unpooled.buffer().writeBytes(BYTES), true, BYTES, 4);
    }

    @Test
    public void testSimpleSendCompositeDirectByteBuf(TestInfo testInfo) throws Throwable {
        this.run(testInfo, new AbstractComboTestsuiteTest.Runner<Bootstrap, Bootstrap>(){

            @Override
            public void run(Bootstrap bootstrap, Bootstrap bootstrap2) throws Throwable {
                DatagramUnicastTest.this.testSimpleSendCompositeDirectByteBuf(bootstrap, bootstrap2);
            }
        });
    }

    public void testSimpleSendCompositeDirectByteBuf(Bootstrap sb, Bootstrap cb) throws Throwable {
        CompositeByteBuf buf = Unpooled.compositeBuffer();
        buf.addComponent(true, Unpooled.directBuffer().writeBytes(BYTES, 0, 2));
        buf.addComponent(true, Unpooled.directBuffer().writeBytes(BYTES, 2, 2));
        this.testSimpleSend(sb, cb, (ByteBuf)buf, true, BYTES, 1);
        CompositeByteBuf buf2 = Unpooled.compositeBuffer();
        buf2.addComponent(true, Unpooled.directBuffer().writeBytes(BYTES, 0, 2));
        buf2.addComponent(true, Unpooled.directBuffer().writeBytes(BYTES, 2, 2));
        this.testSimpleSend(sb, cb, (ByteBuf)buf2, true, BYTES, 4);
    }

    @Test
    public void testSimpleSendCompositeHeapByteBuf(TestInfo testInfo) throws Throwable {
        this.run(testInfo, new AbstractComboTestsuiteTest.Runner<Bootstrap, Bootstrap>(){

            @Override
            public void run(Bootstrap bootstrap, Bootstrap bootstrap2) throws Throwable {
                DatagramUnicastTest.this.testSimpleSendCompositeHeapByteBuf(bootstrap, bootstrap2);
            }
        });
    }

    public void testSimpleSendCompositeHeapByteBuf(Bootstrap sb, Bootstrap cb) throws Throwable {
        CompositeByteBuf buf = Unpooled.compositeBuffer();
        buf.addComponent(true, Unpooled.buffer().writeBytes(BYTES, 0, 2));
        buf.addComponent(true, Unpooled.buffer().writeBytes(BYTES, 2, 2));
        this.testSimpleSend(sb, cb, (ByteBuf)buf, true, BYTES, 1);
        CompositeByteBuf buf2 = Unpooled.compositeBuffer();
        buf2.addComponent(true, Unpooled.buffer().writeBytes(BYTES, 0, 2));
        buf2.addComponent(true, Unpooled.buffer().writeBytes(BYTES, 2, 2));
        this.testSimpleSend(sb, cb, (ByteBuf)buf2, true, BYTES, 4);
    }

    @Test
    public void testSimpleSendCompositeMixedByteBuf(TestInfo testInfo) throws Throwable {
        this.run(testInfo, new AbstractComboTestsuiteTest.Runner<Bootstrap, Bootstrap>(){

            @Override
            public void run(Bootstrap bootstrap, Bootstrap bootstrap2) throws Throwable {
                DatagramUnicastTest.this.testSimpleSendCompositeMixedByteBuf(bootstrap, bootstrap2);
            }
        });
    }

    public void testSimpleSendCompositeMixedByteBuf(Bootstrap sb, Bootstrap cb) throws Throwable {
        CompositeByteBuf buf = Unpooled.compositeBuffer();
        buf.addComponent(true, Unpooled.directBuffer().writeBytes(BYTES, 0, 2));
        buf.addComponent(true, Unpooled.buffer().writeBytes(BYTES, 2, 2));
        this.testSimpleSend(sb, cb, (ByteBuf)buf, true, BYTES, 1);
        CompositeByteBuf buf2 = Unpooled.compositeBuffer();
        buf2.addComponent(true, Unpooled.directBuffer().writeBytes(BYTES, 0, 2));
        buf2.addComponent(true, Unpooled.buffer().writeBytes(BYTES, 2, 2));
        this.testSimpleSend(sb, cb, (ByteBuf)buf2, true, BYTES, 4);
    }

    @Test
    public void testSimpleSendWithoutBind(TestInfo testInfo) throws Throwable {
        this.run(testInfo, new AbstractComboTestsuiteTest.Runner<Bootstrap, Bootstrap>(){

            @Override
            public void run(Bootstrap bootstrap, Bootstrap bootstrap2) throws Throwable {
                DatagramUnicastTest.this.testSimpleSendWithoutBind(bootstrap, bootstrap2);
            }
        });
    }

    public void testSimpleSendWithoutBind(Bootstrap sb, Bootstrap cb) throws Throwable {
        this.testSimpleSend(sb, cb, Unpooled.directBuffer().writeBytes(BYTES), false, BYTES, 1);
        this.testSimpleSend(sb, cb, Unpooled.directBuffer().writeBytes(BYTES), false, BYTES, 4);
    }

    private void testSimpleSend(Bootstrap sb, Bootstrap cb, ByteBuf buf, boolean bindClient, byte[] bytes, int count) throws Throwable {
        for (WrapType type : WrapType.values()) {
            this.testSimpleSend0(sb, cb, buf.retain(), bindClient, bytes, count, type);
        }
        Assertions.assertTrue((boolean)buf.release());
    }

    @Test
    public void testSimpleSendWithConnect(TestInfo testInfo) throws Throwable {
        this.run(testInfo, new AbstractComboTestsuiteTest.Runner<Bootstrap, Bootstrap>(){

            @Override
            public void run(Bootstrap bootstrap, Bootstrap bootstrap2) throws Throwable {
                DatagramUnicastTest.this.testSimpleSendWithConnect(bootstrap, bootstrap2);
            }
        });
    }

    public void testSimpleSendWithConnect(Bootstrap sb, Bootstrap cb) throws Throwable {
        this.testSimpleSendWithConnect(sb, cb, Unpooled.directBuffer().writeBytes(BYTES), BYTES, 1);
        this.testSimpleSendWithConnect(sb, cb, Unpooled.directBuffer().writeBytes(BYTES), BYTES, 4);
    }

    @Test
    public void testReceiveEmptyDatagrams(TestInfo testInfo) throws Throwable {
        this.run(testInfo, new AbstractComboTestsuiteTest.Runner<Bootstrap, Bootstrap>(){

            @Override
            public void run(Bootstrap bootstrap, Bootstrap bootstrap2) throws Throwable {
                DatagramUnicastTest.this.testReceiveEmptyDatagrams(bootstrap, bootstrap2);
            }
        });
    }

    public void testReceiveEmptyDatagrams(Bootstrap sb, Bootstrap cb) throws Throwable {
        DatagramSocket client;
        final Semaphore semaphore = new Semaphore(0);
        Channel server = ((Bootstrap)sb.handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<io.netty.channel.socket.DatagramPacket>(){

                    protected void channelRead0(ChannelHandlerContext ctx, io.netty.channel.socket.DatagramPacket msg) throws Exception {
                        semaphore.release();
                    }
                }});
            }
        })).bind(this.newSocketAddress()).sync().channel();
        SocketAddress address = server.localAddress();
        try {
            client = new DatagramSocket(this.newSocketAddress());
        }
        catch (IllegalArgumentException e) {
            Assumptions.assumeThat((String)e.getMessage()).doesNotContainIgnoringCase(new CharSequence[]{"unsupported address type"});
            throw e;
        }
        SocketAddress sendAddress = address instanceof InetSocketAddress ? this.sendToAddress((InetSocketAddress)address) : address;
        for (int i = 0; i < 100; ++i) {
            try {
                client.send(new DatagramPacket(EmptyArrays.EMPTY_BYTES, 0, sendAddress));
            }
            catch (BindException e) {
                throw new TestAbortedException("JDK sockets do not support binding to these addresses.", (Throwable)e);
            }
            semaphore.acquire();
        }
    }

    @Test
    public void testSendToUnresolvableAddress(TestInfo testInfo) throws Throwable {
        this.run(testInfo, new AbstractComboTestsuiteTest.Runner<Bootstrap, Bootstrap>(){

            @Override
            public void run(Bootstrap bootstrap, Bootstrap bootstrap2) throws Throwable {
                DatagramUnicastTest.this.testSendToUnresolvableAddress(bootstrap, bootstrap2);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSendToUnresolvableAddress(Bootstrap sb, Bootstrap cb) throws Throwable {
        SocketAddress serverAddress = this.newSocketAddress();
        if (!(serverAddress instanceof InetSocketAddress)) {
            return;
        }
        Channel sc = ((Bootstrap)sb.handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<io.netty.channel.socket.DatagramPacket>(){

                    protected void channelRead0(ChannelHandlerContext ctx, io.netty.channel.socket.DatagramPacket msg) {
                    }
                }});
            }
        })).bind(serverAddress).sync().channel();
        Channel cc = ((Bootstrap)((Bootstrap)cb.option(ChannelOption.DATAGRAM_CHANNEL_ACTIVE_ON_REGISTRATION, (Object)true)).handler((ChannelHandler)new ChannelInboundHandlerAdapter())).register().sync().channel();
        try {
            InetSocketAddress goodHost = this.sendToAddress((InetSocketAddress)sc.localAddress());
            InetSocketAddress unresolvedHost = new InetSocketAddress("NOT_A_REAL_ADDRESS", goodHost.getPort());
            Assertions.assertFalse((boolean)goodHost.isUnresolved());
            Assertions.assertTrue((boolean)unresolvedHost.isUnresolved());
            String message = "hello world!";
            cc.writeAndFlush((Object)new io.netty.channel.socket.DatagramPacket(Unpooled.copiedBuffer((CharSequence)message, (Charset)CharsetUtil.US_ASCII), goodHost)).sync();
            Assertions.assertInstanceOf(UnresolvedAddressException.class, (Object)cc.writeAndFlush((Object)new io.netty.channel.socket.DatagramPacket(Unpooled.copiedBuffer((CharSequence)message, (Charset)CharsetUtil.US_ASCII), unresolvedHost)).await().cause());
            Assertions.assertTrue((boolean)cc.isOpen());
            cc.writeAndFlush((Object)new io.netty.channel.socket.DatagramPacket(Unpooled.copiedBuffer((CharSequence)message, (Charset)CharsetUtil.US_ASCII), goodHost)).sync();
            Assertions.assertInstanceOf(UnresolvedAddressException.class, (Object)cc.writeAndFlush((Object)new io.netty.channel.socket.DatagramPacket(Unpooled.copiedBuffer((CharSequence)message, (Charset)CharsetUtil.US_ASCII), unresolvedHost)).await().cause());
            Assertions.assertTrue((boolean)cc.isOpen());
        }
        finally {
            DatagramUnicastTest.closeChannel(cc);
            DatagramUnicastTest.closeChannel(sc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testSimpleSend0(Bootstrap sb, Bootstrap cb, ByteBuf buf, boolean bindClient, byte[] bytes, int count, WrapType wrapType) throws Throwable {
        Channel sc = null;
        Channel cc = null;
        try {
            SocketAddress sender;
            cb.handler((ChannelHandler)new SimpleChannelInboundHandler<Object>(){

                public void channelRead0(ChannelHandlerContext ctx, Object msgs) {
                }
            });
            if (bindClient) {
                cc = cb.bind(this.newSocketAddress()).sync().channel();
                sender = cc.localAddress();
            } else {
                cb.option(ChannelOption.DATAGRAM_CHANNEL_ACTIVE_ON_REGISTRATION, (Object)true);
                cc = cb.register().sync().channel();
                sender = null;
            }
            CountDownLatch latch = new CountDownLatch(count);
            AtomicReference<Throwable> errorRef = new AtomicReference<Throwable>();
            sc = this.setupServerChannel(sb, bytes, sender, latch, errorRef, false);
            SocketAddress localAddr = sc.localAddress();
            SocketAddress addr = localAddr instanceof InetSocketAddress ? this.sendToAddress((InetSocketAddress)sc.localAddress()) : localAddr;
            ArrayList<ChannelFuture> futures = new ArrayList<ChannelFuture>(count);
            for (int i = 0; i < count; ++i) {
                futures.add(this.write(cc, buf, addr, wrapType));
            }
            cc.flush();
            for (ChannelFuture future : futures) {
                future.sync();
            }
            if (!latch.await(10L, TimeUnit.SECONDS)) {
                Throwable error = errorRef.get();
                if (error != null) {
                    throw error;
                }
                Assertions.fail();
            }
        }
        catch (Throwable throwable) {
            buf.release();
            DatagramUnicastTest.closeChannel(cc);
            DatagramUnicastTest.closeChannel(sc);
            throw throwable;
        }
        buf.release();
        DatagramUnicastTest.closeChannel(cc);
        DatagramUnicastTest.closeChannel(sc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testSimpleSendWithConnect(Bootstrap sb, Bootstrap cb, ByteBuf buf, byte[] bytes, int count) throws Throwable {
        try {
            for (WrapType type : WrapType.values()) {
                this.testSimpleSendWithConnect0(sb, cb, buf.retain(), bytes, count, type);
            }
        }
        finally {
            Assertions.assertTrue((boolean)buf.release());
        }
    }

    /*
     * Exception decompiling
     */
    private void testSimpleSendWithConnect0(Bootstrap sb, Bootstrap cb, ByteBuf buf, byte[] bytes, int count, WrapType wrapType) throws Throwable {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static ChannelFuture write(Channel cc, ByteBuf buf, WrapType wrapType) {
        switch (wrapType) {
            case DUP: {
                return cc.write((Object)buf.retainedDuplicate());
            }
            case SLICE: {
                return cc.write((Object)buf.retainedSlice());
            }
            case READ_ONLY: {
                return cc.write((Object)buf.retain().asReadOnly());
            }
            case NONE: {
                return cc.write((Object)buf.retain());
            }
        }
        throw new Error("unknown wrap type: " + (Object)((Object)wrapType));
    }

    protected abstract boolean isConnected(Channel var1);

    protected abstract Channel setupClientChannel(Bootstrap var1, byte[] var2, CountDownLatch var3, AtomicReference<Throwable> var4) throws Throwable;

    protected abstract Channel setupServerChannel(Bootstrap var1, byte[] var2, SocketAddress var3, CountDownLatch var4, AtomicReference<Throwable> var5, boolean var6) throws Throwable;

    protected abstract boolean supportDisconnect();

    protected boolean disconnectMightFail(DatagramChannel channel) {
        return false;
    }

    protected abstract ChannelFuture write(Channel var1, ByteBuf var2, SocketAddress var3, WrapType var4);

    protected static void closeChannel(Channel channel) throws Exception {
        if (channel != null) {
            channel.close().sync();
        }
    }

    protected InetSocketAddress sendToAddress(InetSocketAddress serverAddress) {
        InetAddress addr = serverAddress.getAddress();
        if (addr.isAnyLocalAddress()) {
            if (addr instanceof Inet6Address) {
                return new InetSocketAddress(NetUtil.LOCALHOST6, serverAddress.getPort());
            }
            return new InetSocketAddress(NetUtil.LOCALHOST4, serverAddress.getPort());
        }
        return serverAddress;
    }

    protected static enum WrapType {
        NONE,
        DUP,
        SLICE,
        READ_ONLY;

    }
}

