/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport.socket;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.testsuite.transport.AbstractComboTestsuiteTest;
import io.netty.testsuite.transport.socket.AbstractSocketTest;
import io.netty.util.ReferenceCountUtil;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class SocketExceptionHandlingTest
extends AbstractSocketTest {
    @Test
    public void testReadPendingIsResetAfterEachRead(TestInfo testInfo) throws Throwable {
        this.run(testInfo, new AbstractComboTestsuiteTest.Runner<ServerBootstrap, Bootstrap>(){

            @Override
            public void run(ServerBootstrap serverBootstrap, Bootstrap bootstrap) throws Throwable {
                SocketExceptionHandlingTest.this.testReadPendingIsResetAfterEachRead(serverBootstrap, bootstrap);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReadPendingIsResetAfterEachRead(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        Channel serverChannel = null;
        Channel clientChannel = null;
        try {
            MyInitializer serverInitializer = new MyInitializer();
            sb.option(ChannelOption.SO_BACKLOG, (Object)1024);
            sb.childHandler((ChannelHandler)serverInitializer);
            serverChannel = sb.bind().syncUninterruptibly().channel();
            cb.handler((ChannelHandler)new MyInitializer());
            clientChannel = cb.connect(serverChannel.localAddress()).syncUninterruptibly().channel();
            clientChannel.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])new byte[1024]));
            Assertions.assertTrue((boolean)serverInitializer.exceptionHandler.latch1.await(5L, TimeUnit.SECONDS));
            Assertions.assertFalse((boolean)serverInitializer.exceptionHandler.latch2.await(1L, TimeUnit.SECONDS), (String)("Encountered " + serverInitializer.exceptionHandler.count.get() + " exceptions when 1 was expected"));
        }
        finally {
            if (serverChannel != null) {
                serverChannel.close().syncUninterruptibly();
            }
            if (clientChannel != null) {
                clientChannel.close().syncUninterruptibly();
            }
        }
    }

    private static class ExceptionHandler
    extends ChannelInboundHandlerAdapter {
        final AtomicLong count = new AtomicLong();
        final CountDownLatch latch1 = new CountDownLatch(1);
        final CountDownLatch latch2 = new CountDownLatch(1);

        private ExceptionHandler() {
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (this.count.incrementAndGet() <= 2L) {
                this.latch1.countDown();
            } else {
                this.latch2.countDown();
            }
            ctx.close();
        }
    }

    private static class BuggyChannelHandler
    extends ChannelInboundHandlerAdapter {
        private BuggyChannelHandler() {
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            ReferenceCountUtil.release((Object)msg);
            throw new NullPointerException("I am a bug!");
        }
    }

    private static class MyInitializer
    extends ChannelInitializer<Channel> {
        final ExceptionHandler exceptionHandler = new ExceptionHandler();

        private MyInitializer() {
        }

        protected void initChannel(Channel ch) throws Exception {
            ChannelPipeline pipeline = ch.pipeline();
            pipeline.addLast(new ChannelHandler[]{new BuggyChannelHandler()});
            pipeline.addLast(new ChannelHandler[]{this.exceptionHandler});
        }
    }
}

