/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport.socket;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.testsuite.transport.AbstractComboTestsuiteTest;
import io.netty.testsuite.transport.socket.AbstractSocketTest;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.concurrent.Promise;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.Timeout;

public abstract class SocketAddressesTest
extends AbstractSocketTest {
    @Test
    @Timeout(value=30000L, unit=TimeUnit.MILLISECONDS)
    public void testAddresses(TestInfo testInfo) throws Throwable {
        this.run(testInfo, new AbstractComboTestsuiteTest.Runner<ServerBootstrap, Bootstrap>(){

            @Override
            public void run(ServerBootstrap serverBootstrap, Bootstrap bootstrap) throws Throwable {
                SocketAddressesTest.this.testAddresses(serverBootstrap, bootstrap);
            }
        });
    }

    protected abstract void assertAddress(SocketAddress var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testAddresses(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        Channel serverChannel = null;
        Channel clientChannel = null;
        try {
            final Promise localAddressPromise = ImmediateEventExecutor.INSTANCE.newPromise();
            final Promise remoteAddressPromise = ImmediateEventExecutor.INSTANCE.newPromise();
            serverChannel = sb.childHandler((ChannelHandler)new ChannelInboundHandlerAdapter(){

                public void channelActive(ChannelHandlerContext ctx) {
                    localAddressPromise.setSuccess((Object)ctx.channel().localAddress());
                    remoteAddressPromise.setSuccess((Object)ctx.channel().remoteAddress());
                }
            }).bind().syncUninterruptibly().channel();
            clientChannel = ((Bootstrap)cb.handler((ChannelHandler)new ChannelInboundHandlerAdapter())).register().syncUninterruptibly().channel();
            Assertions.assertNull((Object)clientChannel.localAddress());
            Assertions.assertNull((Object)clientChannel.remoteAddress());
            clientChannel.connect(serverChannel.localAddress(), this.newSocketAddress()).syncUninterruptibly().channel();
            this.assertAddress(clientChannel.localAddress());
            this.assertAddress(clientChannel.remoteAddress());
            this.assertAddress((SocketAddress)localAddressPromise.get());
            this.assertAddress((SocketAddress)remoteAddressPromise.get());
        }
        finally {
            if (clientChannel != null) {
                clientChannel.close().syncUninterruptibly();
            }
            if (serverChannel != null) {
                serverChannel.close().syncUninterruptibly();
            }
        }
    }
}

