/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.uring;

import io.netty.channel.uring.CompletionCallback;
import io.netty.util.internal.PlatformDependent;
import java.util.StringJoiner;

final class CompletionQueue {
    private static final int CQE_USER_DATA_FIELD = 0;
    private static final int CQE_RES_FIELD = 8;
    private static final int CQE_FLAGS_FIELD = 12;
    private static final long CQE_SIZE = 16L;
    private final long kHeadAddress;
    private final long kTailAddress;
    private final long completionQueueArrayAddress;
    final int ringSize;
    final long ringAddress;
    final int ringFd;
    final int ringEntries;
    final int ringCapacity;
    private final int ringMask;
    private int ringHead;

    CompletionQueue(long kHeadAddress, long kTailAddress, long kRingMaskAddress, long kRingEntriesAddress, long kOverflowAddress, long completionQueueArrayAddress, int ringSize, long ringAddress, int ringFd, int ringCapacity) {
        this.kHeadAddress = kHeadAddress;
        this.kTailAddress = kTailAddress;
        this.completionQueueArrayAddress = completionQueueArrayAddress;
        this.ringSize = ringSize;
        this.ringAddress = ringAddress;
        this.ringFd = ringFd;
        this.ringCapacity = ringCapacity;
        this.ringEntries = PlatformDependent.getIntVolatile((long)kRingEntriesAddress);
        this.ringMask = PlatformDependent.getIntVolatile((long)kRingMaskAddress);
        this.ringHead = PlatformDependent.getIntVolatile((long)kHeadAddress);
    }

    boolean hasCompletions() {
        return this.ringHead != PlatformDependent.getIntVolatile((long)this.kTailAddress);
    }

    int count() {
        return PlatformDependent.getIntVolatile((long)this.kTailAddress) - this.ringHead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int process(CompletionCallback callback) {
        int tail = PlatformDependent.getIntVolatile((long)this.kTailAddress);
        try {
            int i = 0;
            while (this.ringHead != tail) {
                long cqeAddress = this.completionQueueArrayAddress + (long)(this.ringHead & this.ringMask) * 16L;
                long udata = PlatformDependent.getLong((long)(cqeAddress + 0L));
                int res = PlatformDependent.getInt((long)(cqeAddress + 8L));
                int flags = PlatformDependent.getInt((long)(cqeAddress + 12L));
                ++this.ringHead;
                ++i;
                if (callback.handle(res, flags, udata)) continue;
                break;
            }
            int n = i;
            return n;
        }
        finally {
            PlatformDependent.putIntOrdered((long)this.kHeadAddress, (int)this.ringHead);
        }
    }

    public String toString() {
        StringJoiner sb = new StringJoiner(", ", "CompletionQueue [", "]");
        int tail = PlatformDependent.getIntVolatile((long)this.kTailAddress);
        for (int head = this.ringHead; head != tail; ++head) {
            long cqeAddress = this.completionQueueArrayAddress + (long)(this.ringHead & this.ringMask) * 16L;
            long udata = PlatformDependent.getLong((long)(cqeAddress + 0L));
            int res = PlatformDependent.getInt((long)(cqeAddress + 8L));
            int flags = PlatformDependent.getInt((long)(cqeAddress + 12L));
            sb.add("(res=" + res).add(", flags=" + flags).add(", udata=" + udata).add(")");
        }
        return sb.toString();
    }
}

