/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.uring;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.DuplicatedByteBuf;
import io.netty.buffer.SlicedByteBuf;
import io.netty.buffer.SwappedByteBuf;
import io.netty.buffer.WrappedByteBuf;
import io.netty.channel.uring.IoUringBufferRingAllocator;
import io.netty.channel.uring.IoUringBufferRingExhaustedEvent;
import io.netty.channel.uring.Native;
import io.netty.util.internal.PlatformDependent;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;

final class IoUringBufferRing {
    private final long ioUringBufRingAddr;
    private final long tailFieldAddress;
    private final short entries;
    private final int maxUnreleasedBuffers;
    private final short mask;
    private final short bufferGroupId;
    private final int ringFd;
    private final IoUringBufferRingByteBuf[] buffers;
    private final IoUringBufferRingAllocator allocator;
    private final IoUringBufferRingExhaustedEvent exhaustedEvent;
    private final boolean incremental;
    private final AtomicInteger unreleasedBuffers = new AtomicInteger();
    private volatile boolean usable;
    private boolean corrupted;

    IoUringBufferRing(int ringFd, long ioUringBufRingAddr, short entries, int maxUnreleasedBuffers, short bufferGroupId, boolean incremental, IoUringBufferRingAllocator allocator) {
        assert (entries % 2 == 0);
        this.ioUringBufRingAddr = ioUringBufRingAddr;
        this.tailFieldAddress = ioUringBufRingAddr + (long)Native.IO_URING_BUFFER_RING_TAIL;
        this.entries = entries;
        this.maxUnreleasedBuffers = maxUnreleasedBuffers;
        this.mask = (short)(entries - 1);
        this.bufferGroupId = bufferGroupId;
        this.ringFd = ringFd;
        this.buffers = new IoUringBufferRingByteBuf[entries];
        this.incremental = incremental;
        this.allocator = allocator;
        this.exhaustedEvent = new IoUringBufferRingExhaustedEvent(bufferGroupId);
    }

    boolean isUsable() {
        return !this.corrupted && this.usable;
    }

    void fill() {
        for (short i = 0; i < this.entries; i = (short)(i + 1)) {
            this.fillBuffer(i);
        }
        this.usable = true;
    }

    IoUringBufferRingExhaustedEvent getExhaustedEvent() {
        return this.exhaustedEvent;
    }

    void fillBuffer(short bid) {
        ByteBuf byteBuf;
        if (this.corrupted) {
            return;
        }
        short oldTail = PlatformDependent.getShort((long)this.tailFieldAddress);
        int ringIndex = oldTail & this.mask;
        assert (ringIndex == bid);
        assert (this.buffers[bid] == null);
        try {
            byteBuf = this.allocator.allocate();
        }
        catch (OutOfMemoryError e) {
            this.corrupted = true;
            throw e;
        }
        byteBuf.writerIndex(byteBuf.capacity());
        this.buffers[bid] = new IoUringBufferRingByteBuf(byteBuf);
        long ioUringBufAddress = this.ioUringBufRingAddr + (long)Native.SIZEOF_IOURING_BUF * (long)ringIndex;
        PlatformDependent.putLong((long)(ioUringBufAddress + (long)Native.IOURING_BUFFER_OFFSETOF_ADDR), (long)(byteBuf.memoryAddress() + (long)byteBuf.readerIndex()));
        PlatformDependent.putInt((long)(ioUringBufAddress + (long)Native.IOURING_BUFFER_OFFSETOF_LEN), (int)byteBuf.capacity());
        PlatformDependent.putShort((long)(ioUringBufAddress + (long)Native.IOURING_BUFFER_OFFSETOF_BID), (short)bid);
        PlatformDependent.putShortOrdered((long)this.tailFieldAddress, (short)((short)(oldTail + 1)));
    }

    int attemptedBytesRead(short bid) {
        return this.buffers[bid].readableBytes();
    }

    ByteBuf useBuffer(short bid, int readableBytes, boolean more) {
        assert (readableBytes > 0);
        IoUringBufferRingByteBuf byteBuf = this.buffers[bid];
        this.allocator.lastBytesRead(byteBuf.readableBytes(), readableBytes);
        if (this.incremental && more && byteBuf.readableBytes() > readableBytes) {
            return byteBuf.readRetainedSlice(readableBytes);
        }
        this.buffers[bid] = null;
        byteBuf.markUsed();
        return byteBuf.writerIndex(byteBuf.readerIndex() + Math.min(readableBytes, byteBuf.readableBytes()));
    }

    short nextBid(short bid) {
        return (short)(bid + 1 & this.mask);
    }

    short bufferGroupId() {
        return this.bufferGroupId;
    }

    void close() {
        Native.ioUringUnRegisterBufRing(this.ringFd, this.ioUringBufRingAddr, this.entries, this.bufferGroupId);
        for (IoUringBufferRingByteBuf byteBuf : this.buffers) {
            if (byteBuf == null) continue;
            byteBuf.release();
        }
        Arrays.fill((Object[])this.buffers, null);
    }

    final class IoUringBufferRingByteBuf
    extends WrappedByteBuf {
        IoUringBufferRingByteBuf(ByteBuf buf) {
            super(buf);
        }

        void markUsed() {
            if (IoUringBufferRing.this.unreleasedBuffers.incrementAndGet() == IoUringBufferRing.this.maxUnreleasedBuffers) {
                IoUringBufferRing.this.usable = false;
            }
        }

        public ByteBuf order(ByteOrder endianness) {
            if (endianness == this.order()) {
                return this;
            }
            return new SwappedByteBuf((ByteBuf)this);
        }

        public ByteBuf slice() {
            return this.slice(this.readerIndex(), this.readableBytes());
        }

        public ByteBuf retainedSlice() {
            return this.slice().retain();
        }

        public ByteBuf slice(int index, int length) {
            return new SlicedByteBuf((ByteBuf)this, index, length);
        }

        public ByteBuf retainedSlice(int index, int length) {
            return this.slice(index, length).retain();
        }

        public ByteBuf readSlice(int length) {
            ByteBuf slice = this.slice(this.readerIndex(), length);
            this.skipBytes(length);
            return slice;
        }

        public ByteBuf readRetainedSlice(int length) {
            ByteBuf slice = this.retainedSlice(this.readerIndex(), length);
            try {
                this.skipBytes(length);
            }
            catch (Throwable cause) {
                slice.release();
                throw cause;
            }
            return slice;
        }

        public ByteBuf duplicate() {
            return new DuplicatedByteBuf((ByteBuf)this);
        }

        public ByteBuf retainedDuplicate() {
            return this.duplicate().retain();
        }

        public boolean release() {
            if (super.release()) {
                this.released();
                return true;
            }
            return false;
        }

        public boolean release(int decrement) {
            if (super.release(decrement)) {
                this.released();
                return true;
            }
            return false;
        }

        private void released() {
            if (IoUringBufferRing.this.unreleasedBuffers.decrementAndGet() == IoUringBufferRing.this.maxUnreleasedBuffers / 2) {
                IoUringBufferRing.this.usable = true;
            }
        }
    }
}

