/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.kqueue;

import io.netty.channel.Channel;
import io.netty.channel.DefaultSelectStrategyFactory;
import io.netty.channel.IoEventLoop;
import io.netty.channel.IoExecutionContext;
import io.netty.channel.IoHandle;
import io.netty.channel.IoHandler;
import io.netty.channel.IoHandlerFactory;
import io.netty.channel.IoOps;
import io.netty.channel.SelectStrategy;
import io.netty.channel.SelectStrategyFactory;
import io.netty.channel.kqueue.AbstractKQueueChannel;
import io.netty.channel.kqueue.KQueue;
import io.netty.channel.kqueue.KQueueEventArray;
import io.netty.channel.kqueue.KQueueIoEvent;
import io.netty.channel.kqueue.KQueueIoHandle;
import io.netty.channel.kqueue.KQueueIoOps;
import io.netty.channel.kqueue.KQueueIoRegistration;
import io.netty.channel.kqueue.Native;
import io.netty.channel.unix.FileDescriptor;
import io.netty.channel.unix.IovArray;
import io.netty.util.IntSupplier;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public final class KQueueIoHandler
implements IoHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(KQueueIoHandler.class);
    private static final AtomicIntegerFieldUpdater<KQueueIoHandler> WAKEN_UP_UPDATER = AtomicIntegerFieldUpdater.newUpdater(KQueueIoHandler.class, "wakenUp");
    private static final int KQUEUE_WAKE_UP_IDENT = 0;
    private static final int KQUEUE_MAX_TIMEOUT_SECONDS = 86399;
    private final boolean allowGrowing;
    private final FileDescriptor kqueueFd;
    private final KQueueEventArray changeList;
    private final KQueueEventArray eventList;
    private final SelectStrategy selectStrategy;
    private final IovArray iovArray = new IovArray();
    private final IntSupplier selectNowSupplier = new IntSupplier(){

        public int get() throws Exception {
            return KQueueIoHandler.this.kqueueWaitNow();
        }
    };
    private final IntObjectMap<DefaultKqueueIoRegistration> registrations = new IntObjectHashMap(4096);
    private int numChannels;
    private volatile int wakenUp;

    public static IoHandlerFactory newFactory() {
        return KQueueIoHandler.newFactory(0, DefaultSelectStrategyFactory.INSTANCE);
    }

    public static IoHandlerFactory newFactory(final int maxEvents, final SelectStrategyFactory selectStrategyFactory) {
        ObjectUtil.checkPositiveOrZero((int)maxEvents, (String)"maxEvents");
        ObjectUtil.checkNotNull((Object)selectStrategyFactory, (String)"selectStrategyFactory");
        return new IoHandlerFactory(){

            public IoHandler newHandler() {
                return new KQueueIoHandler(maxEvents, selectStrategyFactory.newSelectStrategy());
            }
        };
    }

    private KQueueIoHandler(int maxEvents, SelectStrategy strategy) {
        this.selectStrategy = (SelectStrategy)ObjectUtil.checkNotNull((Object)strategy, (String)"strategy");
        this.kqueueFd = Native.newKQueue();
        if (maxEvents == 0) {
            this.allowGrowing = true;
            maxEvents = 4096;
        } else {
            this.allowGrowing = false;
        }
        this.changeList = new KQueueEventArray(maxEvents);
        this.eventList = new KQueueEventArray(maxEvents);
        int result = Native.keventAddUserEvent(this.kqueueFd.intValue(), 0);
        if (result < 0) {
            this.destroy();
            throw new IllegalStateException("kevent failed to add user event with errno: " + -result);
        }
    }

    IovArray cleanArray() {
        this.iovArray.clear();
        return this.iovArray;
    }

    public void wakeup(IoEventLoop eventLoop) {
        if (!eventLoop.inEventLoop() && WAKEN_UP_UPDATER.compareAndSet(this, 0, 1)) {
            this.wakeup();
        }
    }

    private void wakeup() {
        Native.keventTriggerUserEvent(this.kqueueFd.intValue(), 0);
    }

    private int kqueueWait(IoExecutionContext context, boolean oldWakeup) throws IOException {
        if (oldWakeup && !context.canBlock()) {
            return this.kqueueWaitNow();
        }
        long totalDelay = context.delayNanos(System.nanoTime());
        int delaySeconds = (int)Math.min(totalDelay / 1000000000L, 86399L);
        int delayNanos = (int)(totalDelay % 1000000000L);
        return this.kqueueWait(delaySeconds, delayNanos);
    }

    private int kqueueWaitNow() throws IOException {
        return this.kqueueWait(0, 0);
    }

    private int kqueueWait(int timeoutSec, int timeoutNs) throws IOException {
        int numEvents = Native.keventWait(this.kqueueFd.intValue(), this.changeList, this.eventList, timeoutSec, timeoutNs);
        this.changeList.clear();
        return numEvents;
    }

    private void processReady(int ready) {
        for (int i = 0; i < ready; ++i) {
            short filter = this.eventList.filter(i);
            short flags = this.eventList.flags(i);
            int ident = this.eventList.ident(i);
            if (filter == Native.EVFILT_USER || (flags & Native.EV_ERROR) != 0) {
                assert (filter != Native.EVFILT_USER || filter == Native.EVFILT_USER && ident == 0);
                continue;
            }
            DefaultKqueueIoRegistration registration = (DefaultKqueueIoRegistration)this.registrations.get(ident);
            if (registration == null) {
                logger.warn("events[{}]=[{}, {}] had no registration!", new Object[]{i, ident, filter});
                continue;
            }
            registration.handle(ident, filter, flags, this.eventList.fflags(i), this.eventList.data(i));
        }
    }

    public int run(IoExecutionContext context) {
        int handled = 0;
        try {
            int strategy = this.selectStrategy.calculateStrategy(this.selectNowSupplier, !context.canBlock());
            switch (strategy) {
                case -2: {
                    return 0;
                }
                case -3: 
                case -1: {
                    strategy = this.kqueueWait(context, WAKEN_UP_UPDATER.getAndSet(this, 0) == 1);
                    if (this.wakenUp != 1) break;
                    this.wakeup();
                }
            }
            if (strategy > 0) {
                handled = strategy;
                this.processReady(strategy);
            }
            if (this.allowGrowing && strategy == this.eventList.capacity()) {
                this.eventList.realloc(false);
            }
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable t) {
            KQueueIoHandler.handleLoopException(t);
        }
        return handled;
    }

    int numRegisteredChannels() {
        return this.numChannels;
    }

    List<Channel> registeredChannelsList() {
        IntObjectMap<DefaultKqueueIoRegistration> ch = this.registrations;
        if (ch.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Channel> channels = new ArrayList<Channel>(ch.size());
        for (DefaultKqueueIoRegistration registration : ch.values()) {
            if (!(registration.handle instanceof AbstractKQueueChannel.AbstractKQueueUnsafe)) continue;
            channels.add(((AbstractKQueueChannel.AbstractKQueueUnsafe)registration.handle).channel());
        }
        return Collections.unmodifiableList(channels);
    }

    private static void handleLoopException(Throwable t) {
        logger.warn("Unexpected exception in the selector loop.", t);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void prepareToDestroy() {
        DefaultKqueueIoRegistration[] copy;
        try {
            this.kqueueWaitNow();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        for (DefaultKqueueIoRegistration reg : copy = this.registrations.values().toArray(new DefaultKqueueIoRegistration[0])) {
            reg.close();
        }
    }

    public void destroy() {
        try {
            try {
                this.kqueueFd.close();
            }
            catch (IOException e) {
                logger.warn("Failed to close the kqueue fd.", (Throwable)e);
            }
        }
        finally {
            this.changeList.free();
            this.eventList.free();
        }
    }

    public KQueueIoRegistration register(IoEventLoop eventLoop, IoHandle handle) {
        KQueueIoHandle kqueueHandle = KQueueIoHandler.cast(handle);
        if (kqueueHandle.ident() == 0) {
            throw new IllegalArgumentException("ident 0 is reserved for internal usage");
        }
        DefaultKqueueIoRegistration registration = new DefaultKqueueIoRegistration(eventLoop, kqueueHandle);
        DefaultKqueueIoRegistration old = (DefaultKqueueIoRegistration)this.registrations.put(kqueueHandle.ident(), (Object)registration);
        if (old != null) {
            this.registrations.put(kqueueHandle.ident(), (Object)old);
            throw new IllegalStateException("registration for the KQueueIoHandle.ident() already exists");
        }
        if (kqueueHandle instanceof AbstractKQueueChannel.AbstractKQueueUnsafe) {
            ++this.numChannels;
        }
        return registration;
    }

    private static KQueueIoHandle cast(IoHandle handle) {
        if (handle instanceof KQueueIoHandle) {
            return (KQueueIoHandle)handle;
        }
        throw new IllegalArgumentException("IoHandle of type " + StringUtil.simpleClassName((Object)handle) + " not supported");
    }

    private static KQueueIoOps cast(IoOps ops) {
        if (ops instanceof KQueueIoOps) {
            return (KQueueIoOps)ops;
        }
        throw new IllegalArgumentException("IoOps of type " + StringUtil.simpleClassName((Object)ops) + " not supported");
    }

    public boolean isCompatible(Class<? extends IoHandle> handleType) {
        return KQueueIoHandle.class.isAssignableFrom(handleType);
    }

    static {
        KQueue.ensureAvailability();
    }

    private final class DefaultKqueueIoRegistration
    extends AtomicBoolean
    implements KQueueIoRegistration {
        private final KQueueIoEvent event = new KQueueIoEvent();
        final KQueueIoHandle handle;
        private final IoEventLoop eventLoop;

        DefaultKqueueIoRegistration(IoEventLoop eventLoop, KQueueIoHandle handle) {
            this.eventLoop = eventLoop;
            this.handle = handle;
        }

        public long submit(IoOps ops) {
            KQueueIoOps kQueueIoOps = KQueueIoHandler.cast(ops);
            if (!this.isValid()) {
                return -1L;
            }
            short filter = kQueueIoOps.filter();
            short flags = kQueueIoOps.flags();
            int fflags = kQueueIoOps.fflags();
            if (this.eventLoop.inEventLoop()) {
                this.evSet(filter, flags, fflags);
            } else {
                this.eventLoop.execute(() -> this.evSet(filter, flags, fflags));
            }
            return 0L;
        }

        @Override
        public KQueueIoHandler ioHandler() {
            return KQueueIoHandler.this;
        }

        void handle(int ident, short filter, short flags, int fflags, long data) {
            this.event.update(ident, filter, flags, fflags, data);
            this.handle.handle(this, this.event);
        }

        private void evSet(short filter, short flags, int fflags) {
            KQueueIoHandler.this.changeList.evSet(this.handle.ident(), filter, flags, fflags);
        }

        public boolean isValid() {
            return !this.get();
        }

        public void cancel() {
            if (this.getAndSet(true)) {
                return;
            }
            if (this.eventLoop.inEventLoop()) {
                this.cancel0();
            } else {
                this.eventLoop.execute(this::cancel0);
            }
        }

        private void cancel0() {
            int ident = this.handle.ident();
            DefaultKqueueIoRegistration old = (DefaultKqueueIoRegistration)KQueueIoHandler.this.registrations.remove(ident);
            if (old != null) {
                if (old != this) {
                    KQueueIoHandler.this.registrations.put(ident, (Object)old);
                } else if (old.handle instanceof AbstractKQueueChannel.AbstractKQueueUnsafe) {
                    KQueueIoHandler.this.numChannels--;
                }
            }
        }

        void close() {
            this.cancel();
            try {
                this.handle.close();
            }
            catch (Exception e) {
                logger.debug("Exception during closing " + this.handle, (Throwable)e);
            }
        }
    }
}

