/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.epoll.Native;
import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.internal.PlatformDependent;

final class IovArray
implements ChannelOutboundBuffer.MessageProcessor {
    private static final int ADDRESS_SIZE = PlatformDependent.addressSize();
    private static final int IOV_SIZE = 2 * ADDRESS_SIZE;
    private static final int CAPACITY = Native.IOV_MAX * IOV_SIZE;
    private static final FastThreadLocal<IovArray> ARRAY = new FastThreadLocal<IovArray>(){

        protected IovArray initialValue() throws Exception {
            return new IovArray();
        }

        protected void onRemoval(IovArray value) throws Exception {
            PlatformDependent.freeMemory((long)value.memoryAddress);
        }
    };
    private final long memoryAddress = PlatformDependent.allocateMemory((long)CAPACITY);
    private int count;
    private long size;

    private IovArray() {
    }

    private boolean add(ByteBuf buf) {
        if (this.count == Native.IOV_MAX) {
            return false;
        }
        int len = buf.readableBytes();
        if (len == 0) {
            return true;
        }
        long addr = buf.memoryAddress();
        int offset = buf.readerIndex();
        long baseOffset = this.memoryAddress(this.count++);
        long lengthOffset = baseOffset + (long)ADDRESS_SIZE;
        if (ADDRESS_SIZE == 8) {
            PlatformDependent.putLong((long)baseOffset, (long)(addr + (long)offset));
            PlatformDependent.putLong((long)lengthOffset, (long)len);
        } else {
            assert (ADDRESS_SIZE == 4);
            PlatformDependent.putInt((long)baseOffset, (int)((int)addr + offset));
            PlatformDependent.putInt((long)lengthOffset, (int)len);
        }
        this.size += (long)len;
        return true;
    }

    long processWritten(int index, long written) {
        long baseOffset = this.memoryAddress(index);
        long lengthOffset = baseOffset + (long)ADDRESS_SIZE;
        if (ADDRESS_SIZE == 8) {
            long len = PlatformDependent.getLong((long)lengthOffset);
            if (len > written) {
                long offset = PlatformDependent.getLong((long)baseOffset);
                PlatformDependent.putLong((long)baseOffset, (long)(offset + written));
                PlatformDependent.putLong((long)lengthOffset, (long)(len - written));
                return -1L;
            }
            return len;
        }
        assert (ADDRESS_SIZE == 4);
        long len = PlatformDependent.getInt((long)lengthOffset);
        if (len > written) {
            int offset = PlatformDependent.getInt((long)baseOffset);
            PlatformDependent.putInt((long)baseOffset, (int)((int)((long)offset + written)));
            PlatformDependent.putInt((long)lengthOffset, (int)((int)(len - written)));
            return -1L;
        }
        return len;
    }

    int count() {
        return this.count;
    }

    long size() {
        return this.size;
    }

    long memoryAddress(int offset) {
        return this.memoryAddress + (long)(IOV_SIZE * offset);
    }

    public boolean processMessage(Object msg) throws Exception {
        return msg instanceof ByteBuf && this.add((ByteBuf)msg);
    }

    static IovArray get(ChannelOutboundBuffer buffer) throws Exception {
        IovArray array = (IovArray)ARRAY.get();
        array.size = 0L;
        array.count = 0;
        buffer.forEachFlushedMessage((ChannelOutboundBuffer.MessageProcessor)array);
        return array;
    }
}

