/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.socket.DatagramPacket;
import io.netty.util.Recycler;
import java.net.InetSocketAddress;

final class EpollDatagramChannelOutboundBuffer
extends ChannelOutboundBuffer {
    private static final Recycler<EpollDatagramChannelOutboundBuffer> RECYCLER = new Recycler<EpollDatagramChannelOutboundBuffer>(){

        protected EpollDatagramChannelOutboundBuffer newObject(Recycler.Handle<EpollDatagramChannelOutboundBuffer> handle) {
            return new EpollDatagramChannelOutboundBuffer(handle);
        }
    };

    static EpollDatagramChannelOutboundBuffer newInstance(EpollDatagramChannel channel) {
        EpollDatagramChannelOutboundBuffer buffer = (EpollDatagramChannelOutboundBuffer)((Object)RECYCLER.get());
        buffer.channel = channel;
        return buffer;
    }

    private EpollDatagramChannelOutboundBuffer(Recycler.Handle<EpollDatagramChannelOutboundBuffer> handle) {
        super(handle);
    }

    protected Object beforeAdd(Object msg) {
        ByteBuf buf;
        if (msg instanceof DatagramPacket) {
            DatagramPacket packet = (DatagramPacket)msg;
            ByteBuf content = (ByteBuf)packet.content();
            if (EpollDatagramChannelOutboundBuffer.isCopyNeeded(content)) {
                ByteBuf direct = this.copyToDirectByteBuf(content);
                return new DatagramPacket(direct, (InetSocketAddress)packet.recipient(), (InetSocketAddress)packet.sender());
            }
        } else if (msg instanceof ByteBuf && EpollDatagramChannelOutboundBuffer.isCopyNeeded(buf = (ByteBuf)msg)) {
            msg = this.copyToDirectByteBuf((ByteBuf)msg);
        }
        return msg;
    }

    private static boolean isCopyNeeded(ByteBuf content) {
        return !content.hasMemoryAddress() || content.nioBufferCount() != 1;
    }
}

