/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.channel.unix.Socket;
import io.netty.util.NetUtil;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class EpollDatagramChannelTest {
    @BeforeEach
    public void setUp() {
        Epoll.ensureAvailability();
    }

    @Test
    public void testNotActiveNoLocalRemoteAddress() throws IOException {
        EpollDatagramChannelTest.checkNotActiveNoLocalRemoteAddress(new EpollDatagramChannel());
        EpollDatagramChannelTest.checkNotActiveNoLocalRemoteAddress(new EpollDatagramChannel(InternetProtocolFamily.IPv4));
        EpollDatagramChannelTest.checkNotActiveNoLocalRemoteAddress(new EpollDatagramChannel(InternetProtocolFamily.IPv6));
    }

    @Test
    public void testActiveHasLocalAddress() throws IOException {
        Socket socket = Socket.newSocketDgram();
        EpollDatagramChannel channel = new EpollDatagramChannel(socket.intValue());
        InetSocketAddress localAddress = channel.localAddress();
        Assertions.assertTrue((boolean)channel.active);
        Assertions.assertNotNull((Object)localAddress);
        Assertions.assertEquals((Object)socket.localAddress(), (Object)localAddress);
        channel.fd().close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLocalAddressBeforeAndAfterBind() {
        EpollEventLoopGroup group = new EpollEventLoopGroup(1);
        try {
            TestHandler handler = new TestHandler();
            InetSocketAddress localAddressBeforeBind = new InetSocketAddress(NetUtil.LOCALHOST, 0);
            Bootstrap bootstrap = new Bootstrap();
            ((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group((EventLoopGroup)group)).channel(EpollDatagramChannel.class)).localAddress((SocketAddress)localAddressBeforeBind)).handler((ChannelHandler)handler);
            ChannelFuture future = bootstrap.bind().syncUninterruptibly();
            Assertions.assertNull((Object)handler.localAddress);
            SocketAddress localAddressAfterBind = future.channel().localAddress();
            Assertions.assertNotNull((Object)localAddressAfterBind);
            Assertions.assertTrue((boolean)(localAddressAfterBind instanceof InetSocketAddress));
            Assertions.assertTrue((((InetSocketAddress)localAddressAfterBind).getPort() != 0 ? 1 : 0) != 0);
            future.channel().close().syncUninterruptibly();
        }
        finally {
            group.shutdownGracefully();
        }
    }

    private static void checkNotActiveNoLocalRemoteAddress(EpollDatagramChannel channel) throws IOException {
        Assertions.assertFalse((boolean)channel.active);
        Assertions.assertNull((Object)channel.localAddress());
        Assertions.assertNull((Object)channel.remoteAddress());
        channel.fd().close();
    }

    private static final class TestHandler
    extends ChannelInboundHandlerAdapter {
        private volatile SocketAddress localAddress;

        private TestHandler() {
        }

        public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
            this.localAddress = ctx.channel().localAddress();
            super.channelRegistered(ctx);
        }
    }
}

