/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.epoll.EpollTcpInfo;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EpollSocketChannelTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTcpInfo() throws Exception {
        EpollEventLoopGroup group = new EpollEventLoopGroup(1);
        try {
            Bootstrap bootstrap = new Bootstrap();
            EpollSocketChannel ch = (EpollSocketChannel)((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group((EventLoopGroup)group)).channel(EpollSocketChannel.class)).handler((ChannelHandler)new ChannelInboundHandlerAdapter())).bind((SocketAddress)new InetSocketAddress(0)).syncUninterruptibly().channel();
            EpollTcpInfo info = ch.tcpInfo();
            EpollSocketChannelTest.assertTcpInfo0(info);
            ch.close().syncUninterruptibly();
        }
        finally {
            group.shutdownGracefully();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTcpInfoReuse() throws Exception {
        EpollEventLoopGroup group = new EpollEventLoopGroup(1);
        try {
            Bootstrap bootstrap = new Bootstrap();
            EpollSocketChannel ch = (EpollSocketChannel)((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group((EventLoopGroup)group)).channel(EpollSocketChannel.class)).handler((ChannelHandler)new ChannelInboundHandlerAdapter())).bind((SocketAddress)new InetSocketAddress(0)).syncUninterruptibly().channel();
            EpollTcpInfo info = new EpollTcpInfo();
            ch.tcpInfo(info);
            EpollSocketChannelTest.assertTcpInfo0(info);
            ch.close().syncUninterruptibly();
        }
        finally {
            group.shutdownGracefully();
        }
    }

    private static void assertTcpInfo0(EpollTcpInfo info) throws Exception {
        Assertions.assertNotNull((Object)info);
        Assertions.assertTrue((info.state() >= 0 ? 1 : 0) != 0);
        Assertions.assertTrue((info.caState() >= 0 ? 1 : 0) != 0);
        Assertions.assertTrue((info.retransmits() >= 0 ? 1 : 0) != 0);
        Assertions.assertTrue((info.probes() >= 0 ? 1 : 0) != 0);
        Assertions.assertTrue((info.backoff() >= 0 ? 1 : 0) != 0);
        Assertions.assertTrue((info.options() >= 0 ? 1 : 0) != 0);
        Assertions.assertTrue((info.sndWscale() >= 0 ? 1 : 0) != 0);
        Assertions.assertTrue((info.rcvWscale() >= 0 ? 1 : 0) != 0);
        Assertions.assertTrue((info.rto() >= 0L ? 1 : 0) != 0);
        Assertions.assertTrue((info.ato() >= 0L ? 1 : 0) != 0);
        Assertions.assertTrue((info.sndMss() >= 0L ? 1 : 0) != 0);
        Assertions.assertTrue((info.rcvMss() >= 0L ? 1 : 0) != 0);
        Assertions.assertTrue((info.unacked() >= 0L ? 1 : 0) != 0);
        Assertions.assertTrue((info.sacked() >= 0L ? 1 : 0) != 0);
        Assertions.assertTrue((info.lost() >= 0L ? 1 : 0) != 0);
        Assertions.assertTrue((info.retrans() >= 0L ? 1 : 0) != 0);
        Assertions.assertTrue((info.fackets() >= 0L ? 1 : 0) != 0);
        Assertions.assertTrue((info.lastDataSent() >= 0L ? 1 : 0) != 0);
        Assertions.assertTrue((info.lastAckSent() >= 0L ? 1 : 0) != 0);
        Assertions.assertTrue((info.lastDataRecv() >= 0L ? 1 : 0) != 0);
        Assertions.assertTrue((info.lastAckRecv() >= 0L ? 1 : 0) != 0);
        Assertions.assertTrue((info.pmtu() >= 0L ? 1 : 0) != 0);
        Assertions.assertTrue((info.rcvSsthresh() >= 0L ? 1 : 0) != 0);
        Assertions.assertTrue((info.rtt() >= 0L ? 1 : 0) != 0);
        Assertions.assertTrue((info.rttvar() >= 0L ? 1 : 0) != 0);
        Assertions.assertTrue((info.sndSsthresh() >= 0L ? 1 : 0) != 0);
        Assertions.assertTrue((info.sndCwnd() >= 0L ? 1 : 0) != 0);
        Assertions.assertTrue((info.advmss() >= 0L ? 1 : 0) != 0);
        Assertions.assertTrue((info.reordering() >= 0L ? 1 : 0) != 0);
        Assertions.assertTrue((info.rcvRtt() >= 0L ? 1 : 0) != 0);
        Assertions.assertTrue((info.rcvSpace() >= 0L ? 1 : 0) != 0);
        Assertions.assertTrue((info.totalRetrans() >= 0L ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSoLingerNoAssertError() throws Exception {
        EpollEventLoopGroup group = new EpollEventLoopGroup(1);
        try {
            Bootstrap bootstrap = new Bootstrap();
            EpollSocketChannel ch = (EpollSocketChannel)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group((EventLoopGroup)group)).channel(EpollSocketChannel.class)).option(ChannelOption.SO_LINGER, (Object)10)).handler((ChannelHandler)new ChannelInboundHandlerAdapter())).bind((SocketAddress)new InetSocketAddress(0)).syncUninterruptibly().channel();
            ch.close().syncUninterruptibly();
        }
        finally {
            group.shutdownGracefully();
        }
    }
}

