/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class EpollServerSocketChannelConfigTest {
    private static EventLoopGroup group;
    private static EpollServerSocketChannel ch;

    @BeforeAll
    public static void before() {
        group = new EpollEventLoopGroup(1);
        ServerBootstrap bootstrap = new ServerBootstrap();
        ch = (EpollServerSocketChannel)((ServerBootstrap)bootstrap.group(group).channel(EpollServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInboundHandlerAdapter()).bind((SocketAddress)new InetSocketAddress(0)).syncUninterruptibly().channel();
    }

    @AfterAll
    public static void after() {
        try {
            ch.close().syncUninterruptibly();
        }
        finally {
            group.shutdownGracefully();
        }
    }

    @Test
    public void testTcpDeferAccept() {
        ch.config().setTcpDeferAccept(0);
        Assertions.assertEquals((int)0, (int)ch.config().getTcpDeferAccept());
        ch.config().setTcpDeferAccept(10);
        Assertions.assertTrue((10 <= ch.config().getTcpDeferAccept() ? 1 : 0) != 0);
    }

    @Test
    public void testReusePort() {
        ch.config().setReusePort(false);
        Assertions.assertFalse((boolean)ch.config().isReusePort());
        ch.config().setReusePort(true);
        Assertions.assertTrue((boolean)ch.config().isReusePort());
    }

    @Test
    public void testFreeBind() {
        ch.config().setFreeBind(false);
        Assertions.assertFalse((boolean)ch.config().isFreeBind());
        ch.config().setFreeBind(true);
        Assertions.assertTrue((boolean)ch.config().isFreeBind());
    }

    @Test
    public void getGetOptions() {
        Map map = ch.config().getOptions();
        Assertions.assertFalse((boolean)map.isEmpty());
    }

    @Test
    public void testFastOpen() {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                ch.config().setTcpFastopen(-1);
            }
        });
        ch.config().setTcpFastopen(10);
        Assertions.assertEquals((int)10, (int)ch.config().getTcpFastopen());
    }
}

