/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.github.artsok.RepeatedIfExceptionsTest;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.Map;
import java.util.Random;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.opentest4j.TestAbortedException;

public class EpollSocketChannelConfigTest {
    private static EventLoopGroup group;
    private static EpollSocketChannel ch;
    private static Random rand;

    @BeforeAll
    public static void beforeClass() {
        rand = new Random();
        group = new EpollEventLoopGroup(1);
    }

    @AfterAll
    public static void afterClass() {
        group.shutdownGracefully();
    }

    @BeforeEach
    public void setup() {
        Bootstrap bootstrap = new Bootstrap();
        ch = (EpollSocketChannel)((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group(group)).channel(EpollSocketChannel.class)).handler((ChannelHandler)new ChannelInboundHandlerAdapter())).bind((SocketAddress)new InetSocketAddress(0)).syncUninterruptibly().channel();
    }

    @AfterEach
    public void teardown() {
        ch.close().syncUninterruptibly();
    }

    private static long randLong(long min, long max) {
        return min + EpollSocketChannelConfigTest.nextLong(max - min + 1L);
    }

    private static long nextLong(long n) {
        long val;
        long bits;
        while ((bits = rand.nextLong() << 1 >>> 1) - (val = bits % n) + (n - 1L) < 0L) {
        }
        return val;
    }

    @Test
    public void testRandomTcpNotSentLowAt() {
        long actual;
        long expected = EpollSocketChannelConfigTest.randLong(0L, 0xFFFFFFFFL);
        try {
            ch.config().setTcpNotSentLowAt(expected);
            actual = ch.config().getTcpNotSentLowAt();
        }
        catch (RuntimeException e) {
            throw new TestAbortedException("assumeNoException", (Throwable)e);
        }
        org.junit.jupiter.api.Assertions.assertEquals((long)expected, (long)actual);
    }

    @Test
    public void testInvalidHighTcpNotSentLowAt() {
        try {
            long value = 0x100000000L;
            ch.config().setTcpNotSentLowAt(0x100000000L);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        catch (RuntimeException e) {
            throw new TestAbortedException("assumeNoException", (Throwable)e);
        }
        org.junit.jupiter.api.Assertions.fail();
    }

    @Test
    public void testInvalidLowTcpNotSentLowAt() {
        try {
            long value = -1L;
            ch.config().setTcpNotSentLowAt(-1L);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        catch (RuntimeException e) {
            throw new TestAbortedException("assumeNoException", (Throwable)e);
        }
        org.junit.jupiter.api.Assertions.fail();
    }

    @Test
    public void testTcpCork() {
        ch.config().setTcpCork(false);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)ch.config().isTcpCork());
        ch.config().setTcpCork(true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ch.config().isTcpCork());
    }

    @Test
    public void testTcpQickAck() {
        ch.config().setTcpQuickAck(false);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)ch.config().isTcpQuickAck());
        ch.config().setTcpQuickAck(true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ch.config().isTcpQuickAck());
    }

    @RepeatedIfExceptionsTest(repeats=4)
    public void testSetOptionWhenClosed() {
        ch.close().syncUninterruptibly();
        ChannelException e = (ChannelException)org.junit.jupiter.api.Assertions.assertThrows(ChannelException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                ch.config().setSoLinger(0);
            }
        });
        Assertions.assertThat((Throwable)e).hasCauseInstanceOf(ClosedChannelException.class);
    }

    @RepeatedIfExceptionsTest(repeats=4)
    public void testGetOptionWhenClosed() {
        ch.close().syncUninterruptibly();
        ChannelException e = (ChannelException)org.junit.jupiter.api.Assertions.assertThrows(ChannelException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                ch.config().getSoLinger();
            }
        });
        Assertions.assertThat((Throwable)e).hasCauseInstanceOf(ClosedChannelException.class);
    }

    @Test
    public void getGetOptions() {
        Map map = ch.config().getOptions();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)map.isEmpty());
    }
}

