/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.LinuxSocket;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.channel.unix.PeerCredentials;
import io.netty.channel.unix.tests.SocketTest;
import io.netty.channel.unix.tests.UnixTestUtils;
import java.io.IOException;
import java.net.SocketAddress;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class EpollSocketTest
extends SocketTest<LinuxSocket> {
    @BeforeAll
    public static void loadJNI() {
        Epoll.ensureAvailability();
    }

    @Test
    public void testTcpCork() throws Exception {
        Assertions.assertFalse((boolean)((LinuxSocket)this.socket).isTcpCork());
        ((LinuxSocket)this.socket).setTcpCork(true);
        Assertions.assertTrue((boolean)((LinuxSocket)this.socket).isTcpCork());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPeerCreds() throws IOException {
        LinuxSocket s1 = LinuxSocket.newSocketDomain();
        LinuxSocket s2 = LinuxSocket.newSocketDomain();
        try {
            DomainSocketAddress dsa = UnixTestUtils.newDomainSocketAddress();
            s1.bind((SocketAddress)dsa);
            s1.listen(1);
            Assertions.assertTrue((boolean)s2.connect((SocketAddress)dsa));
            byte[] addr = new byte[64];
            s1.accept(addr);
            PeerCredentials pc = s1.getPeerCredentials();
            Assertions.assertNotEquals((int)pc.uid(), (int)-1);
        }
        finally {
            s1.close();
            s2.close();
        }
    }

    protected LinuxSocket newSocket() {
        return LinuxSocket.newSocketStream();
    }

    protected int level() {
        return 1;
    }

    protected int optname() {
        return 2;
    }
}

