/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.unix.tests;

import io.netty.channel.unix.DomainSocketAddress;
import io.netty.util.internal.PlatformDependent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.junit.jupiter.api.Assumptions;

public final class UnixTestUtils {
    private static final Object INET_LOOPBACK_UNAVAILABLE = new Object();
    private static volatile Object inetLoopbackCache;

    @Deprecated
    public static DomainSocketAddress newSocketAddress() {
        return UnixTestUtils.newDomainSocketAddress();
    }

    public static DomainSocketAddress newDomainSocketAddress() {
        try {
            File file;
            do {
                if ((file = PlatformDependent.createTempFile((String)"NETTY", (String)"UDS", null)).delete()) continue;
                throw new IOException("failed to delete: " + file);
            } while (file.getAbsolutePath().length() > 128);
            return new DomainSocketAddress(file);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static SocketAddress newInetLoopbackSocketAddress() {
        Object loopback = inetLoopbackCache;
        if (loopback == null) {
            inetLoopbackCache = loopback = UnixTestUtils.getLoopbackAddress();
        }
        Assumptions.assumeTrue((loopback != INET_LOOPBACK_UNAVAILABLE ? 1 : 0) != 0, (String)"InetAddress.getLoopbackAddress() is not available");
        return new InetSocketAddress((InetAddress)loopback, 0);
    }

    private static Object getLoopbackAddress() {
        try {
            Method method = InetAddress.class.getMethod("getLoopbackAddress", new Class[0]);
            return method.invoke(null, new Object[0]);
        }
        catch (Exception ignore) {
            return INET_LOOPBACK_UNAVAILABLE;
        }
    }

    private UnixTestUtils() {
    }
}

