/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.unix.tests;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.buffer.UnpooledDirectByteBuf;
import io.netty.channel.unix.IovArray;
import org.junit.Assert;
import org.junit.Test;

public abstract class IovArrayTest {
    @Test
    public void testNotFailsWihtoutMemoryAddress() {
        NoMemoryAddressByteBuf buffer = new NoMemoryAddressByteBuf(128);
        IovArray array = new IovArray((ByteBuf)buffer);
        ByteBuf buf = Unpooled.directBuffer().writeZero(8);
        ByteBuf buf2 = new NoMemoryAddressByteBuf(8).writeZero(8);
        Assert.assertTrue((boolean)array.add(buf, 0, buf.readableBytes()));
        Assert.assertTrue((boolean)array.add(buf, 0, buf2.readableBytes()));
        Assert.assertEquals((long)2L, (long)array.count());
        Assert.assertEquals((long)16L, (long)array.size());
        Assert.assertTrue((boolean)buf.release());
        Assert.assertTrue((boolean)buf2.release());
        array.release();
        Assert.assertEquals((long)0L, (long)buffer.refCnt());
    }

    private static final class NoMemoryAddressByteBuf
    extends UnpooledDirectByteBuf {
        NoMemoryAddressByteBuf(int capacity) {
            super((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, capacity, Integer.MAX_VALUE);
        }

        public boolean hasMemoryAddress() {
            return false;
        }

        public long memoryAddress() {
            throw new UnsupportedOperationException();
        }
    }
}

