/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.unix;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.unix.Buffer;
import io.netty.channel.unix.Limits;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class IovArray
implements ChannelOutboundBuffer.MessageProcessor {
    private static final int ADDRESS_SIZE = Buffer.addressSize();
    public static final int IOV_SIZE = 2 * ADDRESS_SIZE;
    private static final int MAX_CAPACITY = Limits.IOV_MAX * IOV_SIZE;
    private final ByteBuf memory;
    private int count;
    private long size;
    private long maxBytes = Limits.SSIZE_MAX;

    public IovArray() {
        this(Unpooled.wrappedBuffer((ByteBuffer)Buffer.allocateDirectWithNativeOrder(MAX_CAPACITY)).setIndex(0, 0));
    }

    public IovArray(ByteBuf memory) {
        assert (memory.writerIndex() == 0);
        assert (memory.readerIndex() == 0);
        this.memory = PlatformDependent.hasUnsafe() ? memory : memory.order(PlatformDependent.BIG_ENDIAN_NATIVE_ORDER ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
    }

    public void clear() {
        this.count = 0;
        this.size = 0L;
    }

    @Deprecated
    public boolean add(ByteBuf buf) {
        return this.add(buf, buf.readerIndex(), buf.readableBytes());
    }

    public boolean add(ByteBuf buf, int offset, int len) {
        ByteBuffer[] buffers;
        if (this.count == Limits.IOV_MAX) {
            return false;
        }
        long memoryAddress = this.memory.memoryAddress();
        if (buf.nioBufferCount() == 1) {
            if (len == 0) {
                return true;
            }
            if (buf.hasMemoryAddress()) {
                return this.add(memoryAddress, buf.memoryAddress() + (long)offset, len);
            }
            ByteBuffer nioBuffer = buf.internalNioBuffer(offset, len);
            return this.add(memoryAddress, Buffer.memoryAddress(nioBuffer) + (long)nioBuffer.position(), len);
        }
        for (ByteBuffer nioBuffer : buffers = buf.nioBuffers(offset, len)) {
            int remaining = nioBuffer.remaining();
            if (remaining == 0 || this.add(memoryAddress, Buffer.memoryAddress(nioBuffer) + (long)nioBuffer.position(), remaining) && this.count != Limits.IOV_MAX) continue;
            return false;
        }
        return true;
    }

    private boolean add(long memoryAddress, long addr, int len) {
        assert (addr != 0L);
        if (this.maxBytes - (long)len < this.size && this.count > 0 || this.memory.capacity() < (this.count + 1) * IOV_SIZE) {
            return false;
        }
        int baseOffset = IovArray.idx(this.count);
        int lengthOffset = baseOffset + ADDRESS_SIZE;
        this.size += (long)len;
        ++this.count;
        if (ADDRESS_SIZE == 8) {
            if (PlatformDependent.hasUnsafe()) {
                PlatformDependent.putLong((long)((long)baseOffset + memoryAddress), (long)addr);
                PlatformDependent.putLong((long)((long)lengthOffset + memoryAddress), (long)len);
            } else {
                this.memory.setLong(baseOffset, addr);
                this.memory.setLong(lengthOffset, (long)len);
            }
        } else {
            assert (ADDRESS_SIZE == 4);
            if (PlatformDependent.hasUnsafe()) {
                PlatformDependent.putInt((long)((long)baseOffset + memoryAddress), (int)((int)addr));
                PlatformDependent.putInt((long)((long)lengthOffset + memoryAddress), (int)len);
            } else {
                this.memory.setInt(baseOffset, (int)addr);
                this.memory.setInt(lengthOffset, len);
            }
        }
        return true;
    }

    public int count() {
        return this.count;
    }

    public long size() {
        return this.size;
    }

    public void maxBytes(long maxBytes) {
        this.maxBytes = Math.min(Limits.SSIZE_MAX, ObjectUtil.checkPositive((long)maxBytes, (String)"maxBytes"));
    }

    public long maxBytes() {
        return this.maxBytes;
    }

    public long memoryAddress(int offset) {
        return this.memory.memoryAddress() + (long)IovArray.idx(offset);
    }

    public void release() {
        this.memory.release();
    }

    public boolean processMessage(Object msg) throws Exception {
        if (msg instanceof ByteBuf) {
            ByteBuf buffer = (ByteBuf)msg;
            return this.add(buffer, buffer.readerIndex(), buffer.readableBytes());
        }
        return false;
    }

    private static int idx(int index) {
        return IOV_SIZE * index;
    }
}

