/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.sctp;

import com.sun.nio.sctp.SctpStandardSocketOptions;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.sctp.SctpChannel;
import io.netty.channel.sctp.SctpChannelOption;
import io.netty.channel.sctp.SctpServerChannel;
import io.netty.channel.sctp.SctpTestUtil;
import io.netty.util.SuppressForbidden;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public abstract class SctpLimitStreamsTest {
    @BeforeAll
    public static void checkSupported() {
        Assumptions.assumeTrue((boolean)SctpTestUtil.isSctpSupported());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    @SuppressForbidden(reason="test-only")
    public void testSctpInitMaxstreams() throws Exception {
        EventLoopGroup loop = this.newEventLoopGroup();
        try {
            ServerBootstrap serverBootstrap = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)serverBootstrap.group(loop).channel(this.serverClass())).option(ChannelOption.SO_REUSEADDR, (Object)true)).option(SctpChannelOption.SCTP_INIT_MAXSTREAMS, (Object)SctpStandardSocketOptions.InitMaxStreams.create(1, 1))).localAddress((SocketAddress)new InetSocketAddress(0))).childHandler((ChannelHandler)new ChannelInboundHandlerAdapter());
            Bootstrap clientBootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(loop)).channel(this.clientClass())).option(SctpChannelOption.SCTP_INIT_MAXSTREAMS, (Object)SctpStandardSocketOptions.InitMaxStreams.create(112, 112))).handler((ChannelHandler)new ChannelInboundHandlerAdapter());
            Channel serverChannel = serverBootstrap.bind().syncUninterruptibly().channel();
            SctpChannel clientChannel = (SctpChannel)clientBootstrap.connect(serverChannel.localAddress()).syncUninterruptibly().channel();
            Assertions.assertEquals((int)1, (int)clientChannel.association().maxOutboundStreams());
            Assertions.assertEquals((int)1, (int)clientChannel.association().maxInboundStreams());
            serverChannel.close().syncUninterruptibly();
            clientChannel.close().syncUninterruptibly();
        }
        finally {
            loop.shutdownGracefully();
        }
    }

    protected abstract EventLoopGroup newEventLoopGroup();

    protected abstract Class<? extends SctpChannel> clientClass();

    protected abstract Class<? extends SctpServerChannel> serverClass();
}

