/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.sctp;

import com.sun.nio.sctp.Association;
import com.sun.nio.sctp.MessageInfo;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.channel.sctp.SctpMessage;
import io.netty.handler.codec.sctp.SctpMessageCompletionHandler;
import io.netty.util.SuppressForbidden;
import java.net.SocketAddress;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SctpMessageCompletionHandlerTest {
    @Test
    public void testFragmentsReleased() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new SctpMessageCompletionHandler()});
        ByteBuf buffer = Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3, 4});
        ByteBuf buffer2 = Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3, 4});
        SctpMessage message = new SctpMessage((MessageInfo)new TestMessageInfo(false, 1), buffer);
        Assertions.assertFalse((boolean)channel.writeInbound(new Object[]{message}));
        Assertions.assertEquals((int)1, (int)buffer.refCnt());
        SctpMessage message2 = new SctpMessage((MessageInfo)new TestMessageInfo(false, 2), buffer2);
        Assertions.assertFalse((boolean)channel.writeInbound(new Object[]{message2}));
        Assertions.assertEquals((int)1, (int)buffer2.refCnt());
        Assertions.assertFalse((boolean)channel.finish());
        Assertions.assertEquals((int)0, (int)buffer.refCnt());
        Assertions.assertEquals((int)0, (int)buffer2.refCnt());
    }

    @SuppressForbidden(reason="test-only")
    private final class TestMessageInfo
    extends MessageInfo {
        private final boolean complete;
        private final int streamNumber;

        TestMessageInfo(boolean complete, int streamNumber) {
            this.complete = complete;
            this.streamNumber = streamNumber;
        }

        @Override
        public SocketAddress address() {
            return null;
        }

        @Override
        public Association association() {
            return null;
        }

        @Override
        public int bytes() {
            return 0;
        }

        @Override
        public boolean isComplete() {
            return this.complete;
        }

        @Override
        public MessageInfo complete(boolean b) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isUnordered() {
            return false;
        }

        @Override
        public MessageInfo unordered(boolean b) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int payloadProtocolID() {
            return 0;
        }

        @Override
        public MessageInfo payloadProtocolID(int i) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int streamNumber() {
            return this.streamNumber;
        }

        @Override
        public MessageInfo streamNumber(int i) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long timeToLive() {
            return 0L;
        }

        @Override
        public MessageInfo timeToLive(long l) {
            throw new UnsupportedOperationException();
        }
    }
}

