/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ChannelBufType;
import io.netty.buffer.MessageBuf;
import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.NoSuchBufferException;
import io.netty.channel.ServerChannel;
import java.net.SocketAddress;

public abstract class AbstractServerChannel
extends AbstractChannel
implements ServerChannel {
    private static final ChannelMetadata METADATA = new ChannelMetadata(ChannelBufType.MESSAGE, false);

    protected AbstractServerChannel(Integer id) {
        super(null, id);
    }

    @Override
    public ByteBuf outboundByteBuffer() {
        throw new NoSuchBufferException();
    }

    @Override
    public MessageBuf<Object> outboundMessageBuffer() {
        throw new NoSuchBufferException();
    }

    @Override
    public ChannelMetadata metadata() {
        return METADATA;
    }

    @Override
    public SocketAddress remoteAddress() {
        return null;
    }

    @Override
    protected Channel.Unsafe newUnsafe() {
        return new DefaultServerUnsafe();
    }

    @Override
    protected SocketAddress remoteAddress0() {
        return null;
    }

    @Override
    protected void doDisconnect() throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void doFlushByteBuffer(ByteBuf buf) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void doFlushMessageBuffer(MessageBuf<Object> buf) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean isFlushPending() {
        return false;
    }

    protected class DefaultServerUnsafe
    extends AbstractChannel.AbstractUnsafe {
        protected DefaultServerUnsafe() {
        }

        @Override
        public void flush(final ChannelFuture future) {
            if (AbstractServerChannel.this.eventLoop().inEventLoop()) {
                this.reject(future);
            } else {
                AbstractServerChannel.this.eventLoop().execute(new Runnable(){

                    @Override
                    public void run() {
                        DefaultServerUnsafe.this.flush(future);
                    }
                });
            }
        }

        @Override
        public void connect(final SocketAddress remoteAddress, final SocketAddress localAddress, final ChannelFuture future) {
            if (AbstractServerChannel.this.eventLoop().inEventLoop()) {
                this.reject(future);
            } else {
                AbstractServerChannel.this.eventLoop().execute(new Runnable(){

                    @Override
                    public void run() {
                        DefaultServerUnsafe.this.connect(remoteAddress, localAddress, future);
                    }
                });
            }
        }

        private void reject(ChannelFuture future) {
            UnsupportedOperationException cause = new UnsupportedOperationException();
            future.setFailure(cause);
            AbstractServerChannel.this.pipeline().fireExceptionCaught(cause);
        }
    }
}

