/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.channel.EventExecutor;
import io.netty.logging.InternalLogger;
import io.netty.logging.InternalLoggerFactory;
import io.netty.util.internal.QueueFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public abstract class SingleThreadEventExecutor
extends AbstractExecutorService
implements EventExecutor {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SingleThreadEventExecutor.class);
    private static final long SCHEDULE_CHECK_INTERVAL = TimeUnit.MILLISECONDS.toNanos(10L);
    private static final long SCHEDULE_PURGE_INTERVAL = TimeUnit.SECONDS.toNanos(1L);
    private static final long START_TIME = System.nanoTime();
    private static final AtomicLong nextTaskId = new AtomicLong();
    static final ThreadLocal<SingleThreadEventExecutor> CURRENT_EVENT_LOOP = new ThreadLocal();
    private final EventExecutor.Unsafe unsafe = new EventExecutor.Unsafe(){

        @Override
        public EventExecutor nextChild() {
            return SingleThreadEventExecutor.this;
        }
    };
    private final BlockingQueue<Runnable> taskQueue = QueueFactory.createQueue();
    private final Thread thread;
    private final Object stateLock = new Object();
    private final Semaphore threadLock = new Semaphore(0);
    private final Queue<ScheduledFutureTask<?>> scheduledTasks = new DelayQueue();
    private final Set<Runnable> shutdownHooks = new LinkedHashSet<Runnable>();
    private volatile int state;
    private long lastCheckTimeNanos;
    private long lastPurgeTimeNanos;

    public static SingleThreadEventExecutor currentEventLoop() {
        return CURRENT_EVENT_LOOP.get();
    }

    private static long nanoTime() {
        return System.nanoTime() - START_TIME;
    }

    private static long deadlineNanos(long delay) {
        return SingleThreadEventExecutor.nanoTime() + delay;
    }

    protected SingleThreadEventExecutor(ThreadFactory threadFactory) {
        this.thread = threadFactory.newThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CURRENT_EVENT_LOOP.set(SingleThreadEventExecutor.this);
                try {
                    SingleThreadEventExecutor.this.run();
                }
                finally {
                    try {
                        try {
                            this.cleanupTasks();
                        }
                        finally {
                            Object object = SingleThreadEventExecutor.this.stateLock;
                            synchronized (object) {
                                SingleThreadEventExecutor.this.state = 3;
                            }
                        }
                        this.cleanupTasks();
                    }
                    finally {
                        try {
                            SingleThreadEventExecutor.this.cleanup();
                        }
                        finally {
                            SingleThreadEventExecutor.this.threadLock.release();
                            assert (SingleThreadEventExecutor.this.taskQueue.isEmpty());
                        }
                    }
                }
            }

            private void cleanupTasks() {
                do {
                    boolean ran = false;
                    SingleThreadEventExecutor.this.cancelScheduledTasks();
                    ran |= SingleThreadEventExecutor.this.runAllTasks();
                } while ((ran |= SingleThreadEventExecutor.this.runShutdownHooks()) || SingleThreadEventExecutor.this.hasTasks());
            }
        });
    }

    @Override
    public EventExecutor.Unsafe unsafe() {
        return this.unsafe;
    }

    protected void interruptThread() {
        this.thread.interrupt();
    }

    protected Runnable pollTask() {
        assert (this.inEventLoop());
        Runnable task = (Runnable)this.taskQueue.poll();
        if (task != null) {
            return task;
        }
        if (this.fetchScheduledTasks()) {
            task = (Runnable)this.taskQueue.poll();
            return task;
        }
        return null;
    }

    protected Runnable takeTask() throws InterruptedException {
        Runnable task;
        assert (this.inEventLoop());
        do {
            if ((task = this.taskQueue.poll(SCHEDULE_CHECK_INTERVAL * 2L / 3L, TimeUnit.NANOSECONDS)) != null) {
                return task;
            }
            this.fetchScheduledTasks();
        } while ((task = (Runnable)this.taskQueue.poll()) == null);
        return task;
    }

    protected Runnable peekTask() {
        assert (this.inEventLoop());
        Runnable task = (Runnable)this.taskQueue.peek();
        if (task != null) {
            return task;
        }
        if (this.fetchScheduledTasks()) {
            task = (Runnable)this.taskQueue.peek();
            return task;
        }
        return null;
    }

    protected boolean hasTasks() {
        assert (this.inEventLoop());
        boolean empty = this.taskQueue.isEmpty();
        if (!empty) {
            return true;
        }
        if (this.fetchScheduledTasks()) {
            return !this.taskQueue.isEmpty();
        }
        return false;
    }

    protected void addTask(Runnable task) {
        if (task == null) {
            throw new NullPointerException("task");
        }
        if (this.isShutdown()) {
            SingleThreadEventExecutor.reject();
        }
        this.taskQueue.add(task);
    }

    protected boolean removeTask(Runnable task) {
        if (task == null) {
            throw new NullPointerException("task");
        }
        return this.taskQueue.remove(task);
    }

    protected boolean runAllTasks() {
        Runnable task;
        boolean ran = false;
        while ((task = this.pollTask()) != null) {
            try {
                task.run();
                ran = true;
            }
            catch (Throwable t) {
                logger.warn("A task raised an exception.", t);
            }
        }
        return ran;
    }

    protected abstract void run();

    protected void cleanup() {
    }

    protected abstract void wakeup(boolean var1);

    @Override
    public boolean inEventLoop() {
        return this.inEventLoop(Thread.currentThread());
    }

    @Override
    public boolean inEventLoop(Thread thread) {
        return thread == this.thread;
    }

    public void addShutdownHook(final Runnable task) {
        if (this.inEventLoop()) {
            this.shutdownHooks.add(task);
        } else {
            this.execute(new Runnable(){

                @Override
                public void run() {
                    SingleThreadEventExecutor.this.shutdownHooks.add(task);
                }
            });
        }
    }

    public void removeShutdownHook(final Runnable task) {
        if (this.inEventLoop()) {
            this.shutdownHooks.remove(task);
        } else {
            this.execute(new Runnable(){

                @Override
                public void run() {
                    SingleThreadEventExecutor.this.shutdownHooks.remove(task);
                }
            });
        }
    }

    private boolean runShutdownHooks() {
        boolean ran = false;
        while (!this.shutdownHooks.isEmpty()) {
            ArrayList<Runnable> copy = new ArrayList<Runnable>(this.shutdownHooks);
            this.shutdownHooks.clear();
            for (Runnable task : copy) {
                try {
                    task.run();
                    ran = true;
                }
                catch (Throwable t) {
                    logger.warn("Shutdown hook raised an exception.", t);
                }
            }
        }
        return ran;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        boolean inEventLoop = this.inEventLoop();
        boolean wakeup = false;
        if (inEventLoop) {
            Object object = this.stateLock;
            synchronized (object) {
                assert (this.state == 1);
                this.state = 2;
                wakeup = true;
            }
        }
        Object object = this.stateLock;
        synchronized (object) {
            switch (this.state) {
                case 0: {
                    this.state = 3;
                    try {
                        this.cleanup();
                        break;
                    }
                    finally {
                        this.threadLock.release();
                    }
                }
                case 1: {
                    this.state = 2;
                    wakeup = true;
                }
            }
        }
        if (wakeup) {
            this.wakeup(inEventLoop);
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.shutdown();
        return Collections.emptyList();
    }

    @Override
    public boolean isShutdown() {
        return this.state >= 2;
    }

    @Override
    public boolean isTerminated() {
        return this.state == 3;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        if (unit == null) {
            throw new NullPointerException("unit");
        }
        if (this.inEventLoop()) {
            throw new IllegalStateException("cannot await termination of the current thread");
        }
        if (this.threadLock.tryAcquire(timeout, unit)) {
            this.threadLock.release();
        }
        return this.isTerminated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Runnable task) {
        if (task == null) {
            throw new NullPointerException("task");
        }
        if (this.inEventLoop()) {
            this.addTask(task);
            this.wakeup(true);
        } else {
            Object object = this.stateLock;
            synchronized (object) {
                if (this.state == 0) {
                    this.state = 1;
                    this.thread.start();
                }
            }
            this.addTask(task);
            if (this.isShutdown() && this.removeTask(task)) {
                SingleThreadEventExecutor.reject();
            }
            this.wakeup(false);
        }
    }

    private static void reject() {
        throw new RejectedExecutionException("event executor shut down");
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        if (command == null) {
            throw new NullPointerException("command");
        }
        if (unit == null) {
            throw new NullPointerException("unit");
        }
        if (delay < 0L) {
            throw new IllegalArgumentException(String.format("delay: %d (expected: >= 0)", delay));
        }
        return this.schedule(new ScheduledFutureTask<Object>(command, null, SingleThreadEventExecutor.deadlineNanos(unit.toNanos(delay))));
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        if (callable == null) {
            throw new NullPointerException("callable");
        }
        if (unit == null) {
            throw new NullPointerException("unit");
        }
        if (delay < 0L) {
            throw new IllegalArgumentException(String.format("delay: %d (expected: >= 0)", delay));
        }
        return this.schedule(new ScheduledFutureTask<V>(callable, SingleThreadEventExecutor.deadlineNanos(unit.toNanos(delay))));
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        if (command == null) {
            throw new NullPointerException("command");
        }
        if (unit == null) {
            throw new NullPointerException("unit");
        }
        if (initialDelay < 0L) {
            throw new IllegalArgumentException(String.format("initialDelay: %d (expected: >= 0)", initialDelay));
        }
        if (period <= 0L) {
            throw new IllegalArgumentException(String.format("period: %d (expected: > 0)", period));
        }
        return this.schedule(new ScheduledFutureTask<Object>(command, null, SingleThreadEventExecutor.deadlineNanos(unit.toNanos(initialDelay)), unit.toNanos(period)));
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        if (command == null) {
            throw new NullPointerException("command");
        }
        if (unit == null) {
            throw new NullPointerException("unit");
        }
        if (initialDelay < 0L) {
            throw new IllegalArgumentException(String.format("initialDelay: %d (expected: >= 0)", initialDelay));
        }
        if (delay <= 0L) {
            throw new IllegalArgumentException(String.format("delay: %d (expected: > 0)", delay));
        }
        return this.schedule(new ScheduledFutureTask<Object>(command, null, SingleThreadEventExecutor.deadlineNanos(unit.toNanos(initialDelay)), -unit.toNanos(delay)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <V> ScheduledFuture<V> schedule(ScheduledFutureTask<V> task) {
        if (this.isShutdown()) {
            SingleThreadEventExecutor.reject();
        }
        this.scheduledTasks.add(task);
        if (this.isShutdown()) {
            task.cancel(false);
        }
        if (!this.inEventLoop()) {
            Object object = this.stateLock;
            synchronized (object) {
                if (this.state == 0) {
                    this.state = 1;
                    this.thread.start();
                }
            }
        } else {
            this.fetchScheduledTasks();
        }
        return task;
    }

    private boolean fetchScheduledTasks() {
        ScheduledFutureTask<?> task;
        if (this.scheduledTasks.isEmpty()) {
            return false;
        }
        long nanoTime = SingleThreadEventExecutor.nanoTime();
        if (nanoTime - this.lastPurgeTimeNanos >= SCHEDULE_PURGE_INTERVAL) {
            Iterator i = this.scheduledTasks.iterator();
            while (i.hasNext()) {
                task = (ScheduledFutureTask<?>)i.next();
                if (!task.isCancelled()) continue;
                i.remove();
            }
        }
        if (nanoTime - this.lastCheckTimeNanos >= SCHEDULE_CHECK_INTERVAL) {
            boolean added = false;
            while ((task = this.scheduledTasks.poll()) != null) {
                if (task.isCancelled()) continue;
                if (this.isShutdown()) {
                    task.cancel(false);
                    continue;
                }
                this.taskQueue.add(task);
                added = true;
            }
            return added;
        }
        return false;
    }

    private void cancelScheduledTasks() {
        if (this.scheduledTasks.isEmpty()) {
            return;
        }
        for (ScheduledFutureTask task : this.scheduledTasks.toArray(new ScheduledFutureTask[this.scheduledTasks.size()])) {
            task.cancel(false);
        }
        this.scheduledTasks.clear();
    }

    private class ScheduledFutureTask<V>
    extends FutureTask<V>
    implements ScheduledFuture<V> {
        private final long id;
        private long deadlineNanos;
        private final long periodNanos;

        ScheduledFutureTask(Runnable runnable, V result, long nanoTime) {
            super(runnable, result);
            this.id = nextTaskId.getAndIncrement();
            this.deadlineNanos = nanoTime;
            this.periodNanos = 0L;
        }

        ScheduledFutureTask(Runnable runnable, V result, long nanoTime, long period) {
            super(runnable, result);
            this.id = nextTaskId.getAndIncrement();
            if (period == 0L) {
                throw new IllegalArgumentException(String.format("period: %d (expected: != 0)", period));
            }
            this.deadlineNanos = nanoTime;
            this.periodNanos = period;
        }

        ScheduledFutureTask(Callable<V> callable, long nanoTime) {
            super(callable);
            this.id = nextTaskId.getAndIncrement();
            this.deadlineNanos = nanoTime;
            this.periodNanos = 0L;
        }

        public long deadlineNanos() {
            return this.deadlineNanos;
        }

        public long delayNanos() {
            return Math.max(0L, this.deadlineNanos() - SingleThreadEventExecutor.nanoTime());
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.delayNanos(), TimeUnit.NANOSECONDS);
        }

        @Override
        public int compareTo(Delayed o) {
            if (this == o) {
                return 0;
            }
            ScheduledFutureTask that = (ScheduledFutureTask)o;
            long d = this.deadlineNanos() - that.deadlineNanos();
            if (d < 0L) {
                return -1;
            }
            if (d > 0L) {
                return 1;
            }
            if (this.id < that.id) {
                return -1;
            }
            if (this.id == that.id) {
                throw new Error();
            }
            return 1;
        }

        @Override
        public void run() {
            if (this.periodNanos == 0L) {
                super.run();
            } else {
                boolean reset = this.runAndReset();
                if (reset && !SingleThreadEventExecutor.this.isShutdown()) {
                    long p = this.periodNanos;
                    this.deadlineNanos = p > 0L ? (this.deadlineNanos += p) : SingleThreadEventExecutor.nanoTime() - p;
                    SingleThreadEventExecutor.this.schedule(this);
                }
            }
        }
    }
}

