/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.socket.oio;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.oio.AbstractOioChannel;
import java.io.IOException;

abstract class AbstractOioByteChannel
extends AbstractOioChannel {
    protected AbstractOioByteChannel(Channel parent, Integer id) {
        super(parent, id);
    }

    @Override
    protected Channel.Unsafe newUnsafe() {
        return new OioByteUnsafe();
    }

    @Override
    protected void doFlushByteBuffer(ByteBuf buf) throws Exception {
        while (buf.readable()) {
            this.doWriteBytes(buf);
        }
        buf.clear();
    }

    protected abstract int available();

    protected abstract int doReadBytes(ByteBuf var1) throws Exception;

    protected abstract void doWriteBytes(ByteBuf var1) throws Exception;

    private class OioByteUnsafe
    extends AbstractOioChannel.AbstractOioUnsafe {
        private OioByteUnsafe() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void read() {
            assert (AbstractOioByteChannel.this.eventLoop().inEventLoop());
            ChannelPipeline pipeline = AbstractOioByteChannel.this.pipeline();
            ByteBuf byteBuf = pipeline.inboundByteBuffer();
            boolean closed = false;
            boolean read = false;
            try {
                this.expandReadBuffer(byteBuf);
                int localReadAmount = AbstractOioByteChannel.this.doReadBytes(byteBuf);
                if (localReadAmount > 0) {
                    read = true;
                } else if (localReadAmount < 0) {
                    closed = true;
                }
            }
            catch (Throwable t) {
                if (read) {
                    read = false;
                    pipeline.fireInboundBufferUpdated();
                }
                AbstractOioByteChannel.this.pipeline().fireExceptionCaught(t);
                if (t instanceof IOException) {
                    this.close(this.voidFuture());
                }
            }
            finally {
                if (read) {
                    pipeline.fireInboundBufferUpdated();
                }
                if (closed && AbstractOioByteChannel.this.isOpen()) {
                    this.close(this.voidFuture());
                }
            }
        }

        private void expandReadBuffer(ByteBuf byteBuf) {
            int available = AbstractOioByteChannel.this.available();
            if (available > 0) {
                byteBuf.ensureWritableBytes(available);
            } else if (!byteBuf.writable()) {
                byteBuf.ensureWritableBytes(4096);
            }
        }
    }
}

