/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.socket.aio;

import io.netty.channel.ChannelTaskScheduler;
import io.netty.channel.EventExecutor;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopException;
import io.netty.channel.MultithreadEventLoopGroup;
import io.netty.channel.socket.aio.AbstractAioChannel;
import io.netty.channel.socket.aio.AioChannelFinder;
import io.netty.channel.socket.aio.AioEventLoop;
import io.netty.channel.socket.aio.ReflectiveAioChannelFinder;
import io.netty.channel.socket.aio.UnsafeAioChannelFinder;
import io.netty.logging.InternalLogger;
import io.netty.logging.InternalLoggerFactory;
import io.netty.util.internal.DetectionUtil;
import java.io.IOException;
import java.nio.channels.AsynchronousChannelGroup;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class AioEventLoopGroup
extends MultithreadEventLoopGroup {
    private static final InternalLogger LOGGER;
    private static final AioChannelFinder CHANNEL_FINDER;
    final AsynchronousChannelGroup group;

    public AioEventLoopGroup() {
        this(0);
    }

    public AioEventLoopGroup(int nThreads) {
        this(nThreads, null);
    }

    public AioEventLoopGroup(int nThreads, ThreadFactory threadFactory) {
        super(nThreads, threadFactory, new Object[0]);
        try {
            this.group = AsynchronousChannelGroup.withThreadPool(new AioExecutorService());
        }
        catch (IOException e) {
            throw new EventLoopException("Failed to create an AsynchronousChannelGroup", e);
        }
    }

    @Override
    protected EventExecutor newChild(ThreadFactory threadFactory, ChannelTaskScheduler scheduler, Object ... args) throws Exception {
        return new AioEventLoop(this, threadFactory, scheduler);
    }

    private void executeAioTask(Runnable command) {
        AbstractAioChannel ch = null;
        try {
            ch = CHANNEL_FINDER.findChannel(command);
        }
        catch (Throwable t) {
            // empty catch block
        }
        EventLoop l = ch != null ? ch.eventLoop() : this.next();
        if (l.isShutdown()) {
            command.run();
        } else {
            l.execute(command);
        }
    }

    static {
        AioChannelFinder finder;
        LOGGER = InternalLoggerFactory.getInstance(AioEventLoopGroup.class);
        try {
            finder = DetectionUtil.hasUnsafe() ? new UnsafeAioChannelFinder() : new ReflectiveAioChannelFinder();
        }
        catch (Throwable t) {
            LOGGER.debug(String.format("Failed to instantiate the optimal %s implementation - falling back to %s.", AioChannelFinder.class.getSimpleName(), ReflectiveAioChannelFinder.class.getSimpleName()), t);
            finder = new ReflectiveAioChannelFinder();
        }
        CHANNEL_FINDER = finder;
    }

    private final class AioExecutorService
    extends AbstractExecutorService {
        private AioExecutorService() {
        }

        @Override
        public void shutdown() {
            AioEventLoopGroup.this.shutdown();
        }

        @Override
        public List<Runnable> shutdownNow() {
            AioEventLoopGroup.this.shutdown();
            return Collections.emptyList();
        }

        @Override
        public boolean isShutdown() {
            return AioEventLoopGroup.this.isShutdown();
        }

        @Override
        public boolean isTerminated() {
            return AioEventLoopGroup.this.isTerminated();
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return AioEventLoopGroup.this.awaitTermination(timeout, unit);
        }

        @Override
        public void execute(Runnable command) {
            Class<?> commandType = command.getClass();
            if (commandType.getName().startsWith("sun.nio.ch.")) {
                AioEventLoopGroup.this.executeAioTask(command);
            } else {
                AioEventLoopGroup.this.next().execute(command);
            }
        }
    }
}

