/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.socket.nio;

import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelTaskScheduler;
import io.netty.channel.SingleThreadEventLoop;
import io.netty.channel.socket.nio.AbstractNioChannel;
import io.netty.channel.socket.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.SelectorUtil;
import io.netty.logging.InternalLogger;
import io.netty.logging.InternalLoggerFactory;
import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;

final class NioEventLoop
extends SingleThreadEventLoop {
    protected static final InternalLogger logger = InternalLoggerFactory.getInstance(NioEventLoop.class);
    static final int CLEANUP_INTERVAL = 256;
    protected Selector selector;
    protected final SelectorProvider provider;
    protected final AtomicBoolean wakenUp = new AtomicBoolean();
    private int cancelledKeys;
    private boolean cleanedCancelledKeys;

    NioEventLoop(NioEventLoopGroup parent, ThreadFactory threadFactory, ChannelTaskScheduler scheduler, SelectorProvider selectorProvider) {
        super(parent, threadFactory, scheduler);
        if (selectorProvider == null) {
            throw new NullPointerException("selectorProvider");
        }
        this.provider = selectorProvider;
        this.selector = this.openSelector();
    }

    private Selector openSelector() {
        try {
            return this.provider.openSelector();
        }
        catch (IOException e) {
            throw new ChannelException("failed to open a new selector", e);
        }
    }

    @Override
    protected Queue<Runnable> newTaskQueue() {
        return new ConcurrentLinkedQueue<Runnable>();
    }

    private Selector recreateSelector() {
        Selector newSelector = this.openSelector();
        Selector selector = this.selector;
        this.selector = newSelector;
        for (SelectionKey key : selector.keys()) {
            SelectableChannel ch = key.channel();
            int ops = key.interestOps();
            Object att = key.attachment();
            this.cancel(key);
            try {
                ch.register(newSelector, ops, att);
            }
            catch (ClosedChannelException e) {
                AbstractNioChannel channel = (AbstractNioChannel)att;
                channel.unsafe().close(channel.unsafe().voidFuture());
            }
        }
        try {
            selector.close();
        }
        catch (Throwable t) {
            logger.warn("Failed to close a selector.", t);
        }
        logger.warn("Recreated Selector because of possible jdk epoll(..) bug");
        return newSelector;
    }

    @Override
    protected void run() {
        Selector selector = this.selector;
        int selectReturnsImmediately = 0;
        long minSelectTimeout = SelectorUtil.SELECT_TIMEOUT_NANOS / 100L * 80L;
        while (true) {
            this.wakenUp.set(false);
            try {
                long beforeSelect = System.nanoTime();
                int selected = SelectorUtil.select(selector);
                if (selected == 0) {
                    long timeBlocked = System.nanoTime() - beforeSelect;
                    selectReturnsImmediately = timeBlocked < minSelectTimeout ? ++selectReturnsImmediately : 0;
                    if (selectReturnsImmediately == 10) {
                        selector = this.recreateSelector();
                        selectReturnsImmediately = 0;
                        continue;
                    }
                } else {
                    selectReturnsImmediately = 0;
                }
                if (this.wakenUp.get()) {
                    selector.wakeup();
                }
                this.cancelledKeys = 0;
                this.runAllTasks();
                this.processSelectedKeys();
                if (!this.isShutdown()) continue;
                this.closeAll();
                if (this.peekTask() != null) continue;
            }
            catch (Throwable t) {
                logger.warn("Unexpected exception in the selector loop.", t);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {}
                continue;
            }
            break;
        }
    }

    @Override
    protected void cleanup() {
        try {
            this.selector.close();
        }
        catch (IOException e) {
            logger.warn("Failed to close a selector.", (Throwable)e);
        }
    }

    void cancel(SelectionKey key) {
        key.cancel();
        ++this.cancelledKeys;
        if (this.cancelledKeys >= 256) {
            this.cancelledKeys = 0;
            this.cleanedCancelledKeys = true;
            SelectorUtil.cleanupKeys(this.selector);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processSelectedKeys() {
        Set<SelectionKey> selectedKeys = this.selector.selectedKeys();
        if (selectedKeys.isEmpty()) {
            return;
        }
        this.cleanedCancelledKeys = false;
        boolean clearSelectedKeys = true;
        try {
            Iterator<SelectionKey> i = selectedKeys.iterator();
            while (i.hasNext()) {
                SelectionKey k = i.next();
                AbstractNioChannel ch = (AbstractNioChannel)k.attachment();
                AbstractNioChannel.NioUnsafe unsafe = ch.unsafe();
                try {
                    int readyOps = k.readyOps();
                    if ((readyOps & 0x11) != 0 || readyOps == 0) {
                        unsafe.read();
                        if (!ch.isOpen()) continue;
                    }
                    if ((readyOps & 4) != 0) {
                        unsafe.flushNow();
                    }
                    if ((readyOps & 8) != 0) {
                        unsafe.finishConnect();
                    }
                }
                catch (CancelledKeyException ignored) {
                    unsafe.close(unsafe.voidFuture());
                }
                if (!this.cleanedCancelledKeys) continue;
                if (selectedKeys.isEmpty()) {
                    clearSelectedKeys = false;
                    break;
                }
                i = selectedKeys.iterator();
            }
        }
        finally {
            if (clearSelectedKeys) {
                selectedKeys.clear();
            }
        }
    }

    private void closeAll() {
        SelectorUtil.cleanupKeys(this.selector);
        Set<SelectionKey> keys = this.selector.keys();
        ArrayList<Channel> channels = new ArrayList<Channel>(keys.size());
        for (SelectionKey k : keys) {
            channels.add((Channel)k.attachment());
        }
        for (Channel ch : channels) {
            ch.unsafe().close(ch.unsafe().voidFuture());
        }
    }

    @Override
    protected void wakeup(boolean inEventLoop) {
        if (this.wakenUp.compareAndSet(false, true)) {
            this.selector.wakeup();
        }
    }
}

