/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ChannelBuf;
import io.netty.buffer.UnsafeByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundByteHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;

public abstract class ChannelInboundByteHandlerAdapter
extends ChannelInboundHandlerAdapter
implements ChannelInboundByteHandler {
    @Override
    public ByteBuf newInboundBuffer(ChannelHandlerContext ctx) throws Exception {
        return ctx.alloc().buffer();
    }

    @Override
    public void freeInboundBuffer(ChannelHandlerContext ctx, ChannelBuf buf) throws Exception {
        ((UnsafeByteBuf)buf).free();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void inboundBufferUpdated(ChannelHandlerContext ctx) throws Exception {
        ByteBuf in = ctx.inboundByteBuffer();
        try {
            this.inboundBufferUpdated(ctx, in);
        }
        finally {
            if (!in.readable()) {
                ((UnsafeByteBuf)in).discardSomeReadBytes();
            }
        }
    }

    public abstract void inboundBufferUpdated(ChannelHandlerContext var1, ByteBuf var2) throws Exception;
}

