/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.buffer.BufType;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.MessageBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFlushPromiseNotifier;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelPipeline;
import io.netty.channel.DefaultChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.channel.FailedChannelFuture;
import io.netty.channel.FileRegion;
import io.netty.channel.SucceededChannelFuture;
import io.netty.channel.VoidChannelPromise;
import io.netty.util.DefaultAttributeMap;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.Random;
import java.util.concurrent.ConcurrentMap;

public abstract class AbstractChannel
extends DefaultAttributeMap
implements Channel {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractChannel.class);
    static final ConcurrentMap<Integer, Channel> allChannels = PlatformDependent.newConcurrentHashMap();
    private static final Random random = new Random();
    private final Channel parent;
    private final Integer id;
    private final Channel.Unsafe unsafe;
    private final DefaultChannelPipeline pipeline;
    private final ChannelFuture succeededFuture = new SucceededChannelFuture(this);
    private final VoidChannelPromise voidPromise = new VoidChannelPromise(this);
    private final CloseFuture closeFuture = new CloseFuture(this);
    protected final ChannelFlushPromiseNotifier flushFutureNotifier = new ChannelFlushPromiseNotifier();
    private volatile SocketAddress localAddress;
    private volatile SocketAddress remoteAddress;
    private volatile EventLoop eventLoop;
    private volatile boolean registered;
    private ClosedChannelException closedChannelException;
    private boolean inFlushNow;
    private boolean flushNowPending;
    private boolean strValActive;
    private String strVal;

    private static Integer allocateId(Channel channel) {
        int idVal = random.nextInt();
        if (idVal > 0) {
            idVal = -idVal;
        } else if (idVal == 0) {
            idVal = -1;
        }
        Integer id;
        while (allChannels.putIfAbsent(id = Integer.valueOf(idVal), channel) != null) {
            if (--idVal < 0) continue;
            idVal = -1;
        }
        return id;
    }

    protected AbstractChannel(Channel parent, Integer id) {
        if (id == null) {
            id = AbstractChannel.allocateId(this);
        } else {
            if (id < 0) {
                throw new IllegalArgumentException("id: " + id + " (expected: >= 0)");
            }
            if (allChannels.putIfAbsent(id, this) != null) {
                throw new IllegalArgumentException("duplicate ID: " + id);
            }
        }
        this.parent = parent;
        this.id = id;
        this.unsafe = this.newUnsafe();
        this.pipeline = new DefaultChannelPipeline(this);
        this.closeFuture().addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) {
                allChannels.remove(AbstractChannel.this.id());
            }
        });
    }

    @Override
    public final Integer id() {
        return this.id;
    }

    @Override
    public Channel parent() {
        return this.parent;
    }

    @Override
    public ChannelPipeline pipeline() {
        return this.pipeline;
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.config().getAllocator();
    }

    @Override
    public EventLoop eventLoop() {
        EventLoop eventLoop = this.eventLoop;
        if (eventLoop == null) {
            throw new IllegalStateException("channel not registered to an event loop");
        }
        return eventLoop;
    }

    @Override
    public SocketAddress localAddress() {
        SocketAddress localAddress = this.localAddress;
        if (localAddress == null) {
            try {
                this.localAddress = localAddress = this.unsafe().localAddress();
            }
            catch (Throwable t) {
                return null;
            }
        }
        return localAddress;
    }

    protected void invalidateLocalAddress() {
        this.localAddress = null;
    }

    @Override
    public SocketAddress remoteAddress() {
        SocketAddress remoteAddress = this.remoteAddress;
        if (remoteAddress == null) {
            try {
                this.remoteAddress = remoteAddress = this.unsafe().remoteAddress();
            }
            catch (Throwable t) {
                return null;
            }
        }
        return remoteAddress;
    }

    protected void invalidateRemoteAddress() {
        this.remoteAddress = null;
    }

    @Override
    public boolean isRegistered() {
        return this.registered;
    }

    @Override
    public ChannelFuture bind(SocketAddress localAddress) {
        return this.pipeline.bind(localAddress);
    }

    @Override
    public ChannelFuture connect(SocketAddress remoteAddress) {
        return this.pipeline.connect(remoteAddress);
    }

    @Override
    public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress) {
        return this.pipeline.connect(remoteAddress, localAddress);
    }

    @Override
    public ChannelFuture disconnect() {
        return this.pipeline.disconnect();
    }

    @Override
    public ChannelFuture close() {
        return this.pipeline.close();
    }

    @Override
    public ChannelFuture deregister() {
        return this.pipeline.deregister();
    }

    @Override
    public ChannelFuture flush() {
        return this.pipeline.flush();
    }

    @Override
    public ChannelFuture write(Object message) {
        return this.pipeline.write(message);
    }

    @Override
    public ChannelFuture bind(SocketAddress localAddress, ChannelPromise promise) {
        return this.pipeline.bind(localAddress, promise);
    }

    @Override
    public ChannelFuture connect(SocketAddress remoteAddress, ChannelPromise promise) {
        return this.pipeline.connect(remoteAddress, promise);
    }

    @Override
    public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
        return this.pipeline.connect(remoteAddress, localAddress, promise);
    }

    @Override
    public ChannelFuture disconnect(ChannelPromise promise) {
        return this.pipeline.disconnect(promise);
    }

    @Override
    public ChannelFuture close(ChannelPromise promise) {
        return this.pipeline.close(promise);
    }

    @Override
    public ChannelFuture deregister(ChannelPromise promise) {
        return this.pipeline.deregister(promise);
    }

    @Override
    public ByteBuf outboundByteBuffer() {
        return this.pipeline.outboundByteBuffer();
    }

    @Override
    public <T> MessageBuf<T> outboundMessageBuffer() {
        return this.pipeline.outboundMessageBuffer();
    }

    @Override
    public void read() {
        this.pipeline.read();
    }

    @Override
    public ChannelFuture flush(ChannelPromise promise) {
        return this.pipeline.flush(promise);
    }

    @Override
    public ChannelFuture write(Object message, ChannelPromise promise) {
        return this.pipeline.write(message, promise);
    }

    @Override
    public ChannelPromise newPromise() {
        return new DefaultChannelPromise(this);
    }

    @Override
    public ChannelFuture newSucceededFuture() {
        return this.succeededFuture;
    }

    @Override
    public ChannelFuture newFailedFuture(Throwable cause) {
        return new FailedChannelFuture(this, cause);
    }

    @Override
    public ChannelFuture closeFuture() {
        return this.closeFuture;
    }

    @Override
    public Channel.Unsafe unsafe() {
        return this.unsafe;
    }

    @Override
    public ChannelFuture sendFile(FileRegion region) {
        return this.pipeline.sendFile(region);
    }

    @Override
    public ChannelFuture sendFile(FileRegion region, ChannelPromise promise) {
        return this.pipeline.sendFile(region, promise);
    }

    protected static int expandReadBuffer(ByteBuf byteBuf) {
        int writerIndex = byteBuf.writerIndex();
        int capacity = byteBuf.capacity();
        if (capacity != writerIndex) {
            return 0;
        }
        int maxCapacity = byteBuf.maxCapacity();
        if (capacity == maxCapacity) {
            return 2;
        }
        int increment = 4096;
        if (writerIndex + 4096 > maxCapacity) {
            byteBuf.capacity(maxCapacity);
        } else {
            byteBuf.ensureWritable(4096);
        }
        return 1;
    }

    protected abstract AbstractUnsafe newUnsafe();

    public final int hashCode() {
        return this.id;
    }

    public final boolean equals(Object o) {
        return this == o;
    }

    @Override
    public final int compareTo(Channel o) {
        return this.id().compareTo(o.id());
    }

    public String toString() {
        boolean active = this.isActive();
        if (this.strValActive == active && this.strVal != null) {
            return this.strVal;
        }
        SocketAddress remoteAddr = this.remoteAddress();
        SocketAddress localAddr = this.localAddress();
        if (remoteAddr != null) {
            SocketAddress dstAddr;
            SocketAddress srcAddr;
            if (this.parent == null) {
                srcAddr = localAddr;
                dstAddr = remoteAddr;
            } else {
                srcAddr = remoteAddr;
                dstAddr = localAddr;
            }
            this.strVal = String.format("[id: 0x%08x, %s %s %s]", this.id, srcAddr, active ? "=>" : ":>", dstAddr);
        } else {
            this.strVal = localAddr != null ? String.format("[id: 0x%08x, %s]", this.id, localAddr) : String.format("[id: 0x%08x]", this.id);
        }
        this.strValActive = active;
        return this.strVal;
    }

    protected abstract boolean isCompatible(EventLoop var1);

    protected abstract SocketAddress localAddress0();

    protected abstract SocketAddress remoteAddress0();

    protected Runnable doRegister() throws Exception {
        return null;
    }

    protected abstract void doBind(SocketAddress var1) throws Exception;

    protected abstract void doDisconnect() throws Exception;

    protected void doPreClose() throws Exception {
    }

    protected abstract void doClose() throws Exception;

    protected void doDeregister() throws Exception {
    }

    protected abstract void doBeginRead() throws Exception;

    protected void doFlushByteBuffer(ByteBuf buf) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected void doFlushMessageBuffer(MessageBuf<Object> buf) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected void doFlushFileRegion(FileRegion region, ChannelPromise promise) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected static void checkEOF(FileRegion region, long writtenBytes) throws IOException {
        if (writtenBytes < region.count()) {
            throw new EOFException("Expected to be able to write " + region.count() + " bytes, but only wrote " + writtenBytes);
        }
    }

    protected abstract boolean isFlushPending();

    private final class CloseFuture
    extends DefaultChannelPromise
    implements ChannelFuture.Unsafe {
        CloseFuture(AbstractChannel ch) {
            super(ch);
        }

        @Override
        public ChannelPromise setSuccess() {
            throw new IllegalStateException();
        }

        @Override
        public ChannelPromise setFailure(Throwable cause) {
            throw new IllegalStateException();
        }

        @Override
        public boolean trySuccess() {
            throw new IllegalStateException();
        }

        @Override
        public boolean tryFailure(Throwable cause) {
            throw new IllegalStateException();
        }

        boolean setClosed() {
            try {
                AbstractChannel.this.doPreClose();
            }
            catch (Exception e) {
                logger.warn("doPreClose() raised an exception.", (Throwable)e);
            }
            return super.trySuccess();
        }
    }

    protected abstract class AbstractUnsafe
    implements Channel.Unsafe {
        private final Runnable beginReadTask = new Runnable(){

            @Override
            public void run() {
                AbstractUnsafe.this.beginRead();
            }
        };
        private final Runnable flushLaterTask = new Runnable(){

            @Override
            public void run() {
                AbstractChannel.this.flushNowPending = false;
                AbstractUnsafe.this.flush(AbstractUnsafe.this.voidFuture());
            }
        };
        private FlushTask flushTaskInProgress;

        protected AbstractUnsafe() {
        }

        @Override
        public final void sendFile(final FileRegion region, final ChannelPromise promise) {
            if (AbstractChannel.this.eventLoop().inEventLoop()) {
                if (this.outboundBufSize() > 0) {
                    this.flushNotifier(AbstractChannel.this.newPromise()).addListener(new ChannelFutureListener(){

                        @Override
                        public void operationComplete(ChannelFuture cf) throws Exception {
                            AbstractUnsafe.this.sendFile0(region, promise);
                        }
                    });
                } else {
                    this.sendFile0(region, promise);
                }
            } else {
                AbstractChannel.this.eventLoop().execute(new Runnable(){

                    @Override
                    public void run() {
                        AbstractUnsafe.this.sendFile(region, promise);
                    }
                });
            }
        }

        private void sendFile0(FileRegion region, ChannelPromise promise) {
            FlushTask next;
            FlushTask task = this.flushTaskInProgress;
            if (task == null) {
                this.flushTaskInProgress = new FlushTask(region, promise);
                try {
                    AbstractChannel.this.doFlushFileRegion(region, promise);
                }
                catch (Throwable cause) {
                    region.release();
                    promise.setFailure(cause);
                }
                return;
            }
            while ((next = task.next) != null) {
                task = next;
            }
            task.next = new FlushTask(region, promise);
        }

        @Override
        public final ChannelHandlerContext directOutboundContext() {
            return ((AbstractChannel)AbstractChannel.this).pipeline.head;
        }

        @Override
        public final ChannelPromise voidFuture() {
            return AbstractChannel.this.voidPromise;
        }

        @Override
        public final SocketAddress localAddress() {
            return AbstractChannel.this.localAddress0();
        }

        @Override
        public final SocketAddress remoteAddress() {
            return AbstractChannel.this.remoteAddress0();
        }

        @Override
        public final void register(EventLoop eventLoop, final ChannelPromise promise) {
            if (eventLoop == null) {
                throw new NullPointerException("eventLoop");
            }
            if (AbstractChannel.this.isRegistered()) {
                throw new IllegalStateException("registered to an event loop already");
            }
            if (!AbstractChannel.this.isCompatible(eventLoop)) {
                throw new IllegalStateException("incompatible event loop type: " + eventLoop.getClass().getName());
            }
            AbstractChannel.this.eventLoop = eventLoop;
            assert (AbstractChannel.this.eventLoop().inEventLoop());
            if (eventLoop.inEventLoop()) {
                this.register0(promise);
            } else {
                eventLoop.execute(new Runnable(){

                    @Override
                    public void run() {
                        AbstractUnsafe.this.register0(promise);
                    }
                });
            }
        }

        private void register0(ChannelPromise promise) {
            try {
                if (!this.ensureOpen(promise)) {
                    return;
                }
                Runnable postRegisterTask = AbstractChannel.this.doRegister();
                AbstractChannel.this.registered = true;
                promise.setSuccess();
                AbstractChannel.this.pipeline.fireChannelRegistered();
                if (postRegisterTask != null) {
                    postRegisterTask.run();
                }
                if (AbstractChannel.this.isActive()) {
                    AbstractChannel.this.pipeline.fireChannelActive();
                }
            }
            catch (Throwable t) {
                try {
                    AbstractChannel.this.doClose();
                }
                catch (Throwable t2) {
                    logger.warn("Failed to close a channel", t2);
                }
                promise.setFailure(t);
                AbstractChannel.this.closeFuture.setClosed();
            }
        }

        @Override
        public final void bind(final SocketAddress localAddress, final ChannelPromise promise) {
            if (AbstractChannel.this.eventLoop().inEventLoop()) {
                if (!this.ensureOpen(promise)) {
                    return;
                }
                try {
                    boolean wasActive = AbstractChannel.this.isActive();
                    if (!PlatformDependent.isWindows() && !PlatformDependent.isRoot() && Boolean.TRUE.equals(AbstractChannel.this.config().getOption(ChannelOption.SO_BROADCAST)) && localAddress instanceof InetSocketAddress && !((InetSocketAddress)localAddress).getAddress().isAnyLocalAddress()) {
                        logger.warn("A non-root user can't receive a broadcast packet if the socket is not bound to a wildcard address; binding to a non-wildcard address (" + localAddress + ") anyway as requested.");
                    }
                    AbstractChannel.this.doBind(localAddress);
                    promise.setSuccess();
                    if (!wasActive && AbstractChannel.this.isActive()) {
                        AbstractChannel.this.pipeline.fireChannelActive();
                    }
                }
                catch (Throwable t) {
                    promise.setFailure(t);
                    this.closeIfClosed();
                }
            } else {
                AbstractChannel.this.eventLoop().execute(new Runnable(){

                    @Override
                    public void run() {
                        AbstractUnsafe.this.bind(localAddress, promise);
                    }
                });
            }
        }

        @Override
        public final void disconnect(final ChannelPromise promise) {
            if (AbstractChannel.this.eventLoop().inEventLoop()) {
                try {
                    boolean wasActive = AbstractChannel.this.isActive();
                    AbstractChannel.this.doDisconnect();
                    promise.setSuccess();
                    if (wasActive && !AbstractChannel.this.isActive()) {
                        AbstractChannel.this.pipeline.fireChannelInactive();
                    }
                }
                catch (Throwable t) {
                    promise.setFailure(t);
                    this.closeIfClosed();
                }
            } else {
                AbstractChannel.this.eventLoop().execute(new Runnable(){

                    @Override
                    public void run() {
                        AbstractUnsafe.this.disconnect(promise);
                    }
                });
            }
        }

        @Override
        public final void close(final ChannelPromise promise) {
            if (AbstractChannel.this.eventLoop().inEventLoop()) {
                boolean wasActive = AbstractChannel.this.isActive();
                if (AbstractChannel.this.closeFuture.setClosed()) {
                    try {
                        AbstractChannel.this.doClose();
                        promise.setSuccess();
                    }
                    catch (Throwable t) {
                        promise.setFailure(t);
                    }
                    if (AbstractChannel.this.closedChannelException != null) {
                        AbstractChannel.this.closedChannelException = new ClosedChannelException();
                    }
                    AbstractChannel.this.flushFutureNotifier.notifyFlushFutures(AbstractChannel.this.closedChannelException);
                    if (wasActive && !AbstractChannel.this.isActive()) {
                        AbstractChannel.this.pipeline.fireChannelInactive();
                    }
                    this.deregister(this.voidFuture());
                } else {
                    promise.setSuccess();
                }
            } else {
                AbstractChannel.this.eventLoop().execute(new Runnable(){

                    @Override
                    public void run() {
                        AbstractUnsafe.this.close(promise);
                    }
                });
            }
        }

        @Override
        public final void closeForcibly() {
            try {
                AbstractChannel.this.doClose();
            }
            catch (Exception e) {
                logger.warn("Failed to close a channel.", (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void deregister(final ChannelPromise promise) {
            if (AbstractChannel.this.eventLoop().inEventLoop()) {
                if (!AbstractChannel.this.registered) {
                    promise.setSuccess();
                    return;
                }
                try {
                    AbstractChannel.this.doDeregister();
                }
                catch (Throwable t) {
                    logger.warn("Unexpected exception occurred while deregistering a channel.", t);
                }
                finally {
                    if (AbstractChannel.this.registered) {
                        AbstractChannel.this.registered = false;
                        promise.setSuccess();
                        AbstractChannel.this.pipeline.fireChannelUnregistered();
                    } else {
                        promise.setSuccess();
                    }
                }
            } else {
                AbstractChannel.this.eventLoop().execute(new Runnable(){

                    @Override
                    public void run() {
                        AbstractUnsafe.this.deregister(promise);
                    }
                });
            }
        }

        @Override
        public void beginRead() {
            if (!AbstractChannel.this.isActive()) {
                return;
            }
            if (AbstractChannel.this.eventLoop().inEventLoop()) {
                try {
                    AbstractChannel.this.doBeginRead();
                }
                catch (Exception e) {
                    AbstractChannel.this.pipeline().fireExceptionCaught(e);
                    this.close(AbstractChannel.this.unsafe().voidFuture());
                }
            } else {
                AbstractChannel.this.eventLoop().execute(this.beginReadTask);
            }
        }

        @Override
        public void flush(final ChannelPromise promise) {
            if (AbstractChannel.this.eventLoop().inEventLoop()) {
                FlushTask task = this.flushTaskInProgress;
                if (task != null) {
                    FlushTask t;
                    while ((t = task.next) != null) {
                        task = t.next;
                    }
                    task.next = new FlushTask(null, promise);
                    return;
                }
                this.flushNotifierAndFlush(promise);
            } else {
                AbstractChannel.this.eventLoop().execute(new Runnable(){

                    @Override
                    public void run() {
                        AbstractUnsafe.this.flush(promise);
                    }
                });
            }
        }

        private void flushNotifierAndFlush(ChannelPromise promise) {
            this.flushNotifier(promise);
            this.flush0();
        }

        private int outboundBufSize() {
            ChannelHandlerContext ctx = this.directOutboundContext();
            int bufSize = AbstractChannel.this.metadata().bufferType() == BufType.BYTE ? ctx.outboundByteBuffer().readableBytes() : ctx.outboundMessageBuffer().size();
            return bufSize;
        }

        private ChannelFuture flushNotifier(ChannelPromise promise) {
            if (promise != AbstractChannel.this.voidPromise) {
                AbstractChannel.this.flushFutureNotifier.add(promise, this.outboundBufSize());
            }
            return promise;
        }

        private void flush0() {
            block6: {
                if (!AbstractChannel.this.inFlushNow) {
                    try {
                        if (!AbstractChannel.this.isFlushPending()) {
                            this.flushNow();
                        }
                        break block6;
                    }
                    catch (Throwable t) {
                        AbstractChannel.this.flushFutureNotifier.notifyFlushFutures(t);
                        if (t instanceof IOException) {
                            this.close(this.voidFuture());
                        }
                        break block6;
                    }
                }
                if (!AbstractChannel.this.flushNowPending) {
                    AbstractChannel.this.flushNowPending = true;
                    AbstractChannel.this.eventLoop().execute(this.flushLaterTask);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void flushNow() {
            if (AbstractChannel.this.inFlushNow || this.flushTaskInProgress != null) {
                return;
            }
            AbstractChannel.this.inFlushNow = true;
            ChannelHandlerContext ctx = this.directOutboundContext();
            Throwable cause = null;
            try {
                if (AbstractChannel.this.metadata().bufferType() == BufType.BYTE) {
                    ByteBuf out = ctx.outboundByteBuffer();
                    int oldSize = out.readableBytes();
                    try {
                        AbstractChannel.this.doFlushByteBuffer(out);
                    }
                    catch (Throwable t) {
                        cause = t;
                    }
                    finally {
                        int delta = oldSize - out.readableBytes();
                        out.discardSomeReadBytes();
                        AbstractChannel.this.flushFutureNotifier.increaseWriteCounter(delta);
                    }
                } else {
                    MessageBuf out = ctx.outboundMessageBuffer();
                    int oldSize = out.size();
                    try {
                        AbstractChannel.this.doFlushMessageBuffer(out);
                    }
                    catch (Throwable t) {
                        cause = t;
                    }
                    finally {
                        AbstractChannel.this.flushFutureNotifier.increaseWriteCounter(oldSize - out.size());
                    }
                }
                if (cause == null) {
                    AbstractChannel.this.flushFutureNotifier.notifyFlushFutures();
                } else {
                    AbstractChannel.this.flushFutureNotifier.notifyFlushFutures(cause);
                    if (cause instanceof IOException) {
                        this.close(this.voidFuture());
                    }
                }
            }
            finally {
                AbstractChannel.this.inFlushNow = false;
            }
        }

        protected final boolean ensureOpen(ChannelPromise promise) {
            if (AbstractChannel.this.isOpen()) {
                return true;
            }
            ClosedChannelException e = new ClosedChannelException();
            promise.setFailure(e);
            return false;
        }

        protected final void closeIfClosed() {
            if (AbstractChannel.this.isOpen()) {
                return;
            }
            this.close(this.voidFuture());
        }

        private final class FlushTask {
            final FileRegion region;
            final ChannelPromise promise;
            FlushTask next;

            FlushTask(FileRegion region, ChannelPromise promise) {
                this.region = region;
                this.promise = promise;
                promise.addListener(new ChannelFutureListener(){

                    @Override
                    public void operationComplete(ChannelFuture future) throws Exception {
                        block5: {
                            AbstractUnsafe.this.flushTaskInProgress = FlushTask.this.next;
                            if (FlushTask.this.next != null) {
                                try {
                                    FileRegion region = FlushTask.this.next.region;
                                    if (region == null) {
                                        AbstractUnsafe.this.flushNotifierAndFlush(FlushTask.this.next.promise);
                                        break block5;
                                    }
                                    AbstractChannel.this.doFlushFileRegion(region, FlushTask.this.next.promise);
                                }
                                catch (Throwable cause) {
                                    FlushTask.this.next.promise.setFailure(cause);
                                }
                            } else {
                                AbstractChannel.this.flushFutureNotifier.notifyFlushFutures();
                            }
                        }
                    }
                });
            }
        }
    }
}

