/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.socket.aio;

import io.netty.buffer.BufType;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelPromise;
import io.netty.channel.aio.AbstractAioChannel;
import io.netty.channel.aio.AioCompletionHandler;
import io.netty.channel.aio.AioEventLoopGroup;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.ServerSocketChannelConfig;
import io.netty.channel.socket.aio.AioServerSocketChannelConfig;
import io.netty.channel.socket.aio.AioSocketChannel;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;

public class AioServerSocketChannel
extends AbstractAioChannel
implements ServerSocketChannel {
    private static final ChannelMetadata METADATA = new ChannelMetadata(BufType.MESSAGE, false);
    private static final AcceptHandler ACCEPT_HANDLER = new AcceptHandler();
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AioServerSocketChannel.class);
    private final AioServerSocketChannelConfig config;
    private boolean acceptInProgress;
    private boolean closed;

    private static AsynchronousServerSocketChannel newSocket(AsynchronousChannelGroup group) {
        try {
            return AsynchronousServerSocketChannel.open(group);
        }
        catch (IOException e) {
            throw new ChannelException("Failed to open a socket.", e);
        }
    }

    public AioServerSocketChannel() {
        super(null, null, null);
        this.config = new AioServerSocketChannelConfig(this);
    }

    public AioServerSocketChannel(AsynchronousServerSocketChannel channel) {
        super(null, null, channel);
        this.config = new AioServerSocketChannelConfig(this, channel);
    }

    @Override
    public InetSocketAddress localAddress() {
        return (InetSocketAddress)super.localAddress();
    }

    @Override
    public InetSocketAddress remoteAddress() {
        return (InetSocketAddress)super.remoteAddress();
    }

    @Override
    protected AsynchronousServerSocketChannel javaChannel() {
        return (AsynchronousServerSocketChannel)super.javaChannel();
    }

    @Override
    public boolean isActive() {
        return this.ch != null && this.javaChannel().isOpen() && this.localAddress0() != null;
    }

    @Override
    public ChannelMetadata metadata() {
        return METADATA;
    }

    @Override
    protected SocketAddress localAddress0() {
        if (this.ch == null) {
            return null;
        }
        try {
            return this.javaChannel().getLocalAddress();
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    @Override
    protected SocketAddress remoteAddress0() {
        return null;
    }

    @Override
    protected void doBind(SocketAddress localAddress) throws Exception {
        AsynchronousServerSocketChannel ch = this.javaChannel();
        ch.bind(localAddress, this.config.getBacklog());
    }

    @Override
    protected void doBeginRead() {
        if (this.acceptInProgress) {
            return;
        }
        this.acceptInProgress = true;
        this.javaChannel().accept(this, ACCEPT_HANDLER);
    }

    @Override
    protected void doClose() throws Exception {
        if (!this.closed) {
            this.closed = true;
            this.javaChannel().close();
        }
    }

    @Override
    protected boolean isFlushPending() {
        return false;
    }

    @Override
    protected void doConnect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
        promise.setFailure(new UnsupportedOperationException());
    }

    @Override
    protected void doDisconnect() throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Runnable doRegister() throws Exception {
        Runnable task = super.doRegister();
        if (this.ch == null) {
            AsynchronousServerSocketChannel channel = AioServerSocketChannel.newSocket(((AioEventLoopGroup)this.eventLoop().parent()).channelGroup());
            this.ch = channel;
            this.config.assign(channel);
        }
        return task;
    }

    @Override
    public ServerSocketChannelConfig config() {
        return this.config;
    }

    private static final class AcceptHandler
    extends AioCompletionHandler<AsynchronousSocketChannel, AioServerSocketChannel> {
        private AcceptHandler() {
        }

        @Override
        protected void completed0(AsynchronousSocketChannel ch, AioServerSocketChannel channel) {
            channel.acceptInProgress = false;
            channel.pipeline().inboundMessageBuffer().add((Object)new AioSocketChannel(channel, null, ch));
            channel.pipeline().fireInboundBufferUpdated();
            channel.pipeline().fireChannelReadSuspended();
        }

        @Override
        protected void failed0(Throwable t, AioServerSocketChannel channel) {
            channel.acceptInProgress = false;
            boolean asyncClosed = false;
            if (t instanceof AsynchronousCloseException) {
                asyncClosed = true;
                channel.closed = true;
            }
            if (channel.isOpen() && !asyncClosed) {
                logger.warn("Failed to create a new channel from an accepted socket.", t);
            }
        }
    }
}

