/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.channel.AbstractChannel;
import io.netty.channel.ChannelPromise;
import io.netty.channel.MessageList;
import io.netty.channel.VoidChannelPromise;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

final class ChannelOutboundBuffer {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ChannelOutboundBuffer.class);
    private static final int MIN_INITIAL_CAPACITY = 8;
    ChannelPromise currentPromise;
    MessageList<Object> currentMessages;
    int currentMessageIndex;
    private int currentMessageListSize;
    private ChannelPromise[] promises;
    private MessageList<Object>[] messages;
    private int head;
    private int tail;
    private final AbstractChannel channel;
    private int pendingOutboundBytes;
    private static final AtomicIntegerFieldUpdater<ChannelOutboundBuffer> WRITABLE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(ChannelOutboundBuffer.class, "writable");
    private volatile int writable = 1;

    ChannelOutboundBuffer(AbstractChannel channel) {
        this(channel, 16);
    }

    ChannelOutboundBuffer(AbstractChannel channel, int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initialCapacity: " + initialCapacity + " (expected: >= 0)");
        }
        if (initialCapacity >= 8) {
            initialCapacity |= initialCapacity >>> 1;
            initialCapacity |= initialCapacity >>> 2;
            initialCapacity |= initialCapacity >>> 4;
            initialCapacity |= initialCapacity >>> 8;
            initialCapacity |= initialCapacity >>> 16;
            if (++initialCapacity < 0) {
                initialCapacity >>>= 1;
            }
        } else {
            initialCapacity = 8;
        }
        this.promises = new ChannelPromise[initialCapacity];
        this.messages = new MessageList[initialCapacity];
        this.channel = channel;
    }

    void add(MessageList<?> msgs, ChannelPromise promise) {
        int tail = this.tail;
        this.promises[tail] = promise;
        this.messages[tail] = msgs;
        this.tail = tail + 1 & this.promises.length - 1;
        if (this.tail == this.head) {
            this.doubleCapacity();
        }
        this.incrementPendingOutboundBytes(this.messageListSize(msgs));
    }

    private void incrementPendingOutboundBytes(int size) {
        if (size == 0) {
            return;
        }
        int newWriteBufferSize = this.pendingOutboundBytes += size;
        int highWaterMark = this.channel.config().getWriteBufferHighWaterMark();
        if (newWriteBufferSize > highWaterMark && WRITABLE_UPDATER.compareAndSet(this, 1, 0)) {
            this.channel.pipeline().fireChannelWritabilityChanged();
        }
    }

    private void decrementPendingOutboundBytes(int size) {
        if (size == 0) {
            return;
        }
        int newWriteBufferSize = this.pendingOutboundBytes -= size;
        int lowWaterMark = this.channel.config().getWriteBufferLowWaterMark();
        if ((newWriteBufferSize == 0 || newWriteBufferSize < lowWaterMark) && WRITABLE_UPDATER.compareAndSet(this, 0, 1)) {
            this.channel.pipeline().fireChannelWritabilityChanged();
        }
    }

    private void doubleCapacity() {
        assert (this.head == this.tail);
        int p = this.head;
        int n = this.promises.length;
        int r = n - p;
        int newCapacity = n << 1;
        if (newCapacity < 0) {
            throw new IllegalStateException("Sorry, deque too big");
        }
        ChannelPromise[] a1 = new ChannelPromise[newCapacity];
        System.arraycopy(this.promises, p, a1, 0, r);
        System.arraycopy(this.promises, 0, a1, r, p);
        this.promises = a1;
        MessageList[] a2 = new MessageList[newCapacity];
        System.arraycopy(this.messages, p, a2, 0, r);
        System.arraycopy(this.messages, 0, a2, r, p);
        this.messages = a2;
        this.head = 0;
        this.tail = n;
    }

    boolean next() {
        this.decrementPendingOutboundBytes(this.currentMessageListSize);
        int h = this.head;
        ChannelPromise e = this.promises[h];
        if (e == null) {
            this.currentMessageListSize = 0;
            this.currentPromise = null;
            this.currentMessages = null;
            return false;
        }
        this.currentPromise = e;
        this.currentMessages = this.messages[h];
        this.currentMessageIndex = 0;
        this.currentMessageListSize = this.messageListSize(this.currentMessages);
        this.promises[h] = null;
        this.messages[h] = null;
        this.head = h + 1 & this.promises.length - 1;
        return true;
    }

    private int messageListSize(MessageList<?> messages) {
        int size = 0;
        for (int i = 0; i < messages.size(); ++i) {
            size += this.channel.calculateMessageSize(messages.get(i));
        }
        return size;
    }

    boolean getWritable() {
        return WRITABLE_UPDATER.get(this) == 1;
    }

    int size() {
        return this.tail - this.head & this.promises.length - 1;
    }

    boolean isEmpty() {
        return this.head == this.tail;
    }

    void clear() {
        int head = this.head;
        int tail = this.tail;
        if (head != tail) {
            this.tail = 0;
            this.head = 0;
            int mask = this.promises.length - 1;
            int i = head;
            do {
                this.promises[i] = null;
                this.messages[i] = null;
            } while ((i = i + 1 & mask) != tail);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fail(Throwable cause) {
        if (this.currentPromise == null && !this.next()) {
            return;
        }
        do {
            if (!(this.currentPromise instanceof VoidChannelPromise) && !this.currentPromise.tryFailure(cause)) {
                logger.warn("Promise done already:", cause);
            }
            try {
                for (int i = this.currentMessageIndex; i < this.currentMessages.size(); ++i) {
                    Object msg = this.currentMessages.get(i);
                    ReferenceCountUtil.release((Object)msg);
                }
            }
            finally {
                this.currentMessages.recycle();
            }
        } while (this.next());
    }
}

