/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.nio;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.FileRegion;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.nio.AbstractNioChannel;
import io.netty.channel.socket.ChannelInputShutdownEvent;
import io.netty.util.internal.StringUtil;
import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;

public abstract class AbstractNioByteChannel
extends AbstractNioChannel {
    protected AbstractNioByteChannel(Channel parent, SelectableChannel ch) {
        super(parent, ch, 1);
    }

    @Override
    protected AbstractNioChannel.AbstractNioUnsafe newUnsafe() {
        return new NioByteUnsafe();
    }

    @Override
    protected int doWrite(Object[] msgs, int msgsLength, int startIndex) throws Exception {
        int writeIndex = startIndex;
        while (writeIndex < msgsLength) {
            int i;
            boolean done;
            Object msg = msgs[writeIndex];
            if (msg instanceof ByteBuf) {
                int localFlushedAmount;
                ByteBuf buf = (ByteBuf)msg;
                if (!buf.isReadable()) {
                    buf.release();
                    ++writeIndex;
                    continue;
                }
                done = false;
                for (i = this.config().getWriteSpinCount() - 1; i >= 0 && (localFlushedAmount = this.doWriteBytes(buf, i == 0)) != 0; --i) {
                    if (buf.isReadable()) continue;
                    done = true;
                    break;
                }
                if (!done) break;
                buf.release();
                ++writeIndex;
                continue;
            }
            if (msg instanceof FileRegion) {
                long localFlushedAmount;
                FileRegion region = (FileRegion)msg;
                done = false;
                for (i = this.config().getWriteSpinCount() - 1; i >= 0 && (localFlushedAmount = this.doWriteFileRegion(region, i == 0)) != 0L; --i) {
                    if (region.transfered() < region.count()) continue;
                    done = true;
                    break;
                }
                if (!done) break;
                region.release();
                ++writeIndex;
                continue;
            }
            throw new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName((Object)msg));
        }
        return writeIndex - startIndex;
    }

    protected abstract long doWriteFileRegion(FileRegion var1, boolean var2) throws Exception;

    protected abstract int doReadBytes(ByteBuf var1) throws Exception;

    protected abstract int doWriteBytes(ByteBuf var1, boolean var2) throws Exception;

    protected final void updateOpWrite(long expectedWrittenBytes, long writtenBytes, boolean lastSpin) {
        SelectionKey key;
        int interestOps;
        if (writtenBytes >= expectedWrittenBytes) {
            SelectionKey key2 = this.selectionKey();
            int interestOps2 = key2.interestOps();
            if ((interestOps2 & 4) != 0) {
                key2.interestOps(interestOps2 & 0xFFFFFFFB);
            }
        } else if ((writtenBytes == 0L || lastSpin) && ((interestOps = (key = this.selectionKey()).interestOps()) & 4) == 0) {
            key.interestOps(interestOps | 4);
        }
    }

    private final class NioByteUnsafe
    extends AbstractNioChannel.AbstractNioUnsafe {
        private RecvByteBufAllocator.Handle allocHandle;

        private NioByteUnsafe() {
            super(AbstractNioByteChannel.this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void read() {
            int interestOps;
            assert (AbstractNioByteChannel.this.eventLoop().inEventLoop());
            SelectionKey key = AbstractNioByteChannel.this.selectionKey();
            ChannelConfig config = AbstractNioByteChannel.this.config();
            if (!config.isAutoRead() && ((interestOps = key.interestOps()) & AbstractNioByteChannel.this.readInterestOp) != 0) {
                key.interestOps(interestOps & ~AbstractNioByteChannel.this.readInterestOp);
            }
            ChannelPipeline pipeline = AbstractNioByteChannel.this.pipeline();
            RecvByteBufAllocator.Handle allocHandle = this.allocHandle;
            if (allocHandle == null) {
                this.allocHandle = allocHandle = config.getRecvByteBufAllocator().newHandle();
            }
            ByteBufAllocator allocator = config.getAllocator();
            int maxMessagesPerRead = config.getMaxMessagesPerRead();
            boolean closed = false;
            Throwable exception = null;
            ByteBuf byteBuf = null;
            int messages = 0;
            try {
                do {
                    int localReadAmount;
                    if ((localReadAmount = AbstractNioByteChannel.this.doReadBytes(byteBuf = allocHandle.allocate(allocator))) == 0) {
                        byteBuf.release();
                        byteBuf = null;
                        break;
                    }
                    if (localReadAmount < 0) {
                        closed = true;
                        byteBuf.release();
                        byteBuf = null;
                        break;
                    }
                    pipeline.fireChannelRead(byteBuf);
                    allocHandle.record(localReadAmount);
                    byteBuf = null;
                } while (++messages != maxMessagesPerRead);
            }
            catch (Throwable t) {
                exception = t;
            }
            finally {
                if (byteBuf != null) {
                    if (byteBuf.isReadable()) {
                        pipeline.fireChannelRead(byteBuf);
                    } else {
                        byteBuf.release();
                    }
                }
                pipeline.fireChannelReadComplete();
                if (exception != null) {
                    if (exception instanceof IOException) {
                        closed = true;
                    }
                    AbstractNioByteChannel.this.pipeline().fireExceptionCaught(exception);
                }
                if (closed) {
                    AbstractNioByteChannel.this.setInputShutdown();
                    if (AbstractNioByteChannel.this.isOpen()) {
                        if (Boolean.TRUE.equals(AbstractNioByteChannel.this.config().getOption(ChannelOption.ALLOW_HALF_CLOSURE))) {
                            key.interestOps(key.interestOps() & ~AbstractNioByteChannel.this.readInterestOp);
                            pipeline.fireUserEventTriggered(ChannelInputShutdownEvent.INSTANCE);
                        } else {
                            this.close(this.voidPromise());
                        }
                    }
                }
            }
        }
    }
}

