/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelId;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelConfig;
import io.netty.channel.DefaultChannelId;
import io.netty.channel.DefaultChannelPromise;
import io.netty.channel.DefaultEventLoop;
import io.netty.channel.EventLoop;
import io.netty.util.NetUtil;
import io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.EnabledForJreRange;
import org.junit.jupiter.api.condition.JRE;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class AbstractChannelTest {
    @Test
    public void ensureInitialRegistrationFiresActive() throws Throwable {
        EventLoop eventLoop = (EventLoop)Mockito.mock(EventLoop.class);
        Mockito.when((Object)eventLoop.inEventLoop()).thenReturn((Object)true);
        TestChannel channel = new TestChannel();
        ChannelInboundHandler handler = (ChannelInboundHandler)Mockito.mock(ChannelInboundHandler.class);
        channel.pipeline().addLast(new ChannelHandler[]{handler});
        AbstractChannelTest.registerChannel(eventLoop, (Channel)channel);
        ((ChannelInboundHandler)Mockito.verify((Object)handler)).handlerAdded((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class));
        ((ChannelInboundHandler)Mockito.verify((Object)handler)).channelRegistered((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class));
        ((ChannelInboundHandler)Mockito.verify((Object)handler)).channelActive((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class));
    }

    @Test
    public void ensureSubsequentRegistrationDoesNotFireActive() throws Throwable {
        EventLoop eventLoop = (EventLoop)Mockito.mock(EventLoop.class);
        Mockito.when((Object)eventLoop.inEventLoop()).thenReturn((Object)true);
        ((EventLoop)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocationOnMock) {
                ((Runnable)invocationOnMock.getArgument(0)).run();
                return null;
            }
        }).when((Object)eventLoop)).execute((Runnable)Mockito.any(Runnable.class));
        TestChannel channel = new TestChannel();
        ChannelInboundHandler handler = (ChannelInboundHandler)Mockito.mock(ChannelInboundHandler.class);
        channel.pipeline().addLast(new ChannelHandler[]{handler});
        AbstractChannelTest.registerChannel(eventLoop, (Channel)channel);
        channel.unsafe().deregister((ChannelPromise)new DefaultChannelPromise((Channel)channel));
        AbstractChannelTest.registerChannel(eventLoop, (Channel)channel);
        ((ChannelInboundHandler)Mockito.verify((Object)handler)).handlerAdded((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class));
        ((ChannelInboundHandler)Mockito.verify((Object)handler, (VerificationMode)Mockito.times((int)2))).channelRegistered((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class));
        ((ChannelInboundHandler)Mockito.verify((Object)handler)).channelActive((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class));
        ((ChannelInboundHandler)Mockito.verify((Object)handler)).channelUnregistered((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class));
    }

    @Test
    public void ensureDefaultChannelId() {
        TestChannel channel = new TestChannel();
        ChannelId channelId = channel.id();
        Assertions.assertTrue((boolean)(channelId instanceof DefaultChannelId));
    }

    @Test
    @EnabledForJreRange(min=JRE.JAVA_9)
    void processIdWithProcessHandleJava9() {
        ClassLoader loader = PlatformDependent.getClassLoader(DefaultChannelId.class);
        int processHandlePid = DefaultChannelId.processHandlePid((ClassLoader)loader);
        Assertions.assertTrue((processHandlePid != -1 ? 1 : 0) != 0);
        Assertions.assertEquals((int)DefaultChannelId.jmxPid((ClassLoader)loader), (int)processHandlePid);
        Assertions.assertEquals((int)DefaultChannelId.defaultProcessId(), (int)processHandlePid);
    }

    @Test
    @EnabledForJreRange(max=JRE.JAVA_8)
    void processIdWithJmxPrejava9() {
        ClassLoader loader = PlatformDependent.getClassLoader(DefaultChannelId.class);
        int processHandlePid = DefaultChannelId.processHandlePid((ClassLoader)loader);
        Assertions.assertEquals((int)-1, (int)processHandlePid);
        Assertions.assertEquals((int)DefaultChannelId.defaultProcessId(), (int)DefaultChannelId.jmxPid((ClassLoader)loader));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClosedChannelExceptionCarryIOException() throws Exception {
        final IOException ioException = new IOException();
        TestChannel channel = new TestChannel(){
            private boolean open = true;
            private boolean active;

            @Override
            protected AbstractChannel.AbstractUnsafe newUnsafe() {
                return new AbstractChannel.AbstractUnsafe(){

                    public void connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
                        active = true;
                        promise.setSuccess();
                    }
                };
            }

            @Override
            protected void doClose() {
                this.active = false;
                this.open = false;
            }

            @Override
            protected void doWrite(ChannelOutboundBuffer in) throws Exception {
                throw ioException;
            }

            @Override
            public boolean isOpen() {
                return this.open;
            }

            @Override
            public boolean isActive() {
                return this.active;
            }
        };
        DefaultEventLoop loop = new DefaultEventLoop();
        try {
            AbstractChannelTest.registerChannel((EventLoop)loop, (Channel)channel);
            channel.connect(new InetSocketAddress(NetUtil.LOCALHOST, 8888)).sync();
            Assertions.assertSame((Object)ioException, (Object)channel.writeAndFlush("").await().cause());
            AbstractChannelTest.assertClosedChannelException(channel.writeAndFlush(""), ioException);
            AbstractChannelTest.assertClosedChannelException(channel.write(""), ioException);
            AbstractChannelTest.assertClosedChannelException(channel.bind(new InetSocketAddress(NetUtil.LOCALHOST, 8888)), ioException);
        }
        finally {
            channel.close();
            loop.shutdownGracefully();
        }
    }

    private static void assertClosedChannelException(ChannelFuture future, IOException expected) throws InterruptedException {
        Throwable cause = future.await().cause();
        Assertions.assertTrue((boolean)(cause instanceof ClosedChannelException));
        Assertions.assertSame((Object)expected, (Object)cause.getCause());
    }

    private static void registerChannel(EventLoop eventLoop, Channel channel) throws Exception {
        DefaultChannelPromise future = new DefaultChannelPromise(channel);
        channel.unsafe().register(eventLoop, (ChannelPromise)future);
        future.sync();
    }

    private static class TestChannel
    extends AbstractChannel {
        private static final ChannelMetadata TEST_METADATA = new ChannelMetadata(false);
        private final ChannelConfig config = new DefaultChannelConfig((Channel)this);

        TestChannel() {
            super(null);
        }

        public ChannelConfig config() {
            return this.config;
        }

        public boolean isOpen() {
            return true;
        }

        public boolean isActive() {
            return true;
        }

        public ChannelMetadata metadata() {
            return TEST_METADATA;
        }

        protected AbstractChannel.AbstractUnsafe newUnsafe() {
            return new AbstractChannel.AbstractUnsafe(){

                public void connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
                    promise.setFailure((Throwable)new UnsupportedOperationException());
                }
            };
        }

        protected boolean isCompatible(EventLoop loop) {
            return true;
        }

        protected SocketAddress localAddress0() {
            return null;
        }

        protected SocketAddress remoteAddress0() {
            return null;
        }

        protected void doBind(SocketAddress localAddress) {
        }

        protected void doDisconnect() {
        }

        protected void doClose() {
        }

        protected void doBeginRead() {
        }

        protected void doWrite(ChannelOutboundBuffer in) throws Exception {
        }
    }
}

