/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.CombinedChannelDuplexHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.function.Executable;

public class CombinedChannelDuplexHandlerTest {
    private static final Object MSG = new Object();
    private static final SocketAddress LOCAL_ADDRESS = new InetSocketAddress(0);
    private static final SocketAddress REMOTE_ADDRESS = new InetSocketAddress(0);
    private static final Throwable CAUSE = new Throwable();
    private static final Object USER_EVENT = new Object();

    @Test
    public void testInboundRemoveBeforeAdded() {
        final CombinedChannelDuplexHandler handler = new CombinedChannelDuplexHandler((ChannelInboundHandler)new ChannelInboundHandlerAdapter(), (ChannelOutboundHandler)new ChannelOutboundHandlerAdapter());
        Assertions.assertThrows(IllegalStateException.class, (Executable)new Executable(){

            public void execute() {
                handler.removeInboundHandler();
            }
        });
    }

    @Test
    public void testOutboundRemoveBeforeAdded() {
        final CombinedChannelDuplexHandler handler = new CombinedChannelDuplexHandler((ChannelInboundHandler)new ChannelInboundHandlerAdapter(), (ChannelOutboundHandler)new ChannelOutboundHandlerAdapter());
        Assertions.assertThrows(IllegalStateException.class, (Executable)new Executable(){

            public void execute() {
                handler.removeOutboundHandler();
            }
        });
    }

    @Test
    public void testInboundHandlerImplementsOutboundHandler() {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                new CombinedChannelDuplexHandler((ChannelInboundHandler)new ChannelDuplexHandler(), (ChannelOutboundHandler)new ChannelOutboundHandlerAdapter());
            }
        });
    }

    @Test
    public void testOutboundHandlerImplementsInboundHandler() {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                new CombinedChannelDuplexHandler((ChannelInboundHandler)new ChannelInboundHandlerAdapter(), (ChannelOutboundHandler)new ChannelDuplexHandler());
            }
        });
    }

    @Test
    public void testInitNotCalledBeforeAdded() {
        CombinedChannelDuplexHandler<ChannelInboundHandler, ChannelOutboundHandler> handler = new CombinedChannelDuplexHandler<ChannelInboundHandler, ChannelOutboundHandler>(){};
        Assertions.assertThrows(IllegalStateException.class, (Executable)new Executable((CombinedChannelDuplexHandler)handler){
            final /* synthetic */ CombinedChannelDuplexHandler val$handler;
            {
                this.val$handler = combinedChannelDuplexHandler;
            }

            public void execute() throws Throwable {
                this.val$handler.handlerAdded(null);
            }
        });
    }

    @Test
    public void testExceptionCaughtBothCombinedHandlers() {
        final Exception exception = new Exception();
        final ArrayDeque queue = new ArrayDeque();
        ChannelInboundHandlerAdapter inboundHandler = new ChannelInboundHandlerAdapter(){

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                Assertions.assertSame((Object)exception, (Object)cause);
                queue.add(this);
                ctx.fireExceptionCaught(cause);
            }
        };
        ChannelOutboundHandlerAdapter outboundHandler = new ChannelOutboundHandlerAdapter(){

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                Assertions.assertSame((Object)exception, (Object)cause);
                queue.add(this);
                ctx.fireExceptionCaught(cause);
            }
        };
        ChannelInboundHandlerAdapter lastHandler = new ChannelInboundHandlerAdapter(){

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                Assertions.assertSame((Object)exception, (Object)cause);
                queue.add(this);
            }
        };
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new CombinedChannelDuplexHandler((ChannelInboundHandler)inboundHandler, (ChannelOutboundHandler)outboundHandler), lastHandler});
        channel.pipeline().fireExceptionCaught((Throwable)exception);
        Assertions.assertFalse((boolean)channel.finish());
        Assertions.assertSame((Object)inboundHandler, queue.poll());
        Assertions.assertSame((Object)outboundHandler, queue.poll());
        Assertions.assertSame((Object)lastHandler, queue.poll());
        Assertions.assertTrue((boolean)queue.isEmpty());
    }

    @Test
    public void testInboundEvents() {
        InboundEventHandler inboundHandler = new InboundEventHandler();
        CombinedChannelDuplexHandler handler = new CombinedChannelDuplexHandler((ChannelInboundHandler)inboundHandler, (ChannelOutboundHandler)new ChannelOutboundHandlerAdapter());
        EmbeddedChannel channel = new EmbeddedChannel();
        channel.pipeline().addLast(new ChannelHandler[]{handler});
        Assertions.assertEquals((Object)((Object)Event.HANDLER_ADDED), (Object)((Object)inboundHandler.pollEvent()));
        CombinedChannelDuplexHandlerTest.doInboundOperations((Channel)channel);
        CombinedChannelDuplexHandlerTest.assertInboundOperations(inboundHandler);
        handler.removeInboundHandler();
        Assertions.assertEquals((Object)((Object)Event.HANDLER_REMOVED), (Object)((Object)inboundHandler.pollEvent()));
        CombinedChannelDuplexHandlerTest.doInboundOperations((Channel)channel);
        Assertions.assertNull((Object)((Object)inboundHandler.pollEvent()));
        try {
            channel.checkException();
            Assertions.fail();
        }
        catch (Throwable cause) {
            Assertions.assertSame((Object)CAUSE, (Object)cause);
        }
        Assertions.assertTrue((boolean)channel.finish());
        Assertions.assertNull((Object)((Object)inboundHandler.pollEvent()));
    }

    @Test
    public void testOutboundEvents() {
        ChannelInboundHandlerAdapter inboundHandler = new ChannelInboundHandlerAdapter();
        OutboundEventHandler outboundHandler = new OutboundEventHandler();
        CombinedChannelDuplexHandler handler = new CombinedChannelDuplexHandler((ChannelInboundHandler)inboundHandler, (ChannelOutboundHandler)outboundHandler);
        EmbeddedChannel channel = new EmbeddedChannel();
        channel.pipeline().addLast(new ChannelHandler[]{new OutboundEventHandler()});
        channel.pipeline().addLast(new ChannelHandler[]{handler});
        Assertions.assertEquals((Object)((Object)Event.HANDLER_ADDED), (Object)((Object)outboundHandler.pollEvent()));
        CombinedChannelDuplexHandlerTest.doOutboundOperations((Channel)channel);
        CombinedChannelDuplexHandlerTest.assertOutboundOperations(outboundHandler);
        handler.removeOutboundHandler();
        Assertions.assertEquals((Object)((Object)Event.HANDLER_REMOVED), (Object)((Object)outboundHandler.pollEvent()));
        CombinedChannelDuplexHandlerTest.doOutboundOperations((Channel)channel);
        Assertions.assertNull((Object)((Object)outboundHandler.pollEvent()));
        Assertions.assertFalse((boolean)channel.finish());
        Assertions.assertNull((Object)((Object)outboundHandler.pollEvent()));
    }

    private static void doOutboundOperations(Channel channel) {
        channel.pipeline().bind(LOCAL_ADDRESS).syncUninterruptibly();
        channel.pipeline().connect(REMOTE_ADDRESS, LOCAL_ADDRESS).syncUninterruptibly();
        channel.pipeline().write(MSG).syncUninterruptibly();
        channel.pipeline().flush();
        channel.pipeline().read();
        channel.pipeline().disconnect().syncUninterruptibly();
        channel.pipeline().close().syncUninterruptibly();
        channel.pipeline().deregister().syncUninterruptibly();
    }

    private static void assertOutboundOperations(OutboundEventHandler outboundHandler) {
        Assertions.assertEquals((Object)((Object)Event.BIND), (Object)((Object)outboundHandler.pollEvent()));
        Assertions.assertEquals((Object)((Object)Event.CONNECT), (Object)((Object)outboundHandler.pollEvent()));
        Assertions.assertEquals((Object)((Object)Event.WRITE), (Object)((Object)outboundHandler.pollEvent()));
        Assertions.assertEquals((Object)((Object)Event.FLUSH), (Object)((Object)outboundHandler.pollEvent()));
        Assertions.assertEquals((Object)((Object)Event.READ), (Object)((Object)outboundHandler.pollEvent()));
        Assertions.assertEquals((Object)((Object)Event.CLOSE), (Object)((Object)outboundHandler.pollEvent()));
        Assertions.assertEquals((Object)((Object)Event.CLOSE), (Object)((Object)outboundHandler.pollEvent()));
        Assertions.assertEquals((Object)((Object)Event.DEREGISTER), (Object)((Object)outboundHandler.pollEvent()));
    }

    private static void doInboundOperations(Channel channel) {
        channel.pipeline().fireChannelRegistered();
        channel.pipeline().fireChannelActive();
        channel.pipeline().fireChannelRead(MSG);
        channel.pipeline().fireChannelReadComplete();
        channel.pipeline().fireExceptionCaught(CAUSE);
        channel.pipeline().fireUserEventTriggered(USER_EVENT);
        channel.pipeline().fireChannelWritabilityChanged();
        channel.pipeline().fireChannelInactive();
        channel.pipeline().fireChannelUnregistered();
    }

    private static void assertInboundOperations(InboundEventHandler handler) {
        Assertions.assertEquals((Object)((Object)Event.REGISTERED), (Object)((Object)handler.pollEvent()));
        Assertions.assertEquals((Object)((Object)Event.ACTIVE), (Object)((Object)handler.pollEvent()));
        Assertions.assertEquals((Object)((Object)Event.CHANNEL_READ), (Object)((Object)handler.pollEvent()));
        Assertions.assertEquals((Object)((Object)Event.CHANNEL_READ_COMPLETE), (Object)((Object)handler.pollEvent()));
        Assertions.assertEquals((Object)((Object)Event.EXCEPTION_CAUGHT), (Object)((Object)handler.pollEvent()));
        Assertions.assertEquals((Object)((Object)Event.USER_EVENT_TRIGGERED), (Object)((Object)handler.pollEvent()));
        Assertions.assertEquals((Object)((Object)Event.CHANNEL_WRITABILITY_CHANGED), (Object)((Object)handler.pollEvent()));
        Assertions.assertEquals((Object)((Object)Event.INACTIVE), (Object)((Object)handler.pollEvent()));
        Assertions.assertEquals((Object)((Object)Event.UNREGISTERED), (Object)((Object)handler.pollEvent()));
    }

    @Test
    @Timeout(value=3000L, unit=TimeUnit.MILLISECONDS)
    public void testPromisesPassed() {
        OutboundEventHandler outboundHandler = new OutboundEventHandler();
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{outboundHandler, new CombinedChannelDuplexHandler((ChannelInboundHandler)new ChannelInboundHandlerAdapter(), (ChannelOutboundHandler)new ChannelOutboundHandlerAdapter())});
        ChannelPipeline pipeline = ch.pipeline();
        ChannelPromise promise = ch.newPromise();
        pipeline.bind(LOCAL_ADDRESS, promise);
        promise.syncUninterruptibly();
        promise = ch.newPromise();
        pipeline.connect(REMOTE_ADDRESS, LOCAL_ADDRESS, promise);
        promise.syncUninterruptibly();
        promise = ch.newPromise();
        pipeline.close(promise);
        promise.syncUninterruptibly();
        promise = ch.newPromise();
        pipeline.disconnect(promise);
        promise.syncUninterruptibly();
        promise = ch.newPromise();
        pipeline.write(MSG, promise);
        promise.syncUninterruptibly();
        promise = ch.newPromise();
        pipeline.deregister(promise);
        promise.syncUninterruptibly();
        ch.finish();
    }

    @Test
    public void testNotSharable() {
        Assertions.assertThrows(IllegalStateException.class, (Executable)new Executable(){

            public void execute() {
                new CombinedChannelDuplexHandler<ChannelInboundHandler, ChannelOutboundHandler>(){

                    public boolean isSharable() {
                        return true;
                    }
                };
            }
        });
    }

    private static final class OutboundEventHandler
    extends ChannelOutboundHandlerAdapter {
        private final Queue<Object> queue = new ArrayDeque<Object>();

        private OutboundEventHandler() {
        }

        public void handlerAdded(ChannelHandlerContext ctx) {
            this.queue.add((Object)Event.HANDLER_ADDED);
        }

        public void handlerRemoved(ChannelHandlerContext ctx) {
            this.queue.add((Object)Event.HANDLER_REMOVED);
        }

        public void bind(ChannelHandlerContext ctx, SocketAddress localAddress, ChannelPromise promise) {
            try {
                Assertions.assertSame((Object)LOCAL_ADDRESS, (Object)localAddress);
                this.queue.add((Object)Event.BIND);
                promise.setSuccess();
            }
            catch (AssertionError e) {
                promise.setFailure((Throwable)((Object)e));
            }
        }

        public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
            try {
                Assertions.assertSame((Object)REMOTE_ADDRESS, (Object)remoteAddress);
                Assertions.assertSame((Object)LOCAL_ADDRESS, (Object)localAddress);
                this.queue.add((Object)Event.CONNECT);
                promise.setSuccess();
            }
            catch (AssertionError e) {
                promise.setFailure((Throwable)((Object)e));
            }
        }

        public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) {
            this.queue.add((Object)Event.DISCONNECT);
            promise.setSuccess();
        }

        public void close(ChannelHandlerContext ctx, ChannelPromise promise) {
            this.queue.add((Object)Event.CLOSE);
            promise.setSuccess();
        }

        public void deregister(ChannelHandlerContext ctx, ChannelPromise promise) {
            this.queue.add((Object)Event.DEREGISTER);
            promise.setSuccess();
        }

        public void read(ChannelHandlerContext ctx) {
            this.queue.add((Object)Event.READ);
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
            try {
                Assertions.assertSame((Object)MSG, (Object)msg);
                this.queue.add((Object)Event.WRITE);
                promise.setSuccess();
            }
            catch (AssertionError e) {
                promise.setFailure((Throwable)((Object)e));
            }
        }

        public void flush(ChannelHandlerContext ctx) {
            this.queue.add((Object)Event.FLUSH);
        }

        Event pollEvent() {
            Object o = this.queue.poll();
            if (o instanceof AssertionError) {
                throw (AssertionError)o;
            }
            return (Event)((Object)o);
        }
    }

    private static final class InboundEventHandler
    extends ChannelInboundHandlerAdapter {
        private final Queue<Object> queue = new ArrayDeque<Object>();

        private InboundEventHandler() {
        }

        public void handlerAdded(ChannelHandlerContext ctx) {
            this.queue.add((Object)Event.HANDLER_ADDED);
        }

        public void handlerRemoved(ChannelHandlerContext ctx) {
            this.queue.add((Object)Event.HANDLER_REMOVED);
        }

        public void channelRegistered(ChannelHandlerContext ctx) {
            this.queue.add((Object)Event.REGISTERED);
        }

        public void channelUnregistered(ChannelHandlerContext ctx) {
            this.queue.add((Object)Event.UNREGISTERED);
        }

        public void channelActive(ChannelHandlerContext ctx) {
            this.queue.add((Object)Event.ACTIVE);
        }

        public void channelInactive(ChannelHandlerContext ctx) {
            this.queue.add((Object)Event.INACTIVE);
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            this.queue.add((Object)Event.CHANNEL_READ);
        }

        public void channelReadComplete(ChannelHandlerContext ctx) {
            this.queue.add((Object)Event.CHANNEL_READ_COMPLETE);
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
            this.queue.add((Object)Event.USER_EVENT_TRIGGERED);
        }

        public void channelWritabilityChanged(ChannelHandlerContext ctx) {
            this.queue.add((Object)Event.CHANNEL_WRITABILITY_CHANGED);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            this.queue.add((Object)Event.EXCEPTION_CAUGHT);
        }

        Event pollEvent() {
            Object o = this.queue.poll();
            if (o instanceof AssertionError) {
                throw (AssertionError)o;
            }
            return (Event)((Object)o);
        }
    }

    private static enum Event {
        REGISTERED,
        UNREGISTERED,
        ACTIVE,
        INACTIVE,
        CHANNEL_READ,
        CHANNEL_READ_COMPLETE,
        EXCEPTION_CAUGHT,
        USER_EVENT_TRIGGERED,
        CHANNEL_WRITABILITY_CHANGED,
        HANDLER_ADDED,
        HANDLER_REMOVED,
        BIND,
        CONNECT,
        WRITE,
        FLUSH,
        READ,
        REGISTER,
        DEREGISTER,
        CLOSE,
        DISCONNECT;

    }
}

