/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.oio;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.oio.OioEventLoopGroup;
import io.netty.channel.socket.oio.OioServerSocketChannel;
import io.netty.channel.socket.oio.OioSocketChannel;
import io.netty.util.NetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.CountDownLatch;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class OioEventLoopTest {
    @Test
    public void testTooManyServerChannels() throws Exception {
        OioEventLoopGroup g = new OioEventLoopGroup(1);
        ServerBootstrap b = new ServerBootstrap();
        b.channel(OioServerSocketChannel.class);
        b.group((EventLoopGroup)g);
        b.childHandler((ChannelHandler)new ChannelInboundHandlerAdapter());
        ChannelFuture f1 = b.bind(0);
        f1.sync();
        ChannelFuture f2 = b.bind(0);
        f2.await();
        org.junit.jupiter.api.Assertions.assertInstanceOf(ChannelException.class, (Object)f2.cause());
        Assertions.assertThat((String)f2.cause().getMessage().toLowerCase()).contains(new CharSequence[]{"too many channels"});
        final CountDownLatch notified = new CountDownLatch(1);
        f2.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                notified.countDown();
            }
        });
        notified.await();
        g.shutdownGracefully();
    }

    @Test
    public void testTooManyClientChannels() throws Exception {
        OioEventLoopGroup g = new OioEventLoopGroup(1);
        ServerBootstrap sb = new ServerBootstrap();
        sb.channel(OioServerSocketChannel.class);
        sb.group((EventLoopGroup)g);
        sb.childHandler((ChannelHandler)new ChannelInboundHandlerAdapter());
        ChannelFuture f1 = sb.bind(0);
        f1.sync();
        Bootstrap cb = new Bootstrap();
        cb.channel(OioSocketChannel.class);
        cb.group((EventLoopGroup)g);
        cb.handler((ChannelHandler)new ChannelInboundHandlerAdapter());
        ChannelFuture f2 = cb.connect(NetUtil.LOCALHOST, ((InetSocketAddress)f1.channel().localAddress()).getPort());
        f2.await();
        org.junit.jupiter.api.Assertions.assertInstanceOf(ChannelException.class, (Object)f2.cause());
        Assertions.assertThat((String)f2.cause().getMessage().toLowerCase()).contains(new CharSequence[]{"too many channels"});
        final CountDownLatch notified = new CountDownLatch(1);
        f2.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                notified.countDown();
            }
        });
        notified.await();
        g.shutdownGracefully();
    }

    @Test
    public void testTooManyAcceptedChannels() throws Exception {
        OioEventLoopGroup g = new OioEventLoopGroup(1);
        ServerBootstrap sb = new ServerBootstrap();
        sb.channel(OioServerSocketChannel.class);
        sb.group((EventLoopGroup)g);
        sb.childHandler((ChannelHandler)new ChannelInboundHandlerAdapter());
        ChannelFuture f1 = sb.bind(0);
        f1.sync();
        Socket s = new Socket(NetUtil.LOCALHOST, ((InetSocketAddress)f1.channel().localAddress()).getPort());
        org.junit.jupiter.api.Assertions.assertEquals((int)-1, (int)s.getInputStream().read());
        s.close();
        g.shutdownGracefully();
    }
}

