/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.socket.nio;

import io.netty.channel.ChannelOption;
import io.netty.channel.nio.AbstractNioChannel;
import io.netty.channel.socket.nio.NioChannelOption;
import java.io.IOException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.NetworkChannel;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractNioDomainChannelTest<T extends AbstractNioChannel> {
    protected abstract T newNioChannel();

    protected abstract NetworkChannel jdkChannel(T var1);

    protected abstract SocketOption<?> newInvalidOption();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNioChannelOption() throws IOException {
        T channel = this.newNioChannel();
        try {
            NetworkChannel jdkChannel = this.jdkChannel(channel);
            ChannelOption option = NioChannelOption.of(StandardSocketOptions.SO_RCVBUF);
            int value1 = jdkChannel.getOption(StandardSocketOptions.SO_RCVBUF);
            int value2 = (Integer)channel.config().getOption(option);
            Assertions.assertEquals((int)value1, (int)value2);
            channel.config().setOption(option, (Object)(1 + value2));
            int value3 = jdkChannel.getOption(StandardSocketOptions.SO_RCVBUF);
            int value4 = (Integer)channel.config().getOption(option);
            Assertions.assertEquals((int)value3, (int)value4);
            Assertions.assertNotEquals((int)value1, (int)value4);
        }
        finally {
            channel.unsafe().closeForcibly();
        }
    }

    @Test
    public void testInvalidNioChannelOption() {
        T channel = this.newNioChannel();
        try {
            ChannelOption option = NioChannelOption.of(this.newInvalidOption());
            Assertions.assertFalse((boolean)channel.config().setOption(option, null));
            Assertions.assertNull((Object)channel.config().getOption(option));
        }
        finally {
            channel.unsafe().closeForcibly();
        }
    }

    @Test
    public void testGetOptions() {
        T channel = this.newNioChannel();
        try {
            channel.config().getOptions();
        }
        finally {
            channel.unsafe().closeForcibly();
        }
    }
}

