/*
 * Decompiled with CFR 0.152.
 */
package io.netty.bootstrap;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerAdapter;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.local.LocalEventLoopGroup;
import io.netty.channel.local.LocalServerChannel;
import io.netty.util.AttributeKey;
import java.net.SocketAddress;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Test;

public class ServerBootstrapTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testHandlerRegister() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference error = new AtomicReference();
        LocalEventLoopGroup group = new LocalEventLoopGroup(1);
        try {
            ServerBootstrap sb = new ServerBootstrap();
            ((ServerBootstrap)sb.channel(LocalServerChannel.class)).group((EventLoopGroup)group).childHandler((ChannelHandler)new ChannelInboundHandlerAdapter()).handler((ChannelHandler)new ChannelHandlerAdapter(){

                public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
                    try {
                        Assert.assertTrue((boolean)ctx.executor().inEventLoop());
                    }
                    catch (Throwable cause) {
                        error.set(cause);
                    }
                    finally {
                        latch.countDown();
                    }
                }
            });
            sb.register().syncUninterruptibly();
            latch.await();
            Assert.assertNull(error.get());
        }
        finally {
            group.shutdownGracefully();
        }
    }

    @Test(timeout=3000L)
    public void testParentHandler() throws Exception {
        ServerBootstrapTest.testParentHandler(false);
    }

    @Test(timeout=3000L)
    public void testParentHandlerViaChannelInitializer() throws Exception {
        ServerBootstrapTest.testParentHandler(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testParentHandler(boolean channelInitializer) throws Exception {
        LocalAddress addr = new LocalAddress(UUID.randomUUID().toString());
        final CountDownLatch readLatch = new CountDownLatch(1);
        final CountDownLatch initLatch = new CountDownLatch(1);
        ChannelInboundHandlerAdapter handler = new ChannelInboundHandlerAdapter(){

            public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
                initLatch.countDown();
                super.handlerAdded(ctx);
            }

            public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                readLatch.countDown();
                super.channelRead(ctx, msg);
            }
        };
        DefaultEventLoopGroup group = new DefaultEventLoopGroup(1);
        Channel sch = null;
        Channel cch = null;
        try {
            ServerBootstrap sb = new ServerBootstrap();
            ((ServerBootstrap)sb.channel(LocalServerChannel.class)).group((EventLoopGroup)group).childHandler((ChannelHandler)new ChannelInboundHandlerAdapter());
            if (channelInitializer) {
                sb.handler((ChannelHandler)new ChannelInitializer<Channel>((ChannelHandler)handler){
                    final /* synthetic */ ChannelHandler val$handler;
                    {
                        this.val$handler = channelHandler;
                    }

                    protected void initChannel(Channel ch) throws Exception {
                        ch.pipeline().addLast(new ChannelHandler[]{this.val$handler});
                    }
                });
            } else {
                sb.handler((ChannelHandler)handler);
            }
            Bootstrap cb = new Bootstrap();
            ((Bootstrap)((Bootstrap)cb.group((EventLoopGroup)group)).channel(LocalChannel.class)).handler((ChannelHandler)new ChannelInboundHandlerAdapter());
            sch = sb.bind((SocketAddress)addr).syncUninterruptibly().channel();
            cch = cb.connect((SocketAddress)addr).syncUninterruptibly().channel();
            initLatch.await();
            readLatch.await();
        }
        finally {
            if (sch != null) {
                sch.close().syncUninterruptibly();
            }
            if (cch != null) {
                cch.close().syncUninterruptibly();
            }
            group.shutdownGracefully();
        }
    }

    @Test
    public void optionsAndAttributesMustBeAvailableOnChildChannelInit() throws InterruptedException {
        DefaultEventLoopGroup group = new DefaultEventLoopGroup(1);
        LocalAddress addr = new LocalAddress(UUID.randomUUID().toString());
        final AttributeKey key = AttributeKey.valueOf((String)UUID.randomUUID().toString());
        final AtomicBoolean requestServed = new AtomicBoolean();
        ServerBootstrap sb = ((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)group).channel(LocalServerChannel.class)).childOption(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)4242).childAttr(key, (Object)"value").childHandler((ChannelHandler)new ChannelInitializer<LocalChannel>(){

            protected void initChannel(LocalChannel ch) throws Exception {
                Integer option = (Integer)ch.config().getOption(ChannelOption.CONNECT_TIMEOUT_MILLIS);
                Assert.assertEquals((long)4242L, (long)option.intValue());
                Assert.assertEquals((Object)"value", (Object)ch.attr(key).get());
                requestServed.set(true);
            }
        });
        Channel serverChannel = sb.bind((SocketAddress)addr).syncUninterruptibly().channel();
        Bootstrap cb = new Bootstrap();
        ((Bootstrap)((Bootstrap)cb.group((EventLoopGroup)group)).channel(LocalChannel.class)).handler((ChannelHandler)new ChannelInboundHandlerAdapter());
        Channel clientChannel = cb.connect((SocketAddress)addr).syncUninterruptibly().channel();
        serverChannel.close().syncUninterruptibly();
        clientChannel.close().syncUninterruptibly();
        group.shutdownGracefully();
        Assert.assertTrue((boolean)requestServed.get());
    }
}

