/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.LoggingHandler;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.local.LocalServerChannel;
import org.junit.Assert;

class BaseChannelTest {
    private final LoggingHandler loggingHandler = new LoggingHandler();

    BaseChannelTest() {
    }

    ServerBootstrap getLocalServerBootstrap() {
        DefaultEventLoopGroup serverGroup = new DefaultEventLoopGroup();
        ServerBootstrap sb = new ServerBootstrap();
        sb.group((EventLoopGroup)serverGroup);
        sb.channel(LocalServerChannel.class);
        sb.childHandler((ChannelHandler)new ChannelInitializer<LocalChannel>(){

            public void initChannel(LocalChannel ch) throws Exception {
            }
        });
        return sb;
    }

    Bootstrap getLocalClientBootstrap() {
        DefaultEventLoopGroup clientGroup = new DefaultEventLoopGroup();
        Bootstrap cb = new Bootstrap();
        cb.channel(LocalChannel.class);
        cb.group((EventLoopGroup)clientGroup);
        cb.handler((ChannelHandler)this.loggingHandler);
        return cb;
    }

    static ByteBuf createTestBuf(int len) {
        ByteBuf buf = Unpooled.buffer((int)len, (int)len);
        buf.setIndex(0, len);
        return buf;
    }

    void assertLog(String firstExpected, String ... otherExpected) {
        String actual = this.loggingHandler.getLog();
        if (firstExpected.equals(actual)) {
            return;
        }
        for (String e : otherExpected) {
            if (!e.equals(actual)) continue;
            return;
        }
        Assert.assertEquals((Object)firstExpected, (Object)actual);
    }

    void clearLog() {
        this.loggingHandler.clear();
    }

    void setInterest(LoggingHandler.Event ... events) {
        this.loggingHandler.setInterest(events);
    }
}

