/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.embedded;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelId;
import io.netty.channel.embedded.EmbeddedChannelId;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.junit.Assert;
import org.junit.Test;

public class EmbeddedChannelIdTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSerialization() throws IOException, ClassNotFoundException {
        ChannelId deserializedInstance;
        ChannelId normalInstance = EmbeddedChannelId.INSTANCE;
        ByteBuf buf = Unpooled.buffer();
        ObjectOutputStream outStream = new ObjectOutputStream((OutputStream)new ByteBufOutputStream(buf));
        try {
            outStream.writeObject(normalInstance);
        }
        finally {
            outStream.close();
        }
        ObjectInputStream inStream = new ObjectInputStream((InputStream)new ByteBufInputStream(buf, true));
        try {
            deserializedInstance = (ChannelId)inStream.readObject();
        }
        finally {
            inStream.close();
        }
        Assert.assertEquals((Object)normalInstance, (Object)deserializedInstance);
        Assert.assertEquals((long)normalInstance.hashCode(), (long)deserializedInstance.hashCode());
        Assert.assertEquals((long)0L, (long)normalInstance.compareTo((Object)deserializedInstance));
    }
}

