/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.local;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.local.LocalServerChannel;
import io.netty.util.ReferenceCountUtil;
import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;

public class LocalTransportThreadModelTest2 {
    private static final String LOCAL_CHANNEL = LocalTransportThreadModelTest2.class.getName();
    static final int messageCountPerRun = 4;

    @Test(timeout=15000L)
    public void testSocketReuse() throws InterruptedException {
        ServerBootstrap serverBootstrap = new ServerBootstrap();
        LocalHandler serverHandler = new LocalHandler("SERVER");
        ((ServerBootstrap)serverBootstrap.group((EventLoopGroup)new DefaultEventLoopGroup(), (EventLoopGroup)new DefaultEventLoopGroup()).channel(LocalServerChannel.class)).childHandler((ChannelHandler)serverHandler);
        Bootstrap clientBootstrap = new Bootstrap();
        LocalHandler clientHandler = new LocalHandler("CLIENT");
        ((Bootstrap)((Bootstrap)clientBootstrap.group((EventLoopGroup)new DefaultEventLoopGroup())).channel(LocalChannel.class)).remoteAddress((SocketAddress)new LocalAddress(LOCAL_CHANNEL)).handler((ChannelHandler)clientHandler);
        serverBootstrap.bind((SocketAddress)new LocalAddress(LOCAL_CHANNEL)).sync();
        int count = 100;
        for (int i = 1; i < count + 1; ++i) {
            Channel ch = clientBootstrap.connect().sync().channel();
            int target = i * 4;
            while (serverHandler.count.get() != target || clientHandler.count.get() != target) {
                Thread.sleep(50L);
            }
            this.close(ch, clientHandler);
        }
        Assert.assertEquals((long)(count * 2 * 4), (long)(serverHandler.count.get() + clientHandler.count.get()));
    }

    public void close(final Channel localChannel, final LocalHandler localRegistrationHandler) {
        if (localChannel.eventLoop().inEventLoop()) {
            if (localRegistrationHandler.lastWriteFuture != null) {
                localRegistrationHandler.lastWriteFuture.awaitUninterruptibly();
            }
            localChannel.close();
            return;
        }
        localChannel.eventLoop().execute(new Runnable(){

            @Override
            public void run() {
                LocalTransportThreadModelTest2.this.close(localChannel, localRegistrationHandler);
            }
        });
        localChannel.closeFuture().awaitUninterruptibly();
    }

    @ChannelHandler.Sharable
    static class LocalHandler
    extends ChannelInboundHandlerAdapter {
        private final String name;
        public volatile ChannelFuture lastWriteFuture;
        public final AtomicInteger count = new AtomicInteger(0);

        LocalHandler(String name) {
            this.name = name;
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            for (int i = 0; i < 4; ++i) {
                this.lastWriteFuture = ctx.channel().write((Object)(this.name + ' ' + i));
            }
            ctx.channel().flush();
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            this.count.incrementAndGet();
            ReferenceCountUtil.release((Object)msg);
        }
    }
}

