/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.socket.nio;

import io.netty.channel.Channel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.AbstractNioChannelTest;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.NetworkChannel;
import java.nio.channels.ServerSocketChannel;
import org.junit.Assert;
import org.junit.Test;

public class NioServerSocketChannelTest
extends AbstractNioChannelTest<NioServerSocketChannel> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCloseOnError() throws Exception {
        ServerSocketChannel jdkChannel = ServerSocketChannel.open();
        NioServerSocketChannel serverSocketChannel = new NioServerSocketChannel(jdkChannel);
        NioEventLoopGroup group = new NioEventLoopGroup(1);
        try {
            group.register((Channel)serverSocketChannel).syncUninterruptibly();
            serverSocketChannel.bind((SocketAddress)new InetSocketAddress(0)).syncUninterruptibly();
            Assert.assertFalse((boolean)serverSocketChannel.closeOnReadError((Throwable)new IOException()));
            Assert.assertTrue((boolean)serverSocketChannel.closeOnReadError((Throwable)new IllegalArgumentException()));
            serverSocketChannel.close().syncUninterruptibly();
        }
        finally {
            group.shutdownGracefully();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIsActiveFalseAfterClose() {
        NioServerSocketChannel serverSocketChannel = new NioServerSocketChannel();
        NioEventLoopGroup group = new NioEventLoopGroup(1);
        try {
            group.register((Channel)serverSocketChannel).syncUninterruptibly();
            Channel channel = serverSocketChannel.bind((SocketAddress)new InetSocketAddress(0)).syncUninterruptibly().channel();
            Assert.assertTrue((boolean)channel.isActive());
            Assert.assertTrue((boolean)channel.isOpen());
            channel.close().syncUninterruptibly();
            Assert.assertFalse((boolean)channel.isOpen());
            Assert.assertFalse((boolean)channel.isActive());
        }
        finally {
            group.shutdownGracefully();
        }
    }

    @Override
    protected NioServerSocketChannel newNioChannel() {
        return new NioServerSocketChannel();
    }

    @Override
    protected NetworkChannel jdkChannel(NioServerSocketChannel channel) {
        return channel.javaChannel();
    }

    @Override
    protected SocketOption<?> newInvalidOption() {
        return StandardSocketOptions.IP_MULTICAST_IF;
    }
}

