/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.core.Appender;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.channel.SingleThreadEventLoop;
import io.netty.channel.local.LocalChannel;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ScheduledFuture;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.LoggerFactory;

public class SingleThreadEventLoopTest {
    private static final Runnable NOOP = new Runnable(){

        @Override
        public void run() {
        }
    };
    private SingleThreadEventLoopA loopA;
    private SingleThreadEventLoopB loopB;
    private SingleThreadEventLoopC loopC;

    @BeforeEach
    public void newEventLoop() {
        this.loopA = new SingleThreadEventLoopA();
        this.loopB = new SingleThreadEventLoopB();
        this.loopC = new SingleThreadEventLoopC();
    }

    @AfterEach
    public void stopEventLoop() {
        if (!this.loopA.isShuttingDown()) {
            this.loopA.shutdownGracefully(0L, 0L, TimeUnit.MILLISECONDS);
        }
        if (!this.loopB.isShuttingDown()) {
            this.loopB.shutdownGracefully(0L, 0L, TimeUnit.MILLISECONDS);
        }
        if (!this.loopC.isShuttingDown()) {
            this.loopC.shutdownGracefully(0L, 0L, TimeUnit.MILLISECONDS);
        }
        while (!this.loopA.isTerminated()) {
            try {
                this.loopA.awaitTermination(1L, TimeUnit.DAYS);
            }
            catch (InterruptedException interruptedException) {}
        }
        Assertions.assertEquals((int)1, (int)this.loopA.cleanedUp.get());
        while (!this.loopB.isTerminated()) {
            try {
                this.loopB.awaitTermination(1L, TimeUnit.DAYS);
            }
            catch (InterruptedException interruptedException) {}
        }
        while (!this.loopC.isTerminated()) {
            try {
                this.loopC.awaitTermination(1L, TimeUnit.DAYS);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Test
    public void shutdownBeforeStart() throws Exception {
        this.loopA.shutdown();
        SingleThreadEventLoopTest.assertRejection((EventExecutor)this.loopA);
    }

    @Test
    public void shutdownAfterStart() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        this.loopA.execute(new Runnable(){

            @Override
            public void run() {
                latch.countDown();
            }
        });
        latch.await();
        this.loopA.shutdown();
        SingleThreadEventLoopTest.assertRejection((EventExecutor)this.loopA);
        Assertions.assertTrue((boolean)this.loopA.isShutdown());
        while (!this.loopA.isTerminated()) {
            this.loopA.awaitTermination(1L, TimeUnit.DAYS);
        }
    }

    private static void assertRejection(EventExecutor loop) {
        try {
            loop.execute(NOOP);
            Assertions.fail((String)"A task must be rejected after shutdown() is called.");
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    @Test
    public void scheduleTaskA() throws Exception {
        SingleThreadEventLoopTest.testScheduleTask((EventLoop)this.loopA);
    }

    @Test
    public void scheduleTaskB() throws Exception {
        SingleThreadEventLoopTest.testScheduleTask((EventLoop)this.loopB);
    }

    @Test
    public void scheduleTaskC() throws Exception {
        SingleThreadEventLoopTest.testScheduleTask((EventLoop)this.loopC);
    }

    private static void testScheduleTask(EventLoop loopA) throws InterruptedException, ExecutionException {
        long startTime = System.nanoTime();
        final AtomicLong endTime = new AtomicLong();
        loopA.schedule(new Runnable(){

            @Override
            public void run() {
                endTime.set(System.nanoTime());
            }
        }, 500L, TimeUnit.MILLISECONDS).get();
        MatcherAssert.assertThat((Object)(endTime.get() - startTime), (Matcher)Matchers.is((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(TimeUnit.MILLISECONDS.toNanos(500L)))));
    }

    @Test
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void scheduleTaskAtFixedRateA() throws Exception {
        SingleThreadEventLoopTest.testScheduleTaskAtFixedRate((EventLoop)this.loopA);
    }

    @Test
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void scheduleTaskAtFixedRateB() throws Exception {
        SingleThreadEventLoopTest.testScheduleTaskAtFixedRate((EventLoop)this.loopB);
    }

    private static void testScheduleTaskAtFixedRate(EventLoop loopA) throws InterruptedException {
        final LinkedBlockingQueue timestamps = new LinkedBlockingQueue();
        int expectedTimeStamps = 5;
        final CountDownLatch allTimeStampsLatch = new CountDownLatch(5);
        ScheduledFuture f = loopA.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                timestamps.add(System.nanoTime());
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                allTimeStampsLatch.countDown();
            }
        }, 100L, 100L, TimeUnit.MILLISECONDS);
        allTimeStampsLatch.await();
        Assertions.assertTrue((boolean)f.cancel(true));
        Thread.sleep(300L);
        Assertions.assertEquals((int)5, (int)timestamps.size());
        Long firstTimestamp = null;
        int cnt = 0;
        for (Long t : timestamps) {
            if (firstTimestamp == null) {
                firstTimestamp = t;
                continue;
            }
            long timepoint = t - firstTimestamp;
            MatcherAssert.assertThat((Object)timepoint, (Matcher)Matchers.is((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(TimeUnit.MILLISECONDS.toNanos(100 * cnt + 80)))));
            MatcherAssert.assertThat((Object)timepoint, (Matcher)Matchers.is((Matcher)Matchers.lessThan((Comparable)Long.valueOf(TimeUnit.MILLISECONDS.toNanos(100 * (cnt + 1) + 20)))));
            ++cnt;
        }
    }

    @Test
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void scheduleLaggyTaskAtFixedRateA() throws Exception {
        SingleThreadEventLoopTest.testScheduleLaggyTaskAtFixedRate((EventLoop)this.loopA);
    }

    @Test
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void scheduleLaggyTaskAtFixedRateB() throws Exception {
        SingleThreadEventLoopTest.testScheduleLaggyTaskAtFixedRate((EventLoop)this.loopB);
    }

    private static void testScheduleLaggyTaskAtFixedRate(EventLoop loopA) throws InterruptedException {
        final LinkedBlockingQueue timestamps = new LinkedBlockingQueue();
        int expectedTimeStamps = 5;
        final CountDownLatch allTimeStampsLatch = new CountDownLatch(5);
        ScheduledFuture f = loopA.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                boolean empty = timestamps.isEmpty();
                timestamps.add(System.nanoTime());
                if (empty) {
                    try {
                        Thread.sleep(401L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                allTimeStampsLatch.countDown();
            }
        }, 100L, 100L, TimeUnit.MILLISECONDS);
        allTimeStampsLatch.await();
        Assertions.assertTrue((boolean)f.cancel(true));
        Thread.sleep(300L);
        Assertions.assertEquals((int)5, (int)timestamps.size());
        int i = 0;
        Long previousTimestamp = null;
        for (Long t : timestamps) {
            if (previousTimestamp == null) {
                previousTimestamp = t;
                continue;
            }
            long diff = t - previousTimestamp;
            if (i == 0) {
                MatcherAssert.assertThat((Object)diff, (Matcher)Matchers.is((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(TimeUnit.MILLISECONDS.toNanos(400L)))));
            } else {
                MatcherAssert.assertThat((Object)diff, (Matcher)Matchers.is((Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(TimeUnit.MILLISECONDS.toNanos(10L)))));
            }
            previousTimestamp = t;
            ++i;
        }
    }

    @Test
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void scheduleTaskWithFixedDelayA() throws Exception {
        SingleThreadEventLoopTest.testScheduleTaskWithFixedDelay((EventLoop)this.loopA);
    }

    @Test
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void scheduleTaskWithFixedDelayB() throws Exception {
        SingleThreadEventLoopTest.testScheduleTaskWithFixedDelay((EventLoop)this.loopB);
    }

    private static void testScheduleTaskWithFixedDelay(EventLoop loopA) throws InterruptedException {
        final LinkedBlockingQueue timestamps = new LinkedBlockingQueue();
        int expectedTimeStamps = 3;
        final CountDownLatch allTimeStampsLatch = new CountDownLatch(3);
        ScheduledFuture f = loopA.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                timestamps.add(System.nanoTime());
                try {
                    Thread.sleep(51L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                allTimeStampsLatch.countDown();
            }
        }, 100L, 100L, TimeUnit.MILLISECONDS);
        allTimeStampsLatch.await();
        Assertions.assertTrue((boolean)f.cancel(true));
        Thread.sleep(300L);
        Assertions.assertEquals((int)3, (int)timestamps.size());
        Long previousTimestamp = null;
        for (Long t : timestamps) {
            if (previousTimestamp == null) {
                previousTimestamp = t;
                continue;
            }
            MatcherAssert.assertThat((Object)(t - previousTimestamp), (Matcher)Matchers.is((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(TimeUnit.MILLISECONDS.toNanos(150L)))));
            previousTimestamp = t;
        }
    }

    @Test
    public void shutdownWithPendingTasks() throws Exception {
        int NUM_TASKS = 3;
        final AtomicInteger ranTasks = new AtomicInteger();
        final CountDownLatch latch = new CountDownLatch(1);
        Runnable task = new Runnable(){

            @Override
            public void run() {
                ranTasks.incrementAndGet();
                while (latch.getCount() > 0L) {
                    try {
                        latch.await();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        };
        for (int i = 0; i < 3; ++i) {
            this.loopA.execute(task);
        }
        while (ranTasks.get() == 0) {
            Thread.yield();
        }
        Assertions.assertEquals((int)1, (int)ranTasks.get());
        this.loopA.shutdown();
        latch.countDown();
        while (!this.loopA.isTerminated()) {
            this.loopA.awaitTermination(1L, TimeUnit.DAYS);
        }
        Assertions.assertEquals((int)3, (int)ranTasks.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=10000L, unit=TimeUnit.MILLISECONDS)
    public void testRegistrationAfterShutdown() throws Exception {
        this.loopA.shutdown();
        Logger root = (Logger)LoggerFactory.getLogger((String)"ROOT");
        ArrayList<Appender> appenders = new ArrayList<Appender>();
        Iterator i = root.iteratorForAppenders();
        while (i.hasNext()) {
            Appender a = (Appender)i.next();
            appenders.add(a);
            root.detachAppender(a);
        }
        try {
            ChannelFuture f = this.loopA.register((Channel)new LocalChannel());
            f.awaitUninterruptibly();
            Assertions.assertFalse((boolean)f.isSuccess());
            MatcherAssert.assertThat((Object)f.cause(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(RejectedExecutionException.class)));
            Assertions.assertFalse((boolean)f.channel().isOpen());
        }
        finally {
            for (Appender a : appenders) {
                root.addAppender(a);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=10000L, unit=TimeUnit.MILLISECONDS)
    public void testRegistrationAfterShutdown2() throws Exception {
        this.loopA.shutdown();
        final CountDownLatch latch = new CountDownLatch(1);
        LocalChannel ch = new LocalChannel();
        ChannelPromise promise = ch.newPromise();
        promise.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                latch.countDown();
            }
        });
        Logger root = (Logger)LoggerFactory.getLogger((String)"ROOT");
        ArrayList<Appender> appenders = new ArrayList<Appender>();
        Iterator i = root.iteratorForAppenders();
        while (i.hasNext()) {
            Appender a = (Appender)i.next();
            appenders.add(a);
            root.detachAppender(a);
        }
        try {
            ChannelFuture f = this.loopA.register(promise);
            f.awaitUninterruptibly();
            Assertions.assertFalse((boolean)f.isSuccess());
            MatcherAssert.assertThat((Object)f.cause(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(RejectedExecutionException.class)));
            Assertions.assertFalse((boolean)latch.await(1L, TimeUnit.SECONDS));
            Assertions.assertFalse((boolean)ch.isOpen());
        }
        finally {
            for (Appender a : appenders) {
                root.addAppender(a);
            }
        }
    }

    @Test
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void testGracefulShutdownQuietPeriod() throws Exception {
        this.loopA.shutdownGracefully(1L, Integer.MAX_VALUE, TimeUnit.SECONDS);
        for (int i = 0; i < 20; ++i) {
            Thread.sleep(100L);
            this.loopA.execute(NOOP);
        }
        long startTime = System.nanoTime();
        MatcherAssert.assertThat((Object)this.loopA.isShuttingDown(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.loopA.isShutdown(), (Matcher)Matchers.is((Object)false));
        while (!this.loopA.isTerminated()) {
            this.loopA.awaitTermination(Integer.MAX_VALUE, TimeUnit.SECONDS);
        }
        MatcherAssert.assertThat((Object)(System.nanoTime() - startTime), (Matcher)Matchers.is((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(TimeUnit.SECONDS.toNanos(1L)))));
    }

    @Test
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void testGracefulShutdownTimeout() throws Exception {
        int i;
        this.loopA.shutdownGracefully(2L, 2L, TimeUnit.SECONDS);
        for (i = 0; i < 10; ++i) {
            Thread.sleep(100L);
            this.loopA.execute(NOOP);
        }
        try {
            for (i = 0; i < 20; ++i) {
                Thread.sleep(100L);
                this.loopA.execute(NOOP);
            }
            Assertions.fail((String)"shutdownGracefully() must reject a task after timeout.");
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
        MatcherAssert.assertThat((Object)this.loopA.isShuttingDown(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.loopA.isShutdown(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    @Timeout(value=10000L, unit=TimeUnit.MILLISECONDS)
    public void testOnEventLoopIteration() throws Exception {
        CountingRunnable onIteration = new CountingRunnable();
        this.loopC.executeAfterEventLoopIteration(onIteration);
        CountingRunnable noopTask = new CountingRunnable();
        this.loopC.submit(noopTask).sync();
        this.loopC.iterationEndSignal.take();
        MatcherAssert.assertThat((String)"Unexpected invocation count for regular task.", (Object)noopTask.getInvocationCount(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((String)"Unexpected invocation count for on every eventloop iteration task.", (Object)onIteration.getInvocationCount(), (Matcher)Matchers.is((Object)1));
    }

    @Test
    @Timeout(value=10000L, unit=TimeUnit.MILLISECONDS)
    public void testRemoveOnEventLoopIteration() throws Exception {
        CountingRunnable onIteration1 = new CountingRunnable();
        this.loopC.executeAfterEventLoopIteration(onIteration1);
        CountingRunnable onIteration2 = new CountingRunnable();
        this.loopC.executeAfterEventLoopIteration(onIteration2);
        this.loopC.removeAfterEventLoopIterationTask(onIteration1);
        CountingRunnable noopTask = new CountingRunnable();
        this.loopC.submit(noopTask).sync();
        this.loopC.iterationEndSignal.take();
        MatcherAssert.assertThat((String)"Unexpected invocation count for regular task.", (Object)noopTask.getInvocationCount(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((String)"Unexpected invocation count for on every eventloop iteration task.", (Object)onIteration2.getInvocationCount(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((String)"Unexpected invocation count for on every eventloop iteration task.", (Object)onIteration1.getInvocationCount(), (Matcher)Matchers.is((Object)0));
    }

    private static class CountingRunnable
    implements Runnable {
        private final AtomicInteger invocationCount = new AtomicInteger();

        private CountingRunnable() {
        }

        @Override
        public void run() {
            this.invocationCount.incrementAndGet();
        }

        public int getInvocationCount() {
            return this.invocationCount.get();
        }

        public void resetInvocationCount() {
            this.invocationCount.set(0);
        }
    }

    private static final class SingleThreadEventLoopC
    extends SingleThreadEventLoopB {
        final LinkedBlockingQueue<Boolean> iterationEndSignal = new LinkedBlockingQueue(1);

        private SingleThreadEventLoopC() {
        }

        protected void afterRunningAllTasks() {
            super.afterRunningAllTasks();
            this.iterationEndSignal.offer(true);
        }

        @Override
        protected void runTasks0() {
            this.runAllTasks(TimeUnit.MINUTES.toNanos(1L));
        }
    }

    private static class SingleThreadEventLoopB
    extends SingleThreadEventLoop {
        SingleThreadEventLoopB() {
            super(null, Executors.defaultThreadFactory(), false);
        }

        protected void run() {
            do {
                try {
                    Thread.sleep(TimeUnit.NANOSECONDS.toMillis(this.delayNanos(System.nanoTime())));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.runTasks0();
            } while (!this.confirmShutdown());
        }

        protected void runTasks0() {
            this.runAllTasks();
        }

        protected void wakeup(boolean inEventLoop) {
            this.interruptThread();
        }
    }

    private static final class SingleThreadEventLoopA
    extends SingleThreadEventLoop {
        final AtomicInteger cleanedUp = new AtomicInteger();

        SingleThreadEventLoopA() {
            super(null, Executors.defaultThreadFactory(), true);
        }

        protected void run() {
            do {
                Runnable task;
                if ((task = this.takeTask()) == null) continue;
                task.run();
                this.updateLastExecutionTime();
            } while (!this.confirmShutdown());
        }

        protected void cleanup() {
            this.cleanedUp.incrementAndGet();
        }
    }
}

