/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.local;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.local.LocalServerChannel;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.EventExecutorGroup;
import java.net.SocketAddress;
import java.util.HashSet;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class LocalTransportThreadModelTest {
    private static EventLoopGroup group;
    private static LocalAddress localAddr;

    @BeforeAll
    public static void init() {
        group = new DefaultEventLoopGroup();
        ServerBootstrap sb = new ServerBootstrap();
        ((ServerBootstrap)sb.group(group).channel(LocalServerChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<LocalChannel>(){

            public void initChannel(LocalChannel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void channelRead(ChannelHandlerContext ctx, Object msg) {
                        ReferenceCountUtil.release((Object)msg);
                    }
                }});
            }
        });
        localAddr = (LocalAddress)sb.bind((SocketAddress)LocalAddress.ANY).syncUninterruptibly().channel().localAddress();
    }

    @AfterAll
    public static void destroy() throws Exception {
        group.shutdownGracefully().sync();
    }

    @Test
    @Timeout(value=30000L, unit=TimeUnit.MILLISECONDS)
    @Disabled(value="regression test")
    public void testStagedExecutionMultiple() throws Throwable {
        for (int i = 0; i < 10; ++i) {
            this.testStagedExecution();
        }
    }

    @Test
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void testStagedExecution() throws Throwable {
        DefaultEventLoopGroup l = new DefaultEventLoopGroup(4, (ThreadFactory)new DefaultThreadFactory("l"));
        DefaultEventExecutorGroup e1 = new DefaultEventExecutorGroup(4, (ThreadFactory)new DefaultThreadFactory("e1"));
        DefaultEventExecutorGroup e2 = new DefaultEventExecutorGroup(4, (ThreadFactory)new DefaultThreadFactory("e2"));
        ThreadNameAuditor h1 = new ThreadNameAuditor();
        ThreadNameAuditor h2 = new ThreadNameAuditor();
        ThreadNameAuditor h3 = new ThreadNameAuditor(true);
        LocalChannel ch = new LocalChannel();
        ch.pipeline().addLast(new ChannelHandler[]{h1});
        ch.pipeline().addLast((EventExecutorGroup)e1, new ChannelHandler[]{h2});
        ch.pipeline().addLast((EventExecutorGroup)e2, new ChannelHandler[]{h3});
        l.register((Channel)ch).sync().channel().connect((SocketAddress)localAddr).sync();
        ch.pipeline().fireChannelRead((Object)"1");
        ch.pipeline().context((ChannelHandler)h1).fireChannelRead((Object)"2");
        ch.pipeline().context((ChannelHandler)h2).fireChannelRead((Object)"3");
        ch.pipeline().context((ChannelHandler)h3).fireChannelRead((Object)"4");
        ch.pipeline().write((Object)"5");
        ch.pipeline().context((ChannelHandler)h3).write((Object)"6");
        ch.pipeline().context((ChannelHandler)h2).write((Object)"7");
        ch.pipeline().context((ChannelHandler)h1).writeAndFlush((Object)"8").sync();
        ch.close().sync();
        while (h1.outboundThreadNames.size() < 3 || h3.inboundThreadNames.size() < 3 || h1.removalThreadNames.size() < 1) {
            if (h1.exception.get() != null) {
                throw (Throwable)h1.exception.get();
            }
            if (h2.exception.get() != null) {
                throw (Throwable)h2.exception.get();
            }
            if (h3.exception.get() != null) {
                throw (Throwable)h3.exception.get();
            }
            Thread.sleep(10L);
        }
        String currentName = Thread.currentThread().getName();
        try {
            Assertions.assertFalse((boolean)h1.inboundThreadNames.contains(currentName));
            Assertions.assertFalse((boolean)h2.inboundThreadNames.contains(currentName));
            Assertions.assertFalse((boolean)h3.inboundThreadNames.contains(currentName));
            Assertions.assertFalse((boolean)h1.outboundThreadNames.contains(currentName));
            Assertions.assertFalse((boolean)h2.outboundThreadNames.contains(currentName));
            Assertions.assertFalse((boolean)h3.outboundThreadNames.contains(currentName));
            Assertions.assertFalse((boolean)h1.removalThreadNames.contains(currentName));
            Assertions.assertFalse((boolean)h2.removalThreadNames.contains(currentName));
            Assertions.assertFalse((boolean)h3.removalThreadNames.contains(currentName));
            for (String name : h1.inboundThreadNames) {
                Assertions.assertTrue((boolean)name.startsWith("l-"));
            }
            for (String name : h2.inboundThreadNames) {
                Assertions.assertTrue((boolean)name.startsWith("e1-"));
            }
            for (String name : h3.inboundThreadNames) {
                Assertions.assertTrue((boolean)name.startsWith("e2-"));
            }
            for (String name : h1.outboundThreadNames) {
                Assertions.assertTrue((boolean)name.startsWith("l-"));
            }
            for (String name : h2.outboundThreadNames) {
                Assertions.assertTrue((boolean)name.startsWith("e1-"));
            }
            for (String name : h3.outboundThreadNames) {
                Assertions.assertTrue((boolean)name.startsWith("e2-"));
            }
            for (String name : h1.removalThreadNames) {
                Assertions.assertTrue((boolean)name.startsWith("l-"));
            }
            for (String name : h2.removalThreadNames) {
                Assertions.assertTrue((boolean)name.startsWith("e1-"));
            }
            for (String name : h3.removalThreadNames) {
                Assertions.assertTrue((boolean)name.startsWith("e2-"));
            }
            HashSet names = new HashSet();
            names.addAll(h1.inboundThreadNames);
            names.addAll(h1.outboundThreadNames);
            names.addAll(h1.removalThreadNames);
            Assertions.assertEquals((int)1, (int)names.size());
            names.clear();
            names.addAll(h2.inboundThreadNames);
            names.addAll(h2.outboundThreadNames);
            names.addAll(h2.removalThreadNames);
            Assertions.assertEquals((int)1, (int)names.size());
            names.clear();
            names.addAll(h3.inboundThreadNames);
            names.addAll(h3.outboundThreadNames);
            names.addAll(h3.removalThreadNames);
            Assertions.assertEquals((int)1, (int)names.size());
            Assertions.assertEquals((int)1, (int)h1.inboundThreadNames.size());
            Assertions.assertEquals((int)2, (int)h2.inboundThreadNames.size());
            Assertions.assertEquals((int)3, (int)h3.inboundThreadNames.size());
            Assertions.assertEquals((int)3, (int)h1.outboundThreadNames.size());
            Assertions.assertEquals((int)2, (int)h2.outboundThreadNames.size());
            Assertions.assertEquals((int)1, (int)h3.outboundThreadNames.size());
            Assertions.assertEquals((int)1, (int)h1.removalThreadNames.size());
            Assertions.assertEquals((int)1, (int)h2.removalThreadNames.size());
            Assertions.assertEquals((int)1, (int)h3.removalThreadNames.size());
        }
        catch (AssertionError e) {
            System.out.println("H1I: " + h1.inboundThreadNames);
            System.out.println("H2I: " + h2.inboundThreadNames);
            System.out.println("H3I: " + h3.inboundThreadNames);
            System.out.println("H1O: " + h1.outboundThreadNames);
            System.out.println("H2O: " + h2.outboundThreadNames);
            System.out.println("H3O: " + h3.outboundThreadNames);
            System.out.println("H1R: " + h1.removalThreadNames);
            System.out.println("H2R: " + h2.removalThreadNames);
            System.out.println("H3R: " + h3.removalThreadNames);
            throw e;
        }
        finally {
            l.shutdownGracefully();
            e1.shutdownGracefully();
            e2.shutdownGracefully();
            l.terminationFuture().sync();
            e1.terminationFuture().sync();
            e2.terminationFuture().sync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=30000L, unit=TimeUnit.MILLISECONDS)
    @Disabled
    public void testConcurrentMessageBufferAccess() throws Throwable {
        DefaultEventLoopGroup l = new DefaultEventLoopGroup(4, (ThreadFactory)new DefaultThreadFactory("l"));
        DefaultEventExecutorGroup e1 = new DefaultEventExecutorGroup(4, (ThreadFactory)new DefaultThreadFactory("e1"));
        DefaultEventExecutorGroup e2 = new DefaultEventExecutorGroup(4, (ThreadFactory)new DefaultThreadFactory("e2"));
        DefaultEventExecutorGroup e3 = new DefaultEventExecutorGroup(4, (ThreadFactory)new DefaultThreadFactory("e3"));
        DefaultEventExecutorGroup e4 = new DefaultEventExecutorGroup(4, (ThreadFactory)new DefaultThreadFactory("e4"));
        DefaultEventExecutorGroup e5 = new DefaultEventExecutorGroup(4, (ThreadFactory)new DefaultThreadFactory("e5"));
        try {
            int end;
            int start;
            MessageForwarder1 h1 = new MessageForwarder1();
            MessageForwarder2 h2 = new MessageForwarder2();
            MessageForwarder3 h3 = new MessageForwarder3();
            MessageForwarder1 h4 = new MessageForwarder1();
            MessageForwarder2 h5 = new MessageForwarder2();
            MessageDiscarder h6 = new MessageDiscarder();
            LocalChannel ch = new LocalChannel();
            ch.pipeline().addLast(new ChannelHandler[]{h1}).addLast((EventExecutorGroup)e1, new ChannelHandler[]{h2}).addLast((EventExecutorGroup)e2, new ChannelHandler[]{h3}).addLast((EventExecutorGroup)e3, new ChannelHandler[]{h4}).addLast((EventExecutorGroup)e4, new ChannelHandler[]{h5}).addLast((EventExecutorGroup)e5, new ChannelHandler[]{h6});
            l.register((Channel)ch).sync().channel().connect((SocketAddress)localAddr).sync();
            int ROUNDS = 1024;
            int ELEMS_PER_ROUNDS = 8192;
            int TOTAL_CNT = 0x800000;
            int i = 0;
            while (i < 0x800000) {
                start = i;
                i = end = i + 8192;
                ch.eventLoop().execute(new Runnable((Channel)ch){
                    final /* synthetic */ Channel val$ch;
                    {
                        this.val$ch = channel;
                    }

                    @Override
                    public void run() {
                        for (int j = start; j < end; ++j) {
                            this.val$ch.pipeline().fireChannelRead((Object)j);
                        }
                    }
                });
            }
            while (h1.inCnt < 0x800000 || h2.inCnt < 0x800000 || h3.inCnt < 0x800000 || h4.inCnt < 0x800000 || h5.inCnt < 0x800000 || h6.inCnt < 0x800000) {
                if (h1.exception.get() != null) {
                    throw (Throwable)h1.exception.get();
                }
                if (h2.exception.get() != null) {
                    throw (Throwable)h2.exception.get();
                }
                if (h3.exception.get() != null) {
                    throw (Throwable)h3.exception.get();
                }
                if (h4.exception.get() != null) {
                    throw (Throwable)h4.exception.get();
                }
                if (h5.exception.get() != null) {
                    throw (Throwable)h5.exception.get();
                }
                if (h6.exception.get() != null) {
                    throw (Throwable)h6.exception.get();
                }
                Thread.sleep(10L);
            }
            i = 0;
            while (i < 0x800000) {
                start = i;
                i = end = i + 8192;
                ch.pipeline().context((ChannelHandler)h6).executor().execute(new Runnable((Channel)ch){
                    final /* synthetic */ Channel val$ch;
                    {
                        this.val$ch = channel;
                    }

                    @Override
                    public void run() {
                        for (int j = start; j < end; ++j) {
                            this.val$ch.write((Object)j);
                        }
                        this.val$ch.flush();
                    }
                });
            }
            while (h1.outCnt < 0x800000 || h2.outCnt < 0x800000 || h3.outCnt < 0x800000 || h4.outCnt < 0x800000 || h5.outCnt < 0x800000 || h6.outCnt < 0x800000) {
                if (h1.exception.get() != null) {
                    throw (Throwable)h1.exception.get();
                }
                if (h2.exception.get() != null) {
                    throw (Throwable)h2.exception.get();
                }
                if (h3.exception.get() != null) {
                    throw (Throwable)h3.exception.get();
                }
                if (h4.exception.get() != null) {
                    throw (Throwable)h4.exception.get();
                }
                if (h5.exception.get() != null) {
                    throw (Throwable)h5.exception.get();
                }
                if (h6.exception.get() != null) {
                    throw (Throwable)h6.exception.get();
                }
                Thread.sleep(10L);
            }
            ch.close().sync();
        }
        finally {
            l.shutdownGracefully();
            e1.shutdownGracefully();
            e2.shutdownGracefully();
            e3.shutdownGracefully();
            e4.shutdownGracefully();
            e5.shutdownGracefully();
            l.terminationFuture().sync();
            e1.terminationFuture().sync();
            e2.terminationFuture().sync();
            e3.terminationFuture().sync();
            e4.terminationFuture().sync();
            e5.terminationFuture().sync();
        }
    }

    private static class MessageDiscarder
    extends ChannelDuplexHandler {
        private final AtomicReference<Throwable> exception = new AtomicReference();
        private volatile int inCnt;
        private volatile int outCnt;
        private volatile Thread t;

        private MessageDiscarder() {
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            Thread t = this.t;
            if (t == null) {
                this.t = Thread.currentThread();
            } else {
                Assertions.assertSame((Object)t, (Object)Thread.currentThread());
            }
            int actual = (Integer)msg;
            int expected = this.inCnt++;
            Assertions.assertEquals((int)expected, (int)actual);
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            Assertions.assertSame((Object)this.t, (Object)Thread.currentThread());
            int actual = (Integer)msg;
            int expected = this.outCnt++;
            Assertions.assertEquals((int)expected, (int)actual);
            ctx.write(msg, promise);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            this.exception.compareAndSet(null, cause);
            super.exceptionCaught(ctx, cause);
        }
    }

    private static class MessageForwarder3
    extends ChannelDuplexHandler {
        private final AtomicReference<Throwable> exception = new AtomicReference();
        private volatile int inCnt;
        private volatile int outCnt;
        private volatile Thread t;

        private MessageForwarder3() {
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            Thread t = this.t;
            if (t == null) {
                this.t = Thread.currentThread();
            } else {
                Assertions.assertSame((Object)t, (Object)Thread.currentThread());
            }
            int actual = (Integer)msg;
            int expected = this.inCnt++;
            Assertions.assertEquals((int)expected, (int)actual);
            ctx.fireChannelRead(msg);
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            Assertions.assertSame((Object)this.t, (Object)Thread.currentThread());
            int actual = (Integer)msg;
            int expected = this.outCnt++;
            Assertions.assertEquals((int)expected, (int)actual);
            ctx.write(msg, promise);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            this.exception.compareAndSet(null, cause);
            System.err.print('[' + Thread.currentThread().getName() + "] ");
            cause.printStackTrace();
            super.exceptionCaught(ctx, cause);
        }
    }

    private static class MessageForwarder2
    extends ChannelDuplexHandler {
        private final AtomicReference<Throwable> exception = new AtomicReference();
        private volatile int inCnt;
        private volatile int outCnt;
        private volatile Thread t;

        private MessageForwarder2() {
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            Thread t = this.t;
            if (t == null) {
                this.t = Thread.currentThread();
            } else {
                Assertions.assertSame((Object)t, (Object)Thread.currentThread());
            }
            ByteBuf m = (ByteBuf)msg;
            int count = m.readableBytes() / 4;
            for (int j = 0; j < count; ++j) {
                int expected;
                int actual = m.readInt();
                ++this.inCnt;
                Assertions.assertEquals((int)expected, (int)actual);
                ctx.fireChannelRead((Object)actual);
            }
            m.release();
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            Assertions.assertSame((Object)this.t, (Object)Thread.currentThread());
            ByteBuf out = ctx.alloc().buffer(4);
            int m = (Integer)msg;
            int expected = this.outCnt++;
            Assertions.assertEquals((int)expected, (int)m);
            out.writeInt(m);
            ctx.write((Object)out, promise);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            this.exception.compareAndSet(null, cause);
            super.exceptionCaught(ctx, cause);
        }
    }

    private static class MessageForwarder1
    extends ChannelDuplexHandler {
        private final AtomicReference<Throwable> exception = new AtomicReference();
        private volatile int inCnt;
        private volatile int outCnt;
        private volatile Thread t;

        private MessageForwarder1() {
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            Thread t = this.t;
            if (t == null) {
                this.t = Thread.currentThread();
            } else {
                Assertions.assertSame((Object)t, (Object)Thread.currentThread());
            }
            ByteBuf out = ctx.alloc().buffer(4);
            int m = (Integer)msg;
            int expected = this.inCnt++;
            Assertions.assertEquals((int)expected, (int)m);
            out.writeInt(m);
            ctx.fireChannelRead((Object)out);
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            Assertions.assertSame((Object)this.t, (Object)Thread.currentThread());
            boolean swallow = this == ctx.pipeline().first();
            ByteBuf m = (ByteBuf)msg;
            int count = m.readableBytes() / 4;
            for (int j = 0; j < count; ++j) {
                int expected;
                int actual = m.readInt();
                ++this.outCnt;
                Assertions.assertEquals((int)expected, (int)actual);
                if (swallow) continue;
                ctx.write((Object)actual);
            }
            ctx.writeAndFlush((Object)Unpooled.EMPTY_BUFFER, promise);
            m.release();
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            this.exception.compareAndSet(null, cause);
            super.exceptionCaught(ctx, cause);
        }
    }

    private static class ThreadNameAuditor
    extends ChannelDuplexHandler {
        private final AtomicReference<Throwable> exception = new AtomicReference();
        private final Queue<String> inboundThreadNames = new ConcurrentLinkedQueue<String>();
        private final Queue<String> outboundThreadNames = new ConcurrentLinkedQueue<String>();
        private final Queue<String> removalThreadNames = new ConcurrentLinkedQueue<String>();
        private final boolean discard;

        ThreadNameAuditor() {
            this(false);
        }

        ThreadNameAuditor(boolean discard) {
            this.discard = discard;
        }

        public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
            this.removalThreadNames.add(Thread.currentThread().getName());
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            this.inboundThreadNames.add(Thread.currentThread().getName());
            if (!this.discard) {
                ctx.fireChannelRead(msg);
            }
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            this.outboundThreadNames.add(Thread.currentThread().getName());
            ctx.write(msg, promise);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            this.exception.compareAndSet(null, cause);
            System.err.print('[' + Thread.currentThread().getName() + "] ");
            cause.printStackTrace();
            super.exceptionCaught(ctx, cause);
        }
    }
}

