/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.pool;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.local.LocalServerChannel;
import io.netty.channel.pool.AbstractChannelPoolHandler;
import io.netty.channel.pool.ChannelHealthChecker;
import io.netty.channel.pool.ChannelPool;
import io.netty.channel.pool.ChannelPoolHandler;
import io.netty.channel.pool.ChannelPoolTestUtils;
import io.netty.channel.pool.CountingChannelPoolHandler;
import io.netty.channel.pool.FixedChannelPool;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class FixedChannelPoolTest {
    private static EventLoopGroup group;

    @BeforeAll
    public static void createEventLoop() {
        group = new DefaultEventLoopGroup();
    }

    @AfterAll
    public static void destroyEventLoop() {
        if (group != null) {
            group.shutdownGracefully();
        }
    }

    @Test
    public void testAcquire() throws Exception {
        LocalAddress addr = new LocalAddress(ChannelPoolTestUtils.getLocalAddrId());
        Bootstrap cb = new Bootstrap();
        cb.remoteAddress((SocketAddress)addr);
        ((Bootstrap)cb.group(group)).channel(LocalChannel.class);
        ServerBootstrap sb = new ServerBootstrap();
        ((ServerBootstrap)sb.group(group).channel(LocalServerChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<LocalChannel>(){

            public void initChannel(LocalChannel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter()});
            }
        });
        Channel sc = sb.bind((SocketAddress)addr).syncUninterruptibly().channel();
        CountingChannelPoolHandler handler = new CountingChannelPoolHandler();
        FixedChannelPool pool = new FixedChannelPool(cb, (ChannelPoolHandler)handler, 1, Integer.MAX_VALUE);
        Channel channel = (Channel)pool.acquire().syncUninterruptibly().getNow();
        Future future = pool.acquire();
        Assertions.assertFalse((boolean)future.isDone());
        pool.release(channel).syncUninterruptibly();
        Assertions.assertTrue((boolean)future.await(1L, TimeUnit.SECONDS));
        Channel channel2 = (Channel)future.getNow();
        Assertions.assertSame((Object)channel, (Object)channel2);
        Assertions.assertEquals((int)1, (int)handler.channelCount());
        Assertions.assertEquals((int)2, (int)handler.acquiredCount());
        Assertions.assertEquals((int)1, (int)handler.releasedCount());
        sc.close().syncUninterruptibly();
        channel2.close().syncUninterruptibly();
        pool.close();
    }

    @Test
    public void testAcquireTimeout() throws Exception {
        FixedChannelPoolTest.testAcquireTimeout(500L);
    }

    @Test
    public void testAcquireWithZeroTimeout() throws Exception {
        FixedChannelPoolTest.testAcquireTimeout(0L);
    }

    private static void testAcquireTimeout(long timeoutMillis) throws Exception {
        LocalAddress addr = new LocalAddress(ChannelPoolTestUtils.getLocalAddrId());
        Bootstrap cb = new Bootstrap();
        cb.remoteAddress((SocketAddress)addr);
        ((Bootstrap)cb.group(group)).channel(LocalChannel.class);
        ServerBootstrap sb = new ServerBootstrap();
        ((ServerBootstrap)sb.group(group).channel(LocalServerChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<LocalChannel>(){

            public void initChannel(LocalChannel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter()});
            }
        });
        Channel sc = sb.bind((SocketAddress)addr).syncUninterruptibly().channel();
        TestChannelPoolHandler handler = new TestChannelPoolHandler();
        FixedChannelPool pool = new FixedChannelPool(cb, (ChannelPoolHandler)handler, ChannelHealthChecker.ACTIVE, FixedChannelPool.AcquireTimeoutAction.FAIL, timeoutMillis, 1, Integer.MAX_VALUE);
        Channel channel = (Channel)pool.acquire().syncUninterruptibly().getNow();
        final Future future = pool.acquire();
        Assertions.assertThrows(TimeoutException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                future.syncUninterruptibly();
            }
        });
        sc.close().syncUninterruptibly();
        channel.close().syncUninterruptibly();
        pool.close();
    }

    @Test
    public void testAcquireNewConnection() throws Exception {
        LocalAddress addr = new LocalAddress(ChannelPoolTestUtils.getLocalAddrId());
        Bootstrap cb = new Bootstrap();
        cb.remoteAddress((SocketAddress)addr);
        ((Bootstrap)cb.group(group)).channel(LocalChannel.class);
        ServerBootstrap sb = new ServerBootstrap();
        ((ServerBootstrap)sb.group(group).channel(LocalServerChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<LocalChannel>(){

            public void initChannel(LocalChannel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter()});
            }
        });
        Channel sc = sb.bind((SocketAddress)addr).syncUninterruptibly().channel();
        TestChannelPoolHandler handler = new TestChannelPoolHandler();
        FixedChannelPool pool = new FixedChannelPool(cb, (ChannelPoolHandler)handler, ChannelHealthChecker.ACTIVE, FixedChannelPool.AcquireTimeoutAction.NEW, 500L, 1, Integer.MAX_VALUE);
        Channel channel = (Channel)pool.acquire().syncUninterruptibly().getNow();
        Channel channel2 = (Channel)pool.acquire().syncUninterruptibly().getNow();
        Assertions.assertNotSame((Object)channel, (Object)channel2);
        sc.close().syncUninterruptibly();
        channel.close().syncUninterruptibly();
        channel2.close().syncUninterruptibly();
        pool.close();
    }

    @Test
    public void testAcquireNewConnectionWhen() throws Exception {
        LocalAddress addr = new LocalAddress(ChannelPoolTestUtils.getLocalAddrId());
        Bootstrap cb = new Bootstrap();
        cb.remoteAddress((SocketAddress)addr);
        ((Bootstrap)cb.group(group)).channel(LocalChannel.class);
        ServerBootstrap sb = new ServerBootstrap();
        ((ServerBootstrap)sb.group(group).channel(LocalServerChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<LocalChannel>(){

            public void initChannel(LocalChannel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter()});
            }
        });
        Channel sc = sb.bind((SocketAddress)addr).syncUninterruptibly().channel();
        TestChannelPoolHandler handler = new TestChannelPoolHandler();
        FixedChannelPool pool = new FixedChannelPool(cb, (ChannelPoolHandler)handler, 1);
        Channel channel1 = (Channel)pool.acquire().syncUninterruptibly().getNow();
        channel1.close().syncUninterruptibly();
        pool.release(channel1);
        Channel channel2 = (Channel)pool.acquire().syncUninterruptibly().getNow();
        Assertions.assertNotSame((Object)channel1, (Object)channel2);
        sc.close().syncUninterruptibly();
        channel2.close().syncUninterruptibly();
        pool.close();
    }

    @Test
    public void testAcquireBoundQueue() throws Exception {
        LocalAddress addr = new LocalAddress(ChannelPoolTestUtils.getLocalAddrId());
        Bootstrap cb = new Bootstrap();
        cb.remoteAddress((SocketAddress)addr);
        ((Bootstrap)cb.group(group)).channel(LocalChannel.class);
        ServerBootstrap sb = new ServerBootstrap();
        ((ServerBootstrap)sb.group(group).channel(LocalServerChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<LocalChannel>(){

            public void initChannel(LocalChannel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter()});
            }
        });
        Channel sc = sb.bind((SocketAddress)addr).syncUninterruptibly().channel();
        TestChannelPoolHandler handler = new TestChannelPoolHandler();
        FixedChannelPool pool = new FixedChannelPool(cb, (ChannelPoolHandler)handler, 1, 1);
        Channel channel = (Channel)pool.acquire().syncUninterruptibly().getNow();
        Future future = pool.acquire();
        Assertions.assertFalse((boolean)future.isDone());
        Assertions.assertThrows(IllegalStateException.class, (Executable)new Executable((ChannelPool)pool){
            final /* synthetic */ ChannelPool val$pool;
            {
                this.val$pool = channelPool;
            }

            public void execute() throws Throwable {
                this.val$pool.acquire().syncUninterruptibly();
            }
        });
        sc.close().syncUninterruptibly();
        channel.close().syncUninterruptibly();
        pool.close();
    }

    @Test
    public void testReleaseDifferentPool() throws Exception {
        LocalAddress addr = new LocalAddress(ChannelPoolTestUtils.getLocalAddrId());
        Bootstrap cb = new Bootstrap();
        cb.remoteAddress((SocketAddress)addr);
        ((Bootstrap)cb.group(group)).channel(LocalChannel.class);
        ServerBootstrap sb = new ServerBootstrap();
        ((ServerBootstrap)sb.group(group).channel(LocalServerChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<LocalChannel>(){

            public void initChannel(LocalChannel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter()});
            }
        });
        Channel sc = sb.bind((SocketAddress)addr).syncUninterruptibly().channel();
        TestChannelPoolHandler handler = new TestChannelPoolHandler();
        FixedChannelPool pool = new FixedChannelPool(cb, (ChannelPoolHandler)handler, 1, 1);
        FixedChannelPool pool2 = new FixedChannelPool(cb, (ChannelPoolHandler)handler, 1, 1);
        Channel channel = (Channel)pool.acquire().syncUninterruptibly().getNow();
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable((ChannelPool)pool2, channel){
            final /* synthetic */ ChannelPool val$pool2;
            final /* synthetic */ Channel val$channel;
            {
                this.val$pool2 = channelPool;
                this.val$channel = channel;
            }

            public void execute() throws Throwable {
                this.val$pool2.release(this.val$channel).syncUninterruptibly();
            }
        });
        sc.close().syncUninterruptibly();
        channel.close().syncUninterruptibly();
        pool.close();
        pool2.close();
    }

    @Test
    public void testReleaseAfterClosePool() throws Exception {
        LocalAddress addr = new LocalAddress(ChannelPoolTestUtils.getLocalAddrId());
        Bootstrap cb = new Bootstrap();
        cb.remoteAddress((SocketAddress)addr);
        ((Bootstrap)cb.group(group)).channel(LocalChannel.class);
        ServerBootstrap sb = new ServerBootstrap();
        ((ServerBootstrap)sb.group(group).channel(LocalServerChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<LocalChannel>(){

            public void initChannel(LocalChannel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter()});
            }
        });
        Channel sc = sb.bind((SocketAddress)addr).syncUninterruptibly().channel();
        final FixedChannelPool pool = new FixedChannelPool(cb, (ChannelPoolHandler)new TestChannelPoolHandler(), 2);
        Future acquire = pool.acquire();
        final Channel channel = (Channel)acquire.get();
        pool.close();
        group.submit(new Runnable(){

            @Override
            public void run() {
            }
        }).syncUninterruptibly();
        Assertions.assertThrows(IllegalStateException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                pool.release(channel).syncUninterruptibly();
            }
        });
        channel.closeFuture().syncUninterruptibly();
        Assertions.assertFalse((boolean)channel.isOpen());
        sc.close().syncUninterruptibly();
        pool.close();
    }

    @Test
    public void testReleaseClosed() {
        LocalAddress addr = new LocalAddress(ChannelPoolTestUtils.getLocalAddrId());
        Bootstrap cb = new Bootstrap();
        cb.remoteAddress((SocketAddress)addr);
        ((Bootstrap)cb.group(group)).channel(LocalChannel.class);
        ServerBootstrap sb = new ServerBootstrap();
        ((ServerBootstrap)sb.group(group).channel(LocalServerChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<LocalChannel>(){

            public void initChannel(LocalChannel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter()});
            }
        });
        Channel sc = sb.bind((SocketAddress)addr).syncUninterruptibly().channel();
        FixedChannelPool pool = new FixedChannelPool(cb, (ChannelPoolHandler)new TestChannelPoolHandler(), 2);
        Channel channel = (Channel)pool.acquire().syncUninterruptibly().getNow();
        channel.close().syncUninterruptibly();
        pool.release(channel).syncUninterruptibly();
        sc.close().syncUninterruptibly();
        pool.close();
    }

    @Test
    public void testCloseAsync() throws ExecutionException, InterruptedException {
        LocalAddress addr = new LocalAddress(ChannelPoolTestUtils.getLocalAddrId());
        Bootstrap cb = new Bootstrap();
        cb.remoteAddress((SocketAddress)addr);
        ((Bootstrap)cb.group(group)).channel(LocalChannel.class);
        ServerBootstrap sb = new ServerBootstrap();
        ((ServerBootstrap)sb.group(group).channel(LocalServerChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<LocalChannel>(){

            public void initChannel(LocalChannel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter()});
            }
        });
        final Channel sc = sb.bind((SocketAddress)addr).syncUninterruptibly().channel();
        final FixedChannelPool pool = new FixedChannelPool(cb, (ChannelPoolHandler)new TestChannelPoolHandler(), 2);
        pool.acquire().get();
        pool.acquire().get();
        final ChannelPromise closePromise = sc.newPromise();
        pool.closeAsync().addListener((GenericFutureListener)new GenericFutureListener<Future<? super Void>>(){

            public void operationComplete(Future<? super Void> future) throws Exception {
                Assertions.assertEquals((int)0, (int)pool.acquiredChannelCount());
                sc.close(closePromise).syncUninterruptibly();
            }
        }).awaitUninterruptibly();
        closePromise.awaitUninterruptibly();
    }

    @Test
    public void testChannelAcquiredException() throws InterruptedException {
        LocalAddress addr = new LocalAddress(ChannelPoolTestUtils.getLocalAddrId());
        Bootstrap cb = new Bootstrap();
        cb.remoteAddress((SocketAddress)addr);
        ((Bootstrap)cb.group(group)).channel(LocalChannel.class);
        ServerBootstrap sb = new ServerBootstrap();
        ((ServerBootstrap)sb.group(group).channel(LocalServerChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<LocalChannel>(){

            public void initChannel(LocalChannel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter()});
            }
        });
        Channel sc = sb.bind((SocketAddress)addr).syncUninterruptibly().channel();
        final NullPointerException exception = new NullPointerException();
        FixedChannelPool pool = new FixedChannelPool(cb, new ChannelPoolHandler(){

            public void channelReleased(Channel ch) {
            }

            public void channelAcquired(Channel ch) {
                throw exception;
            }

            public void channelCreated(Channel ch) {
            }
        }, 2);
        try {
            pool.acquire().sync();
        }
        catch (NullPointerException e) {
            Assertions.assertSame((Object)e, (Object)exception);
        }
        sc.close().sync();
        pool.close();
    }

    private static final class TestChannelPoolHandler
    extends AbstractChannelPoolHandler {
        private TestChannelPoolHandler() {
        }

        public void channelCreated(Channel ch) throws Exception {
        }
    }
}

