/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.pool;

import io.netty.channel.Channel;
import io.netty.channel.pool.ChannelPoolHandler;
import java.util.concurrent.atomic.AtomicInteger;

final class CountingChannelPoolHandler
implements ChannelPoolHandler {
    private final AtomicInteger channelCount = new AtomicInteger(0);
    private final AtomicInteger acquiredCount = new AtomicInteger(0);
    private final AtomicInteger releasedCount = new AtomicInteger(0);

    CountingChannelPoolHandler() {
    }

    public void channelCreated(Channel ch) {
        this.channelCount.incrementAndGet();
    }

    public void channelReleased(Channel ch) {
        this.releasedCount.incrementAndGet();
    }

    public void channelAcquired(Channel ch) {
        this.acquiredCount.incrementAndGet();
    }

    public int channelCount() {
        return this.channelCount.get();
    }

    public int acquiredCount() {
        return this.acquiredCount.get();
    }

    public int releasedCount() {
        return this.releasedCount.get();
    }
}

