/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.LoggingHandler;
import io.netty.channel.ServerChannel;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

public abstract class AbstractEventLoopTest {
    @Test
    public void testReregister() {
        EventLoopGroup group = this.newEventLoopGroup();
        EventLoopGroup group2 = this.newEventLoopGroup();
        DefaultEventExecutorGroup eventExecutorGroup = new DefaultEventExecutorGroup(2);
        ServerBootstrap bootstrap = new ServerBootstrap();
        ChannelFuture future = ((ServerBootstrap)((ServerBootstrap)bootstrap.channel(this.newChannel())).group(group).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) {
            }
        }).handler((ChannelHandler)new ChannelInitializer<ServerSocketChannel>((EventExecutorGroup)eventExecutorGroup){
            final /* synthetic */ EventExecutorGroup val$eventExecutorGroup;
            {
                this.val$eventExecutorGroup = eventExecutorGroup;
            }

            public void initChannel(ServerSocketChannel ch) {
                ch.pipeline().addLast(new ChannelHandler[]{new TestChannelHandler()});
                ch.pipeline().addLast(this.val$eventExecutorGroup, new ChannelHandler[]{new TestChannelHandler2()});
            }
        })).bind(0).awaitUninterruptibly();
        EventExecutor executor = future.channel().pipeline().context(TestChannelHandler2.class).executor();
        EventExecutor executor1 = future.channel().pipeline().context(TestChannelHandler.class).executor();
        future.channel().deregister().awaitUninterruptibly();
        Channel channel = group2.register(future.channel()).awaitUninterruptibly().channel();
        EventExecutor executorNew = channel.pipeline().context(TestChannelHandler.class).executor();
        Assertions.assertNotSame((Object)executor1, (Object)executorNew);
        Assertions.assertSame((Object)executor, (Object)future.channel().pipeline().context(TestChannelHandler2.class).executor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @EnumSource(value=DeregisterMethod.class)
    void testReregisterOnChannelHandlerContext(DeregisterMethod method) throws Exception {
        EventLoopGroup group = this.newEventLoopGroup();
        final AtomicReference<Throwable> throwable = new AtomicReference<Throwable>();
        try {
            ServerBootstrap b = new ServerBootstrap();
            final ReRegisterHandler reRegisterHandler = new ReRegisterHandler(group, method, throwable);
            ((ServerBootstrap)b.group(group).channel(this.newChannel())).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel ch) {
                    ChannelPipeline p = ch.pipeline();
                    p.addLast("logging", (ChannelHandler)new LoggingHandler());
                    p.addLast(new ChannelHandler[]{reRegisterHandler});
                }
            });
            ChannelFuture f = b.bind(0).sync();
            Channel client = ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(group)).channel(this.newSocketChannel())).handler((ChannelHandler)new ChannelInboundHandlerAdapter(){

                public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                    ReferenceCountUtil.release((Object)msg);
                }

                public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
                    super.channelReadComplete(ctx);
                    ctx.close();
                }

                public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                    throwable.set(cause);
                    super.exceptionCaught(ctx, cause);
                    ctx.close();
                }
            })).connect(f.channel().localAddress()).sync().channel();
            client.closeFuture().addListener(ignore -> f.channel().close());
            client.writeAndFlush((Object)Unpooled.copiedBuffer((CharSequence)"hello", (Charset)StandardCharsets.US_ASCII));
            f.channel().closeFuture().sync();
            Throwable caughtThrowable = throwable.get();
            if (caughtThrowable != null) {
                Assertions.fail((Throwable)caughtThrowable);
            }
        }
        finally {
            group.shutdownGracefully();
        }
    }

    @Test
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void testShutdownGracefullyNoQuietPeriod() throws Exception {
        EventLoopGroup loop = this.newEventLoopGroup();
        ServerBootstrap b = new ServerBootstrap();
        ((ServerBootstrap)b.group(loop).channel(this.newChannel())).childHandler((ChannelHandler)new ChannelInboundHandlerAdapter());
        b.bind(0).sync().channel();
        Future f = loop.shutdownGracefully(0L, 1L, TimeUnit.MINUTES);
        Assertions.assertTrue((boolean)loop.awaitTermination(600L, TimeUnit.MILLISECONDS));
        Assertions.assertTrue((boolean)f.syncUninterruptibly().isSuccess());
        Assertions.assertTrue((boolean)loop.isShutdown());
        Assertions.assertTrue((boolean)loop.isTerminated());
    }

    protected abstract EventLoopGroup newEventLoopGroup();

    protected abstract Class<? extends ServerChannel> newChannel();

    protected abstract Class<? extends SocketChannel> newSocketChannel();

    private static final class TestChannelHandler2
    extends ChannelDuplexHandler {
        private TestChannelHandler2() {
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        }
    }

    private static final class TestChannelHandler
    extends ChannelDuplexHandler {
        private TestChannelHandler() {
        }
    }

    @ChannelHandler.Sharable
    static class ReRegisterHandler
    extends ChannelInboundHandlerAdapter {
        final EventLoopGroup eventLoopGroup;
        private final DeregisterMethod method;
        private final AtomicReference<Throwable> throwable;

        ReRegisterHandler(EventLoopGroup eventLoopGroup, DeregisterMethod method, AtomicReference<Throwable> throwable) {
            this.eventLoopGroup = eventLoopGroup;
            this.method = method;
            this.throwable = throwable;
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            super.exceptionCaught(ctx, cause);
            this.throwable.set(cause);
            ctx.close();
        }

        public void channelRead(final ChannelHandlerContext outCtx, Object msg) throws Exception {
            EventLoop newLoop = this.anyNotEqual(outCtx.channel().eventLoop());
            ChannelFutureListener pipelieModifyingListener = register -> {
                outCtx.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void channelRead(ChannelHandlerContext inCtx, Object inMsg) {
                        outCtx.writeAndFlush(inMsg);
                    }
                }});
                outCtx.fireChannelRead(msg);
            };
            ChannelFutureListener reregisteringListener = deregister -> {
                deregister.channel().pipeline().fireUserEventTriggered((Object)"Unregistered user event");
                newLoop.register(deregister.channel()).addListener((GenericFutureListener)pipelieModifyingListener);
            };
            ((ChannelFuture)this.method.apply(outCtx)).addListener((GenericFutureListener)reregisteringListener);
        }

        private EventLoop anyNotEqual(EventLoop eventLoop) {
            EventLoop next;
            while (eventLoop == (next = this.eventLoopGroup.next())) {
            }
            return next;
        }
    }

    static enum DeregisterMethod implements Function<ChannelHandlerContext, ChannelFuture>
    {
        CONTEXT{

            @Override
            public ChannelFuture apply(ChannelHandlerContext ctx) {
                return ctx.deregister();
            }
        }
        ,
        CONTEXT_PROMISE{

            @Override
            public ChannelFuture apply(ChannelHandlerContext ctx) {
                return ctx.deregister(ctx.newPromise());
            }
        }
        ,
        CHANNEL{

            @Override
            public ChannelFuture apply(ChannelHandlerContext ctx) {
                return ctx.channel().deregister();
            }
        }
        ,
        CHANNEL_PROMISE{

            @Override
            public ChannelFuture apply(ChannelHandlerContext ctx) {
                return ctx.channel().deregister(ctx.channel().newPromise());
            }
        };

    }
}

