/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.channel.DefaultFileRegion;
import io.netty.channel.FileRegion;
import io.netty.util.internal.PlatformDependent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.ThreadLocalRandom;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultFileRegionTest {
    private static final byte[] data = new byte[0xA00000];

    private static File newFile() throws IOException {
        File file = PlatformDependent.createTempFile((String)"netty-", (String)".tmp", null);
        file.deleteOnExit();
        FileOutputStream out = new FileOutputStream(file);
        out.write(data);
        out.close();
        return file;
    }

    @Test
    public void testCreateFromFile() throws IOException {
        File file = DefaultFileRegionTest.newFile();
        try {
            DefaultFileRegionTest.testFileRegion((FileRegion)new DefaultFileRegion(file, 0L, (long)data.length));
        }
        finally {
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateFromFileChannel() throws IOException {
        File file = DefaultFileRegionTest.newFile();
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");){
            DefaultFileRegionTest.testFileRegion((FileRegion)new DefaultFileRegion(randomAccessFile.getChannel(), 0L, (long)data.length));
        }
        finally {
            file.delete();
        }
    }

    private static void testFileRegion(FileRegion region) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try (WritableByteChannel channel = Channels.newChannel(outputStream);){
            Assertions.assertEquals((long)data.length, (long)region.count());
            Assertions.assertEquals((long)0L, (long)region.transferred());
            Assertions.assertEquals((long)data.length, (long)region.transferTo(channel, 0L));
            Assertions.assertEquals((long)data.length, (long)region.count());
            Assertions.assertEquals((long)data.length, (long)region.transferred());
            Assertions.assertArrayEquals((byte[])data, (byte[])outputStream.toByteArray());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTruncated() throws IOException {
        File file = DefaultFileRegionTest.newFile();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try (WritableByteChannel channel = Channels.newChannel(outputStream);
             RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");){
            DefaultFileRegion region = new DefaultFileRegion(randomAccessFile.getChannel(), 0L, (long)data.length);
            randomAccessFile.getChannel().truncate(data.length - 1024);
            Assertions.assertEquals((long)data.length, (long)region.count());
            Assertions.assertEquals((long)0L, (long)region.transferred());
            Assertions.assertEquals((long)(data.length - 1024), (long)region.transferTo(channel, 0L));
            Assertions.assertEquals((long)data.length, (long)region.count());
            Assertions.assertEquals((long)(data.length - 1024), (long)region.transferred());
            try {
                region.transferTo(channel, (long)(data.length - 1024));
                Assertions.fail();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        finally {
            file.delete();
        }
    }

    static {
        ThreadLocalRandom.current().nextBytes(data);
    }
}

