/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerAdapter;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.channel.PendingWriteQueue;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PendingWriteQueueTest {
    @Test
    public void testRemoveAndWrite() {
        PendingWriteQueueTest.assertWrite((ChannelHandler)new TestHandler(){

            public void flush(ChannelHandlerContext ctx) throws Exception {
                Assertions.assertFalse((boolean)ctx.channel().isWritable(), (String)"Should not be writable anymore");
                ChannelFuture future = this.queue.removeAndWrite();
                future.addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) {
                        PendingWriteQueueTest.assertQueueEmpty(queue);
                    }
                });
                super.flush(ctx);
            }
        }, 1);
    }

    @Test
    public void testRemoveAndWriteAll() {
        PendingWriteQueueTest.assertWrite((ChannelHandler)new TestHandler(){

            public void flush(ChannelHandlerContext ctx) throws Exception {
                Assertions.assertFalse((boolean)ctx.channel().isWritable(), (String)"Should not be writable anymore");
                ChannelFuture future = this.queue.removeAndWriteAll();
                future.addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) {
                        PendingWriteQueueTest.assertQueueEmpty(queue);
                    }
                });
                super.flush(ctx);
            }
        }, 3);
    }

    @Test
    public void testRemoveAndFail() {
        PendingWriteQueueTest.assertWriteFails((ChannelHandler)new TestHandler(){

            public void flush(ChannelHandlerContext ctx) throws Exception {
                this.queue.removeAndFail((Throwable)new TestException());
                super.flush(ctx);
            }
        }, 1);
    }

    @Test
    public void testRemoveAndFailAll() {
        PendingWriteQueueTest.assertWriteFails((ChannelHandler)new TestHandler(){

            public void flush(ChannelHandlerContext ctx) throws Exception {
                this.queue.removeAndFailAll((Throwable)new TestException());
                super.flush(ctx);
            }
        }, 3);
    }

    @Test
    public void shouldFireChannelWritabilityChangedAfterRemoval() {
        final AtomicReference ctxRef = new AtomicReference();
        final AtomicReference queueRef = new AtomicReference();
        ByteBuf msg = Unpooled.copiedBuffer((CharSequence)"test", (Charset)CharsetUtil.US_ASCII);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

            public void handlerAdded(ChannelHandlerContext ctx) {
                ctxRef.set(ctx);
                queueRef.set(new PendingWriteQueue(ctx));
            }

            public void channelWritabilityChanged(ChannelHandlerContext ctx) {
                PendingWriteQueue queue = (PendingWriteQueue)queueRef.get();
                ByteBuf msg = (ByteBuf)queue.current();
                if (msg == null) {
                    return;
                }
                Assertions.assertEquals((int)1, (int)msg.refCnt());
                queue.remove();
                Assertions.assertEquals((int)0, (int)msg.refCnt());
            }
        }});
        channel.config().setWriteBufferLowWaterMark(1);
        channel.config().setWriteBufferHighWaterMark(3);
        PendingWriteQueue queue = (PendingWriteQueue)queueRef.get();
        queue.add((Object)msg, channel.newPromise());
        channel.finish();
        Assertions.assertEquals((int)0, (int)msg.refCnt());
    }

    private static void assertWrite(ChannelHandler handler, int count) {
        int i;
        ByteBuf buffer = Unpooled.copiedBuffer((CharSequence)"Test", (Charset)CharsetUtil.US_ASCII);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{handler});
        channel.config().setWriteBufferLowWaterMark(1);
        channel.config().setWriteBufferHighWaterMark(3);
        Object[] buffers = new ByteBuf[count];
        for (i = 0; i < buffers.length; ++i) {
            buffers[i] = buffer.retainedDuplicate();
        }
        Assertions.assertTrue((boolean)channel.writeOutbound(buffers));
        Assertions.assertTrue((boolean)channel.finish());
        channel.closeFuture().syncUninterruptibly();
        for (i = 0; i < buffers.length; ++i) {
            PendingWriteQueueTest.assertBuffer(channel, buffer);
        }
        buffer.release();
        Assertions.assertNull((Object)channel.readOutbound());
    }

    private static void assertBuffer(EmbeddedChannel channel, ByteBuf buffer) {
        ByteBuf written = (ByteBuf)channel.readOutbound();
        Assertions.assertEquals((Object)buffer, (Object)written);
        written.release();
    }

    private static void assertQueueEmpty(PendingWriteQueue queue) {
        Assertions.assertTrue((boolean)queue.isEmpty());
        Assertions.assertEquals((int)0, (int)queue.size());
        Assertions.assertEquals((long)0L, (long)queue.bytes());
        Assertions.assertNull((Object)queue.current());
        Assertions.assertNull((Object)queue.removeAndWrite());
        Assertions.assertNull((Object)queue.removeAndWriteAll());
    }

    private static void assertWriteFails(ChannelHandler handler, int count) {
        ByteBuf buffer = Unpooled.copiedBuffer((CharSequence)"Test", (Charset)CharsetUtil.US_ASCII);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{handler});
        Object[] buffers = new ByteBuf[count];
        for (int i = 0; i < buffers.length; ++i) {
            buffers[i] = buffer.retainedDuplicate();
        }
        try {
            Assertions.assertFalse((boolean)channel.writeOutbound(buffers));
            Assertions.fail();
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)(e instanceof TestException));
        }
        Assertions.assertFalse((boolean)channel.finish());
        channel.closeFuture().syncUninterruptibly();
        buffer.release();
        Assertions.assertNull((Object)channel.readOutbound());
    }

    private static EmbeddedChannel newChannel() {
        return new EmbeddedChannel(new ChannelHandler[]{new ChannelHandlerAdapter(){}});
    }

    @Test
    public void testRemoveAndFailAllReentrantFailAll() {
        EmbeddedChannel channel = PendingWriteQueueTest.newChannel();
        final PendingWriteQueue queue = new PendingWriteQueue(channel.pipeline().firstContext());
        ChannelPromise promise = channel.newPromise();
        promise.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) {
                queue.removeAndFailAll((Throwable)new IllegalStateException());
            }
        });
        queue.add((Object)1L, promise);
        ChannelPromise promise2 = channel.newPromise();
        queue.add((Object)2L, promise2);
        queue.removeAndFailAll((Throwable)new Exception());
        Assertions.assertTrue((boolean)promise.isDone());
        Assertions.assertFalse((boolean)promise.isSuccess());
        Assertions.assertTrue((boolean)promise2.isDone());
        Assertions.assertFalse((boolean)promise2.isSuccess());
        Assertions.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testRemoveAndWriteAllReentrantWrite() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ChannelOutboundHandlerAdapter(){

            public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
                ctx.writeAndFlush(msg, promise);
            }
        }, new ChannelOutboundHandlerAdapter()});
        final PendingWriteQueue queue = new PendingWriteQueue(channel.pipeline().lastContext());
        ChannelPromise promise = channel.newPromise();
        final ChannelPromise promise3 = channel.newPromise();
        promise.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) {
                queue.add((Object)3L, promise3);
            }
        });
        queue.add((Object)1L, promise);
        ChannelPromise promise2 = channel.newPromise();
        queue.add((Object)2L, promise2);
        queue.removeAndWriteAll();
        Assertions.assertTrue((boolean)promise.isDone());
        Assertions.assertTrue((boolean)promise.isSuccess());
        Assertions.assertTrue((boolean)promise2.isDone());
        Assertions.assertTrue((boolean)promise2.isSuccess());
        Assertions.assertTrue((boolean)promise3.isDone());
        Assertions.assertTrue((boolean)promise3.isSuccess());
        Assertions.assertTrue((boolean)channel.finish());
        Assertions.assertEquals((long)1L, (Long)((Long)channel.readOutbound()));
        Assertions.assertEquals((long)2L, (Long)((Long)channel.readOutbound()));
        Assertions.assertEquals((long)3L, (Long)((Long)channel.readOutbound()));
    }

    @Test
    public void testRemoveAndWriteAllWithVoidPromise() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ChannelOutboundHandlerAdapter(){

            public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
                ctx.writeAndFlush(msg, promise);
            }
        }, new ChannelOutboundHandlerAdapter()});
        PendingWriteQueue queue = new PendingWriteQueue(channel.pipeline().lastContext());
        ChannelPromise promise = channel.newPromise();
        queue.add((Object)1L, promise);
        queue.add((Object)2L, channel.voidPromise());
        queue.removeAndWriteAll();
        Assertions.assertTrue((boolean)channel.finish());
        Assertions.assertTrue((boolean)promise.isDone());
        Assertions.assertTrue((boolean)promise.isSuccess());
        Assertions.assertEquals((long)1L, (Long)((Long)channel.readOutbound()));
        Assertions.assertEquals((long)2L, (Long)((Long)channel.readOutbound()));
    }

    @Test
    public void testRemoveAndFailAllReentrantWrite() {
        final List failOrder = Collections.synchronizedList(new ArrayList());
        EmbeddedChannel channel = PendingWriteQueueTest.newChannel();
        final PendingWriteQueue queue = new PendingWriteQueue(channel.pipeline().firstContext());
        ChannelPromise promise = channel.newPromise();
        final ChannelPromise promise3 = channel.newPromise();
        promise3.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) {
                failOrder.add(3);
            }
        });
        promise.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) {
                failOrder.add(1);
                queue.add((Object)3L, promise3);
            }
        });
        queue.add((Object)1L, promise);
        ChannelPromise promise2 = channel.newPromise();
        promise2.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) {
                failOrder.add(2);
            }
        });
        queue.add((Object)2L, promise2);
        queue.removeAndFailAll((Throwable)new Exception());
        Assertions.assertTrue((boolean)promise.isDone());
        Assertions.assertFalse((boolean)promise.isSuccess());
        Assertions.assertTrue((boolean)promise2.isDone());
        Assertions.assertFalse((boolean)promise2.isSuccess());
        Assertions.assertTrue((boolean)promise3.isDone());
        Assertions.assertFalse((boolean)promise3.isSuccess());
        Assertions.assertFalse((boolean)channel.finish());
        Assertions.assertEquals((int)1, (int)((Integer)failOrder.get(0)));
        Assertions.assertEquals((int)2, (int)((Integer)failOrder.get(1)));
        Assertions.assertEquals((int)3, (int)((Integer)failOrder.get(2)));
    }

    @Test
    public void testRemoveAndWriteAllReentrance() {
        EmbeddedChannel channel = PendingWriteQueueTest.newChannel();
        final PendingWriteQueue queue = new PendingWriteQueue(channel.pipeline().firstContext());
        ChannelPromise promise = channel.newPromise();
        promise.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) {
                queue.removeAndWriteAll();
            }
        });
        queue.add((Object)1L, promise);
        ChannelPromise promise2 = channel.newPromise();
        queue.add((Object)2L, promise2);
        queue.removeAndWriteAll();
        channel.flush();
        Assertions.assertTrue((boolean)promise.isSuccess());
        Assertions.assertTrue((boolean)promise2.isSuccess());
        Assertions.assertTrue((boolean)channel.finish());
        Assertions.assertEquals((long)1L, (Long)((Long)channel.readOutbound()));
        Assertions.assertEquals((long)2L, (Long)((Long)channel.readOutbound()));
        Assertions.assertNull((Object)channel.readOutbound());
        Assertions.assertNull((Object)channel.readInbound());
    }

    @Test
    public void testCloseChannelOnCreation() {
        EmbeddedChannel channel = PendingWriteQueueTest.newChannel();
        ChannelHandlerContext context = channel.pipeline().firstContext();
        channel.close().syncUninterruptibly();
        PendingWriteQueue queue = new PendingWriteQueue(context);
        IllegalStateException ex = new IllegalStateException();
        ChannelPromise promise = channel.newPromise();
        queue.add((Object)1L, promise);
        queue.removeAndFailAll((Throwable)ex);
        Assertions.assertSame((Object)ex, (Object)promise.cause());
    }

    private static final class TestException
    extends Exception {
        private static final long serialVersionUID = -9018570103039458401L;

        private TestException() {
        }
    }

    private static class TestHandler
    extends ChannelDuplexHandler {
        protected PendingWriteQueue queue;
        private int expectedSize;

        private TestHandler() {
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            super.channelActive(ctx);
            PendingWriteQueueTest.assertQueueEmpty(this.queue);
            Assertions.assertTrue((boolean)ctx.channel().isWritable(), (String)"Should be writable");
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            this.queue.add(msg, promise);
            Assertions.assertFalse((boolean)this.queue.isEmpty());
            Assertions.assertEquals((int)(++this.expectedSize), (int)this.queue.size());
            Assertions.assertNotNull((Object)this.queue.current());
        }

        public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
            this.queue = new PendingWriteQueue(ctx);
        }
    }
}

