/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.channel.IoEvent;
import io.netty.channel.IoHandle;
import io.netty.channel.IoHandler;
import io.netty.channel.IoHandlerContext;
import io.netty.channel.IoOps;
import io.netty.channel.IoRegistration;
import io.netty.channel.SingleThreadIoEventLoop;
import io.netty.util.concurrent.ThreadAwareExecutor;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class SingleThreadIoEventLoopTest {
    @Test
    void testIsIoType() {
        SingleThreadIoEventLoop group = new SingleThreadIoEventLoop(null, Executors.defaultThreadFactory(), TestIoHandler::new);
        Assertions.assertTrue((boolean)group.isIoType(TestIoHandler.class));
        class TestIoHandler2
        extends TestIoHandler {
            TestIoHandler2(ThreadAwareExecutor executor) {
                super(executor);
            }
        }
        Assertions.assertFalse((boolean)group.isIoType(TestIoHandler2.class));
        group.shutdownGracefully();
    }

    @Test
    void testIsCompatible() {
        TestIoHandle handle = new TestIoHandle(){};
        SingleThreadIoEventLoop group = new SingleThreadIoEventLoop(null, Executors.defaultThreadFactory(), CompatibleTestIoHandler::new);
        Assertions.assertTrue((boolean)group.isCompatible(TestIoHandle.class));
        Assertions.assertFalse((boolean)group.isCompatible(handle.getClass()));
        group.shutdownGracefully();
    }

    @Disabled(value="This test is flaky and will often stall the build")
    @Test
    void testSuspendingWhileRegistrationActive() throws Exception {
        TestThreadFactory threadFactory = new TestThreadFactory();
        SingleThreadIoEventLoop loop = new SingleThreadIoEventLoop(null, (ThreadFactory)threadFactory, eventLoop -> new TestIoHandler(eventLoop){

            @Override
            public boolean isCompatible(Class<? extends IoHandle> handleType) {
                return true;
            }
        });
        Assertions.assertFalse((boolean)loop.isSuspended());
        IoRegistration registration = (IoRegistration)loop.register((IoHandle)new TestIoHandle()).sync().getNow();
        Thread currentThread = threadFactory.threads.take();
        Assertions.assertTrue((boolean)currentThread.isAlive());
        Assertions.assertTrue((boolean)loop.trySuspend());
        Assertions.assertTrue((boolean)currentThread.isAlive());
        registration.cancel();
        Assertions.assertFalse((boolean)registration.isValid());
        currentThread.join();
        Assertions.assertTrue((boolean)threadFactory.threads.isEmpty());
        loop.shutdownGracefully();
    }

    private static class TestIoHandle
    implements IoHandle {
        private TestIoHandle() {
        }

        public void handle(IoRegistration registration, IoEvent readyOps) {
        }

        public void close() {
        }
    }

    private static class TestIoHandler
    implements IoHandler {
        private final Semaphore semaphore = new Semaphore(0);
        private final ThreadAwareExecutor executor;

        TestIoHandler(ThreadAwareExecutor executor) {
            this.executor = executor;
        }

        public void prepareToDestroy() {
        }

        public void destroy() {
        }

        public IoRegistration register(IoHandle handle) {
            return new IoRegistration(){
                private final AtomicBoolean canceled = new AtomicBoolean();

                public <T> T attachment() {
                    return null;
                }

                public long submit(IoOps ops) {
                    return 0L;
                }

                public boolean cancel() {
                    return this.canceled.compareAndSet(false, true);
                }

                public boolean isValid() {
                    return !this.canceled.get();
                }
            };
        }

        public void wakeup() {
            this.semaphore.release();
        }

        public int run(IoHandlerContext context) {
            try {
                this.semaphore.acquire();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            return 0;
        }

        public boolean isCompatible(Class<? extends IoHandle> handleType) {
            return false;
        }
    }

    private static final class TestThreadFactory
    implements ThreadFactory {
        final LinkedBlockingQueue<Thread> threads = new LinkedBlockingQueue();

        private TestThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            this.threads.add(thread);
            return thread;
        }
    }

    static final class CompatibleTestIoHandler
    extends TestIoHandler {
        CompatibleTestIoHandler(ThreadAwareExecutor executor) {
            super(executor);
        }

        @Override
        public boolean isCompatible(Class<? extends IoHandle> handleType) {
            return handleType.equals(TestIoHandle.class);
        }
    }
}

