/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.AdaptiveRecvByteBufAllocator;
import io.netty.channel.ChannelConfig;
import io.netty.channel.RecvByteBufAllocator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.mockito.Mock;
import org.mockito.Mockito;

public class AdaptiveRecvByteBufAllocatorTest {
    @Mock
    private ChannelConfig config;
    private final ByteBufAllocator alloc = UnpooledByteBufAllocator.DEFAULT;
    private RecvByteBufAllocator.ExtendedHandle handle;

    @BeforeEach
    public void setup() {
        this.config = (ChannelConfig)Mockito.mock(ChannelConfig.class);
        Mockito.when((Object)this.config.isAutoRead()).thenReturn((Object)true);
        AdaptiveRecvByteBufAllocator recvByteBufAllocator = new AdaptiveRecvByteBufAllocator(64, 512, 0xA00000);
        this.handle = (RecvByteBufAllocator.ExtendedHandle)recvByteBufAllocator.newHandle();
        this.handle.reset(this.config);
    }

    @Test
    public void rampUpBeforeReadCompleteWhenLargeDataPending() {
        AdaptiveRecvByteBufAllocatorTest.allocReadExpected(this.handle, this.alloc, 512);
        AdaptiveRecvByteBufAllocatorTest.allocReadExpected(this.handle, this.alloc, 8192);
        AdaptiveRecvByteBufAllocatorTest.allocReadExpected(this.handle, this.alloc, 131072);
        AdaptiveRecvByteBufAllocatorTest.allocReadExpected(this.handle, this.alloc, 0x200000);
        this.handle.readComplete();
        this.handle.reset(this.config);
        AdaptiveRecvByteBufAllocatorTest.allocReadExpected(this.handle, this.alloc, 0x800000);
    }

    @Test
    public void memoryAllocationIntervalsTest() {
        this.computingNext(512L, 512);
        this.computingNext(8192L, 1110);
        this.computingNext(8192L, 1200);
        this.computingNext(4096L, 1300);
        this.computingNext(4096L, 1500);
        this.computingNext(2048L, 1700);
        this.computingNext(2048L, 1550);
        this.computingNext(2048L, 2000);
        this.computingNext(2048L, 1900);
    }

    private void computingNext(long expectedSize, int actualReadBytes) {
        Assertions.assertEquals((long)expectedSize, (long)this.handle.guess());
        this.handle.reset(this.config);
        this.handle.lastBytesRead(actualReadBytes);
        this.handle.readComplete();
    }

    @Test
    public void lastPartialReadDoesNotRampDown() {
        AdaptiveRecvByteBufAllocatorTest.allocReadExpected(this.handle, this.alloc, 512);
        AdaptiveRecvByteBufAllocatorTest.allocRead(this.handle, this.alloc, 8192, 1);
        this.handle.readComplete();
        this.handle.reset(this.config);
        AdaptiveRecvByteBufAllocatorTest.allocReadExpected(this.handle, this.alloc, 8192);
    }

    @Test
    public void lastPartialReadCanRampUp() {
        AdaptiveRecvByteBufAllocatorTest.allocReadExpected(this.handle, this.alloc, 512);
        AdaptiveRecvByteBufAllocatorTest.allocRead(this.handle, this.alloc, 8192, 8191);
        this.handle.readComplete();
        this.handle.reset(this.config);
        AdaptiveRecvByteBufAllocatorTest.allocReadExpected(this.handle, this.alloc, 131072);
    }

    @Test
    public void doesNotExceedMaximum() {
        AdaptiveRecvByteBufAllocator recvByteBufAllocator = new AdaptiveRecvByteBufAllocator(64, 9000, 9000);
        RecvByteBufAllocator.ExtendedHandle handle = (RecvByteBufAllocator.ExtendedHandle)recvByteBufAllocator.newHandle();
        handle.reset(this.config);
        AdaptiveRecvByteBufAllocatorTest.allocReadExpected(handle, this.alloc, 8192);
    }

    @Test
    public void doesSetCorrectMinBounds() {
        AdaptiveRecvByteBufAllocator recvByteBufAllocator = new AdaptiveRecvByteBufAllocator(81, 95, 95);
        RecvByteBufAllocator.ExtendedHandle handle = (RecvByteBufAllocator.ExtendedHandle)recvByteBufAllocator.newHandle();
        handle.reset(this.config);
        AdaptiveRecvByteBufAllocatorTest.allocReadExpected(handle, this.alloc, 81);
    }

    @Test
    public void throwsIfInitialIsBiggerThenMaximum() {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                new AdaptiveRecvByteBufAllocator(64, 4096, 1024);
            }
        });
    }

    @Test
    public void throwsIfInitialIsSmallerThenMinimum() {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                new AdaptiveRecvByteBufAllocator(512, 64, 1024);
            }
        });
    }

    @Test
    public void throwsIfMinimumIsBiggerThenMaximum() {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                new AdaptiveRecvByteBufAllocator(2048, 64, 1024);
            }
        });
    }

    private static void allocReadExpected(RecvByteBufAllocator.ExtendedHandle handle, ByteBufAllocator alloc, int expectedSize) {
        AdaptiveRecvByteBufAllocatorTest.allocRead(handle, alloc, expectedSize, expectedSize);
    }

    private static void allocRead(RecvByteBufAllocator.ExtendedHandle handle, ByteBufAllocator alloc, int expectedBufferSize, int lastRead) {
        ByteBuf buf = handle.allocate(alloc);
        Assertions.assertEquals((int)expectedBufferSize, (int)buf.capacity());
        handle.attemptedBytesRead(expectedBufferSize);
        handle.lastBytesRead(lastRead);
        handle.incMessagesRead(1);
        buf.release();
    }
}

