/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.DefaultEventLoop;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.local.LocalServerChannel;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.Future;
import java.net.SocketAddress;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class ChannelInitializerTest {
    private static final int TIMEOUT_MILLIS = 1000;
    private static final LocalAddress SERVER_ADDRESS = new LocalAddress("addr");
    private EventLoopGroup group;
    private ServerBootstrap server;
    private Bootstrap client;
    private InspectableHandler testHandler;

    @BeforeEach
    public void setUp() {
        this.group = new DefaultEventLoopGroup(1);
        this.server = (ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(this.group).channel(LocalServerChannel.class)).localAddress((SocketAddress)SERVER_ADDRESS);
        this.client = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.group)).channel(LocalChannel.class)).handler((ChannelHandler)new ChannelInboundHandlerAdapter());
        this.testHandler = new InspectableHandler();
    }

    @AfterEach
    public void tearDown() {
        this.group.shutdownGracefully(0L, 1000L, TimeUnit.MILLISECONDS).syncUninterruptibly();
    }

    @Test
    public void testInitChannelThrowsRegisterFirst() {
        this.testInitChannelThrows(true);
    }

    @Test
    public void testInitChannelThrowsRegisterAfter() {
        this.testInitChannelThrows(false);
    }

    private void testInitChannelThrows(boolean registerFirst) {
        final Exception exception = new Exception();
        final AtomicReference causeRef = new AtomicReference();
        ChannelPipeline pipeline = new LocalChannel().pipeline();
        if (registerFirst) {
            this.group.register(pipeline.channel()).syncUninterruptibly();
        }
        pipeline.addFirst(new ChannelHandler[]{new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                throw exception;
            }

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                causeRef.set(cause);
                super.exceptionCaught(ctx, cause);
            }
        }});
        if (!registerFirst) {
            this.group.register(pipeline.channel()).syncUninterruptibly();
        }
        pipeline.channel().close().syncUninterruptibly();
        pipeline.channel().closeFuture().syncUninterruptibly();
        Assertions.assertSame((Object)exception, causeRef.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChannelInitializerInInitializerCorrectOrdering() {
        final ChannelInboundHandlerAdapter handler1 = new ChannelInboundHandlerAdapter();
        final ChannelInboundHandlerAdapter handler2 = new ChannelInboundHandlerAdapter();
        final ChannelInboundHandlerAdapter handler3 = new ChannelInboundHandlerAdapter();
        final ChannelInboundHandlerAdapter handler4 = new ChannelInboundHandlerAdapter();
        ((Bootstrap)this.client.handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) {
                ch.pipeline().addLast(new ChannelHandler[]{handler1});
                ch.pipeline().addLast(new ChannelHandler[]{new ChannelInitializer<Channel>(){

                    protected void initChannel(Channel ch) {
                        ch.pipeline().addLast(new ChannelHandler[]{handler2});
                        ch.pipeline().addLast(new ChannelHandler[]{handler3});
                    }
                }});
                ch.pipeline().addLast(new ChannelHandler[]{handler4});
            }
        })).localAddress((SocketAddress)LocalAddress.ANY);
        Channel channel = this.client.bind().syncUninterruptibly().channel();
        try {
            channel.eventLoop().submit(new Runnable(){

                @Override
                public void run() {
                }
            }).syncUninterruptibly();
            Iterator handlers = channel.pipeline().iterator();
            Assertions.assertSame((Object)handler1, ((Map.Entry)handlers.next()).getValue());
            Assertions.assertSame((Object)handler2, ((Map.Entry)handlers.next()).getValue());
            Assertions.assertSame((Object)handler3, ((Map.Entry)handlers.next()).getValue());
            Assertions.assertSame((Object)handler4, ((Map.Entry)handlers.next()).getValue());
            Assertions.assertFalse((boolean)handlers.hasNext());
        }
        finally {
            channel.close().syncUninterruptibly();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChannelInitializerReentrance() {
        final AtomicInteger registeredCalled = new AtomicInteger(0);
        final ChannelInboundHandlerAdapter handler1 = new ChannelInboundHandlerAdapter(){

            public void channelRegistered(ChannelHandlerContext ctx) {
                registeredCalled.incrementAndGet();
            }
        };
        final AtomicInteger initChannelCalled = new AtomicInteger(0);
        ((Bootstrap)this.client.handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) {
                initChannelCalled.incrementAndGet();
                ch.pipeline().addLast(new ChannelHandler[]{handler1});
                ch.pipeline().fireChannelRegistered();
            }
        })).localAddress((SocketAddress)LocalAddress.ANY);
        Channel channel = this.client.bind().syncUninterruptibly().channel();
        try {
            channel.eventLoop().submit(new Runnable(){

                @Override
                public void run() {
                }
            }).syncUninterruptibly();
            Assertions.assertEquals((int)1, (int)initChannelCalled.get());
            Assertions.assertEquals((int)2, (int)registeredCalled.get());
        }
        finally {
            channel.close().syncUninterruptibly();
        }
    }

    @Test
    @Timeout(value=1000L, unit=TimeUnit.MILLISECONDS)
    public void firstHandlerInPipelineShouldReceiveChannelRegisteredEvent() {
        this.testChannelRegisteredEventPropagation(new ChannelInitializer<LocalChannel>(){

            public void initChannel(LocalChannel channel) {
                channel.pipeline().addFirst(new ChannelHandler[]{ChannelInitializerTest.this.testHandler});
            }
        });
    }

    @Test
    @Timeout(value=1000L, unit=TimeUnit.MILLISECONDS)
    public void lastHandlerInPipelineShouldReceiveChannelRegisteredEvent() {
        this.testChannelRegisteredEventPropagation(new ChannelInitializer<LocalChannel>(){

            public void initChannel(LocalChannel channel) {
                channel.pipeline().addLast(new ChannelHandler[]{ChannelInitializerTest.this.testHandler});
            }
        });
    }

    @Test
    public void testAddFirstChannelInitializer() {
        ChannelInitializerTest.testAddChannelInitializer(true);
    }

    @Test
    public void testAddLastChannelInitializer() {
        ChannelInitializerTest.testAddChannelInitializer(false);
    }

    private static void testAddChannelInitializer(final boolean first) {
        final AtomicBoolean called = new AtomicBoolean();
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) {
                ChannelInitializer<Channel> handler = new ChannelInitializer<Channel>(){

                    protected void initChannel(Channel ch) {
                        called.set(true);
                    }
                };
                if (first) {
                    ch.pipeline().addFirst(new ChannelHandler[]{handler});
                } else {
                    ch.pipeline().addLast(new ChannelHandler[]{handler});
                }
            }
        }});
        channel.finish();
        Assertions.assertTrue((boolean)called.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testChannelRegisteredEventPropagation(ChannelInitializer<LocalChannel> init) {
        Channel clientChannel = null;
        Channel serverChannel = null;
        try {
            this.server.childHandler(init);
            serverChannel = this.server.bind().syncUninterruptibly().channel();
            clientChannel = this.client.connect((SocketAddress)SERVER_ADDRESS).syncUninterruptibly().channel();
            Assertions.assertEquals((int)1, (int)this.testHandler.channelRegisteredCount.get());
        }
        catch (Throwable throwable) {
            ChannelInitializerTest.closeChannel(clientChannel);
            ChannelInitializerTest.closeChannel(serverChannel);
            throw throwable;
        }
        ChannelInitializerTest.closeChannel(clientChannel);
        ChannelInitializerTest.closeChannel(serverChannel);
    }

    @Test
    @Timeout(value=10000L, unit=TimeUnit.MILLISECONDS)
    public void testChannelInitializerEventExecutor() throws Throwable {
        AtomicInteger invokeCount = new AtomicInteger();
        AtomicInteger completeCount = new AtomicInteger();
        AtomicReference errorRef = new AtomicReference();
        LocalAddress addr = new LocalAddress("test");
        DefaultEventLoop executor = new DefaultEventLoop(){
            private final ScheduledExecutorService execService = Executors.newSingleThreadScheduledExecutor();
            private Thread thread;

            public void shutdown() {
                this.execService.shutdown();
            }

            public synchronized boolean inEventLoop(Thread thread) {
                if (thread == null) {
                    thread = Thread.currentThread();
                    return false;
                }
                boolean result = thread == Thread.currentThread();
                thread = null;
                return result;
            }

            public boolean isShuttingDown() {
                return false;
            }

            public Future<?> shutdownGracefully(long quietPeriod, long timeout, TimeUnit unit) {
                throw new IllegalStateException();
            }

            public Future<?> terminationFuture() {
                throw new IllegalStateException();
            }

            public boolean isShutdown() {
                return this.execService.isShutdown();
            }

            public boolean isTerminated() {
                return this.execService.isTerminated();
            }

            public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
                return this.execService.awaitTermination(timeout, unit);
            }

            public void execute(Runnable command) {
                this.execService.execute(command);
            }
        };
        CountDownLatch latch = new CountDownLatch(1);
        ServerBootstrap serverBootstrap = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().channel(LocalServerChannel.class)).group(this.group).localAddress((SocketAddress)addr)).childHandler((ChannelHandler)new ChannelInitializer<LocalChannel>((EventExecutor)executor, invokeCount, latch, completeCount, errorRef){
            final /* synthetic */ EventExecutor val$executor;
            final /* synthetic */ AtomicInteger val$invokeCount;
            final /* synthetic */ CountDownLatch val$latch;
            final /* synthetic */ AtomicInteger val$completeCount;
            final /* synthetic */ AtomicReference val$errorRef;
            {
                this.val$executor = eventExecutor;
                this.val$invokeCount = atomicInteger;
                this.val$latch = countDownLatch;
                this.val$completeCount = atomicInteger2;
                this.val$errorRef = atomicReference;
            }

            protected void initChannel(LocalChannel ch) {
                ch.pipeline().addLast((EventExecutorGroup)this.val$executor, new ChannelHandler[]{new ChannelInitializer<Channel>(){

                    protected void initChannel(Channel ch) {
                        val$invokeCount.incrementAndGet();
                        ChannelHandlerContext ctx = ch.pipeline().context((ChannelHandler)this);
                        Assertions.assertNotNull((Object)ctx);
                        ch.pipeline().addAfter((EventExecutorGroup)ctx.executor(), ctx.name(), null, (ChannelHandler)new ChannelInboundHandlerAdapter(){

                            public void channelRead(ChannelHandlerContext ctx, Object msg) {
                            }

                            public void handlerRemoved(ChannelHandlerContext ctx) {
                                val$latch.countDown();
                            }
                        });
                        val$completeCount.incrementAndGet();
                    }

                    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                        if (cause instanceof AssertionError) {
                            val$errorRef.set(cause);
                        }
                    }
                }});
            }
        });
        Channel server = serverBootstrap.bind().sync().channel();
        Bootstrap clientBootstrap = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().channel(LocalChannel.class)).group(this.group)).remoteAddress((SocketAddress)addr).handler((ChannelHandler)new ChannelInboundHandlerAdapter());
        Channel client = clientBootstrap.connect().sync().channel();
        client.writeAndFlush((Object)"Hello World").sync();
        client.close().sync();
        server.close().sync();
        client.closeFuture().sync();
        server.closeFuture().sync();
        latch.await();
        Assertions.assertEquals((int)1, (int)invokeCount.get());
        Assertions.assertEquals((int)invokeCount.get(), (int)completeCount.get());
        Throwable cause = (Throwable)errorRef.get();
        if (cause != null) {
            throw cause;
        }
        executor.shutdown();
        Assertions.assertTrue((boolean)executor.awaitTermination(5L, TimeUnit.SECONDS));
    }

    private static void closeChannel(Channel c) {
        if (c != null) {
            c.close().syncUninterruptibly();
        }
    }

    private static final class InspectableHandler
    extends ChannelDuplexHandler {
        final AtomicInteger channelRegisteredCount = new AtomicInteger(0);

        private InspectableHandler() {
        }

        public void channelRegistered(ChannelHandlerContext ctx) {
            this.channelRegisteredCount.incrementAndGet();
            ctx.fireChannelRegistered();
        }
    }
}

