/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelId;
import io.netty.channel.DefaultChannelId;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DefaultChannelIdTest {
    @Test
    public void testShortText() {
        String text = DefaultChannelId.newInstance().asShortText();
        Assertions.assertTrue((boolean)text.matches("^[0-9a-f]{8}$"));
    }

    @Test
    public void testLongText() {
        String text = DefaultChannelId.newInstance().asLongText();
        Assertions.assertTrue((boolean)text.matches("^[0-9a-f]{16}-[0-9a-f]{8}-[0-9a-f]{8}-[0-9a-f]{16}-[0-9a-f]{8}$"));
    }

    @Test
    public void testIdempotentMachineId() {
        String a = DefaultChannelId.newInstance().asLongText().substring(0, 16);
        String b = DefaultChannelId.newInstance().asLongText().substring(0, 16);
        Assertions.assertEquals((Object)a, (Object)b);
    }

    @Test
    public void testIdempotentProcessId() {
        String a = DefaultChannelId.newInstance().asLongText().substring(17, 21);
        String b = DefaultChannelId.newInstance().asLongText().substring(17, 21);
        Assertions.assertEquals((Object)a, (Object)b);
    }

    @Test
    public void testSerialization() throws Exception {
        ChannelId b;
        DefaultChannelId a = DefaultChannelId.newInstance();
        ByteBuf buf = Unpooled.buffer();
        try (ObjectOutputStream out = new ObjectOutputStream((OutputStream)new ByteBufOutputStream(buf));){
            out.writeObject(a);
            out.flush();
        }
        try (ObjectInputStream in = new ObjectInputStream((InputStream)new ByteBufInputStream(buf, true));){
            b = (ChannelId)in.readObject();
        }
        Assertions.assertEquals((Object)a, (Object)b);
        Assertions.assertNotSame((Object)a, (Object)b);
        Assertions.assertEquals((Object)a.asLongText(), (Object)b.asLongText());
    }

    @Test
    public void testDeserialization() throws Exception {
        DefaultChannelId c8 = new DefaultChannelId(new byte[]{1, 35, 69, 103, -119, -85, -51, -17}, 21167, 0, 454950851378987910L, -647700642);
        DefaultChannelId c6 = new DefaultChannelId(new byte[]{1, 35, 69, 103, -119, -85}, -838839677, 1, 476939344741159279L, 1914132407);
        Assertions.assertEquals((Object)"0123456789abcdef-000052af-00000000-06504f638eb4c386-d964df5e", (Object)c8.asLongText());
        Assertions.assertEquals((Object)"0123456789ab-ce005283-00000001-069e6dce9eb4516f-721757b7", (Object)c6.asLongText());
    }
}

